/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.onetomany;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.onetomany.IndexedAssociationTableManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.ManyRelationDescriptor;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.bean.Objects;

public class IndexedAssociationTableManyRelationDescriptor<SRC, TRGT, C extends Collection<TRGT>, SRCID>
extends ManyRelationDescriptor<SRC, TRGT, C> {
    public IndexedAssociationTableManyRelationDescriptor(Function<SRC, C> collectionGetter, BiConsumer<SRC, C> collectionSetter, Supplier<C> collectionFactory, @Nullable BiConsumer<TRGT, SRC> reverseSetter, Function<SRC, SRCID> idProvider) {
        super(collectionGetter, collectionSetter, collectionFactory, reverseSetter);
        this.relationFixer = new InMemoryRelationHolder(idProvider);
    }

    public class InMemoryRelationHolder
    implements BeanRelationFixer<SRC, TRGT> {
        private final ThreadLocal<Map<SRCID, org.codefilarete.stalactite.engine.runtime.onetomany.IndexedAssociationTableManyRelationDescriptor$InMemoryRelationHolder.CollectionOrderStorage>> currentSelectedIndexes = new ThreadLocal();
        private final Function<SRC, SRCID> idProvider;

        public InMemoryRelationHolder(Function<SRC, SRCID> idProvider) {
            this.idProvider = idProvider;
        }

        public void addIndex(SRCID leftEntityId, TRGT trgt, int index) {
            ((CollectionOrderStorage)this.currentSelectedIndexes.get().get(leftEntityId)).targetPerIndex.put(index, trgt);
        }

        public void apply(SRC source, TRGT input) {
            this.currentSelectedIndexes.get().computeIfAbsent(this.idProvider.apply(source), srcid -> new CollectionOrderStorage());
            ((BiConsumer)Objects.preventNull(IndexedAssociationTableManyRelationDescriptor.this.getReverseSetter(), (Object)ManyRelationDescriptor.NOOP_REVERSE_SETTER)).accept(input, source);
        }

        public void init() {
            this.currentSelectedIndexes.set(new HashMap());
        }

        public void clear() {
            this.currentSelectedIndexes.remove();
        }

        public void applySort(Set<? extends SRC> result) {
            result.forEach(src -> {
                CollectionOrderStorage inMemoryCollection = (CollectionOrderStorage)this.currentSelectedIndexes.get().get(this.idProvider.apply(src));
                if (inMemoryCollection != null) {
                    Map targetIdPerId = inMemoryCollection.targetPerIndex;
                    Collection relationCollection = (Collection)IndexedAssociationTableManyRelationDescriptor.this.getCollectionGetter().apply(src);
                    if (relationCollection == null) {
                        relationCollection = (Collection)IndexedAssociationTableManyRelationDescriptor.this.getCollectionFactory().get();
                        IndexedAssociationTableManyRelationDescriptor.this.getCollectionSetter().accept(src, relationCollection);
                    }
                    relationCollection.addAll(new LinkedList(targetIdPerId.values()));
                }
            });
        }

        private class CollectionOrderStorage {
            private final Map<Integer, TRGT> targetPerIndex = new HashMap();

            private CollectionOrderStorage() {
            }
        }
    }
}

