/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.junit.jupiter.api.Test;

class ForeignKeyNamingStrategyTest {
    ForeignKeyNamingStrategyTest() {
    }

    @Test
    void hash_2FK_targetColumnsHaveSameName_hashMustBeDifferent() {
        Table leftTable = new Table("leftTable");
        Column leftAColumn = leftTable.addColumn("a", String.class);
        Column leftBColumn = leftTable.addColumn("b", String.class);
        Table rightTable = new Table("rightTable");
        Column rightAColumn = rightTable.addColumn("a", String.class);
        Column rightBColumn = rightTable.addColumn("b", String.class);
        Table associationTable = new Table("associationTable");
        Column AColumn = associationTable.addColumn("left_a", String.class);
        Column BColumn = associationTable.addColumn("left_b", String.class);
        Column XColumn = associationTable.addColumn("right_a", String.class);
        Column YColumn = associationTable.addColumn("right_b", String.class);
        String fk1 = ForeignKeyNamingStrategy.HASH.giveName(Key.from((Fromable)associationTable).addColumn((JoinLink)AColumn).addColumn((JoinLink)BColumn).build(), Key.from((Fromable)leftTable).addColumn((JoinLink)leftAColumn).addColumn((JoinLink)leftBColumn).build());
        String fk2 = ForeignKeyNamingStrategy.HASH.giveName(Key.from((Fromable)associationTable).addColumn((JoinLink)XColumn).addColumn((JoinLink)YColumn).build(), Key.from((Fromable)leftTable).addColumn((JoinLink)rightAColumn).addColumn((JoinLink)rightBColumn).build());
        Assertions.assertThat((String)fk1).isNotEqualTo((Object)fk2);
    }
}

