/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.MapBasedColumnedRow;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class EntityTreeInflaterTest {
    EntityTreeInflaterTest() {
    }

    @Test
    void transform_doesntGoDeeperIfRelatedBeanIdIsNull() {
        Table leftTable = new Table("leftTable");
        leftTable.addColumn("pk", Long.TYPE).primaryKey();
        PrimaryKey leftTablePk = leftTable.getPrimaryKey();
        Table rightTable = new Table("rightTable");
        leftTable.addColumn("pk", Long.TYPE).primaryKey();
        PrimaryKey rightTablePk = leftTable.getPrimaryKey();
        Key rightTableFkToLeftTable = Key.ofSingleColumn((JoinLink)leftTable.addColumn("fkToLeftTable", Long.TYPE));
        Table rightMostTable = new Table("rightMostTable");
        leftTable.addColumn("pk", Long.TYPE).primaryKey();
        PrimaryKey rightMostTablePk = leftTable.getPrimaryKey();
        Key rightMostTableFkToRightTable = Key.ofSingleColumn((JoinLink)leftTable.addColumn("fkToRightTable", Long.TYPE));
        EntityInflater leftEntityInflater = (EntityInflater)Mockito.mock(EntityInflater.class);
        Mockito.when((Object)leftEntityInflater.giveIdentifier((ColumnedRow)ArgumentMatchers.any())).thenReturn((Object)42);
        Mockito.when((Object)leftEntityInflater.getEntityType()).thenReturn(Object.class);
        RowTransformer rightEntityBuilder = (RowTransformer)Mockito.mock(RowTransformer.class);
        Mockito.when((Object)rightEntityBuilder.transform((ColumnedRow)ArgumentMatchers.any())).thenReturn(new Object());
        Mockito.when((Object)leftEntityInflater.getRowTransformer()).thenReturn((Object)rightEntityBuilder);
        EntityInflater rightEntityInflater = (EntityInflater)Mockito.mock(EntityInflater.class);
        Mockito.when((Object)rightEntityInflater.giveIdentifier((ColumnedRow)ArgumentMatchers.any())).thenReturn(null);
        BeanRelationFixer relationFixer = (BeanRelationFixer)Mockito.mock(BeanRelationFixer.class);
        EntityInflater rightMostEntityInflater = (EntityInflater)Mockito.mock(EntityInflater.class);
        RowTransformer rightMostRowTransformerMock = (RowTransformer)Mockito.mock(RowTransformer.class);
        Mockito.when((Object)rightMostEntityInflater.getRowTransformer()).thenReturn((Object)rightMostRowTransformerMock);
        EntityJoinTree entityJoinTree = new EntityJoinTree(leftEntityInflater, (Fromable)leftTable);
        String joinName = entityJoinTree.addRelationJoin("ROOT", rightEntityInflater, (Key)leftTablePk, rightTableFkToLeftTable, null, EntityJoinTree.JoinType.OUTER, relationFixer, Collections.emptySet());
        entityJoinTree.addRelationJoin(joinName, rightMostEntityInflater, (Key)rightTablePk, rightMostTableFkToRightTable, null, EntityJoinTree.JoinType.OUTER, (BeanRelationFixer)Mockito.mock(BeanRelationFixer.class), Collections.emptySet());
        EntityTreeQueryBuilder.EntityTreeQuery entityTreeQuery = new EntityTreeQueryBuilder(entityJoinTree, (ResultSetReaderRegistry)new DefaultDialect().getColumnBinderRegistry()).buildSelectQuery();
        EntityTreeInflater testInstance = entityTreeQuery.getInflater();
        MapBasedColumnedRow databaseData = new MapBasedColumnedRow().add("leftTable_pk", (Object)1).add("rightTable_fkToLeftTable", null).add("rightTable_pk", null);
        testInstance.transform((Iterable)Arrays.asList((Object[])new MapBasedColumnedRow[]{databaseData}), 5);
        ((EntityInflater)Mockito.verify((Object)rightEntityInflater, (VerificationMode)Mockito.times((int)2))).giveIdentifier((ColumnedRow)ArgumentMatchers.any());
        ((EntityInflater)Mockito.verify((Object)rightMostEntityInflater, (VerificationMode)Mockito.times((int)0))).giveIdentifier((ColumnedRow)ArgumentMatchers.any());
        ((RowTransformer)Mockito.verify((Object)rightMostRowTransformerMock, (VerificationMode)Mockito.times((int)0))).transform((ColumnedRow)ArgumentMatchers.any());
        ((BeanRelationFixer)Mockito.verify((Object)relationFixer, (VerificationMode)Mockito.times((int)0))).apply(ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    void foreachNode_iteratesInstancesInSameOrderAsJoins_fullTree() {
        Root root = new Root();
        Entity1 entity1 = new Entity1();
        Entity11 entity11 = new Entity11();
        Entity111 entity111 = new Entity111();
        Entity1111 entity1111 = new Entity1111();
        Entity12 entity12 = new Entity12();
        Entity2 entity2 = new Entity2();
        Entity3 entity3 = new Entity3();
        EntityTreeInflater.ConsumerNode consumerRoot = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(root));
        EntityTreeInflater.ConsumerNode consumerNode1 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity1));
        EntityTreeInflater.ConsumerNode consumerNode11 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity11));
        EntityTreeInflater.ConsumerNode consumerNode111 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity111));
        EntityTreeInflater.ConsumerNode consumerNode1111 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity1111));
        EntityTreeInflater.ConsumerNode consumerNode12 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity12));
        EntityTreeInflater.ConsumerNode consumerNode2 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity2));
        EntityTreeInflater.ConsumerNode consumerNode3 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity3));
        consumerRoot.addConsumer(consumerNode2);
        consumerRoot.addConsumer(consumerNode3);
        consumerRoot.addConsumer(consumerNode1);
        consumerNode1.addConsumer(consumerNode12);
        consumerNode1.addConsumer(consumerNode11);
        consumerNode11.addConsumer(consumerNode111);
        consumerNode111.addConsumer(consumerNode1111);
        EntityTreeInflater testInstance = new EntityTreeInflater(consumerRoot, null);
        final ArrayList entityStackHistory = new ArrayList();
        testInstance.foreachNode((Collection)Arrays.asList((Object[])new EntityTreeInflater.ConsumerNode[]{consumerRoot}), new EntityTreeInflater.NodeVisitor(root){

            EntityTreeInflater.NodeVisitor.EntityCreationResult apply(EntityTreeInflater.ConsumerNode joinRowConsumer, Object parentEntity) {
                ArrayList<Object> newStack = new ArrayList<Object>((Collection)Iterables.last((List)entityStackHistory, new ArrayList()));
                newStack.add(parentEntity);
                entityStackHistory.add(newStack);
                if (joinRowConsumer.getConsumer() instanceof DummyConsumerNode.DummyJoinRowConsumer) {
                    return new EntityTreeInflater.NodeVisitor.EntityCreationResult(((DummyConsumerNode.DummyJoinRowConsumer)joinRowConsumer.getConsumer()).get(), joinRowConsumer);
                }
                throw new UnsupportedOperationException("Something has changed in test data");
            }
        });
        ArrayList<List> expectedEntityStackHistory = new ArrayList<List>();
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1, entity11}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1, entity11, entity111}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1, entity11, entity111, entity1}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1, entity11, entity111, entity1, root}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1, entity11, entity111, entity1, root, root}));
        Assertions.assertThat(entityStackHistory).isEqualTo(expectedEntityStackHistory);
    }

    @Test
    void foreachNode_iteratesInstancesInSameOrderAsJoins_partialTree() {
        Root root = new Root();
        Entity1 entity1 = new Entity1();
        Entity11 entity11 = new Entity11();
        Entity111 entity111 = new Entity111();
        Entity1111 entity1111 = new Entity1111();
        Entity12 entity12 = new Entity12();
        Entity2 entity2 = new Entity2();
        Entity3 entity3 = new Entity3();
        EntityTreeInflater.ConsumerNode consumerRoot = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(root));
        EntityTreeInflater.ConsumerNode consumerNode1 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity1));
        EntityTreeInflater.ConsumerNode consumerNode11 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity11));
        EntityTreeInflater.ConsumerNode consumerNode111 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(null));
        EntityTreeInflater.ConsumerNode consumerNode1111 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity1111));
        EntityTreeInflater.ConsumerNode consumerNode12 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity12));
        EntityTreeInflater.ConsumerNode consumerNode2 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity2));
        EntityTreeInflater.ConsumerNode consumerNode3 = new EntityTreeInflater.ConsumerNode((JoinRowConsumer)new DummyConsumerNode.DummyJoinRowConsumer(entity3));
        consumerRoot.addConsumer(consumerNode2);
        consumerRoot.addConsumer(consumerNode3);
        consumerRoot.addConsumer(consumerNode1);
        consumerNode1.addConsumer(consumerNode12);
        consumerNode1.addConsumer(consumerNode11);
        consumerNode11.addConsumer(consumerNode111);
        consumerNode111.addConsumer(consumerNode1111);
        EntityTreeInflater testInstance = new EntityTreeInflater(consumerRoot, null);
        final ArrayList entityStackHistory = new ArrayList();
        testInstance.foreachNode((Collection)Arrays.asList((Object[])new EntityTreeInflater.ConsumerNode[]{consumerRoot}), new EntityTreeInflater.NodeVisitor(root){

            EntityTreeInflater.NodeVisitor.EntityCreationResult apply(EntityTreeInflater.ConsumerNode joinRowConsumer, Object parentEntity) {
                ArrayList<Object> newStack = new ArrayList<Object>((Collection)Iterables.last((List)entityStackHistory, new ArrayList()));
                newStack.add(parentEntity);
                entityStackHistory.add(newStack);
                if (joinRowConsumer.getConsumer() instanceof DummyConsumerNode.DummyJoinRowConsumer) {
                    return new EntityTreeInflater.NodeVisitor.EntityCreationResult(((DummyConsumerNode.DummyJoinRowConsumer)joinRowConsumer.getConsumer()).get(), joinRowConsumer);
                }
                throw new UnsupportedOperationException("Something has changed in test data");
            }
        });
        ArrayList<List> expectedEntityStackHistory = new ArrayList<List>();
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1, entity11}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1, entity11, entity1}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1, entity11, entity1, root}));
        expectedEntityStackHistory.add(Arrays.asList((Object[])new Object[]{root, root, entity1, entity11, entity1, root, root}));
        Assertions.assertThat(entityStackHistory).isEqualTo(expectedEntityStackHistory);
    }

    private static class DummyConsumerNode
    extends EntityTreeInflater.ConsumerNode {
        DummyConsumerNode(Object entity) {
            super((JoinRowConsumer)new DummyJoinRowConsumer(entity));
        }

        private static class DummyJoinRowConsumer
        implements JoinRowConsumer,
        Supplier<Object> {
            private final Object entity;

            DummyJoinRowConsumer(Object entity) {
                this.entity = entity;
            }

            @Override
            public Object get() {
                return this.entity;
            }

            public JoinNode<?> getNode() {
                throw new RuntimeException("This method is not expected to be called in this test");
            }
        }
    }

    static class Entity3 {
        Entity3() {
        }
    }

    static class Entity2 {
        Entity2() {
        }
    }

    static class Entity12 {
        Entity12() {
        }
    }

    static class Entity1111 {
        Entity1111() {
        }
    }

    static class Entity111 {
        Entity111() {
        }
    }

    static class Entity11 {
        Entity11() {
        }
    }

    static class Entity1 {
        Entity1() {
        }
    }

    static class Root {
        Root() {
        }
    }

    @Nested
    class RelationIdentifierTest {
        private Entity1 rootEntityReference;
        private EntityTreeInflater.RelationIdentifier reference;
        private RelationJoinNode.RelationJoinRowConsumer rowConsumerReference;

        RelationIdentifierTest() {
        }

        @BeforeEach
        void init() {
            this.rowConsumerReference = (RelationJoinNode.RelationJoinRowConsumer)Mockito.mock(RelationJoinNode.RelationJoinRowConsumer.class);
            this.rootEntityReference = new Entity1();
            this.reference = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity1.class, (Object)1, this.rowConsumerReference);
        }

        @Test
        void equals_verySameInstance() {
            Assertions.assertThat((Object)this.reference).isEqualTo((Object)this.reference);
        }

        @Test
        void equals_instanceWithSameValues() {
            EntityTreeInflater.RelationIdentifier id2 = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity1.class, (Object)1, this.rowConsumerReference);
            Assertions.assertThat((Object)this.reference).isEqualTo((Object)id2);
        }

        @Test
        void equals_instancesDifferOnIdentifier() {
            EntityTreeInflater.RelationIdentifier id3 = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity1.class, (Object)2, this.rowConsumerReference);
            Assertions.assertThat((Object)this.reference).isNotEqualTo((Object)id3);
        }

        @Test
        void equals_instancesDifferIdentifierWithOverriddenEquals() {
            EntityTreeInflater.RelationIdentifier id7 = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity1.class, new Object(){

                public boolean equals(Object obj) {
                    return true;
                }
            }, this.rowConsumerReference);
            Assertions.assertThat((Object)id7).isEqualTo((Object)this.reference);
        }

        @Test
        void equals_instancesDifferOnRoot() {
            EntityTreeInflater.RelationIdentifier id4 = new EntityTreeInflater.RelationIdentifier(new Object(), Entity1.class, (Object)1, this.rowConsumerReference);
            Assertions.assertThat((Object)this.reference).isNotEqualTo((Object)id4);
        }

        @Test
        void equals_instancesDifferOnEntityType() {
            EntityTreeInflater.RelationIdentifier id5 = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity2.class, (Object)1, this.rowConsumerReference);
            Assertions.assertThat((Object)this.reference).isNotEqualTo((Object)id5);
        }

        @Test
        void equals_instancesDifferOnNode() {
            RelationJoinNode.RelationJoinRowConsumer rowConsumer2 = (RelationJoinNode.RelationJoinRowConsumer)Mockito.mock(RelationJoinNode.RelationJoinRowConsumer.class);
            EntityTreeInflater.RelationIdentifier id6 = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity1.class, (Object)1, rowConsumer2);
            Assertions.assertThat((Object)this.reference).isNotEqualTo((Object)id6);
        }

        @Test
        void hashCode_verySameInstance() {
            Assertions.assertThat((int)this.reference.hashCode()).isEqualTo(this.reference.hashCode());
        }

        @Test
        void hashCode_instanceWithSameValues() {
            EntityTreeInflater.RelationIdentifier id2 = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity1.class, (Object)1, this.rowConsumerReference);
            Assertions.assertThat((int)this.reference.hashCode()).isEqualTo(id2.hashCode());
        }

        @Test
        void hashCode_instancesDifferOnIdentifier() {
            EntityTreeInflater.RelationIdentifier id3 = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity1.class, (Object)2, this.rowConsumerReference);
            Assertions.assertThat((int)this.reference.hashCode()).isNotEqualTo(id3.hashCode());
        }

        @Test
        void hashCode_instancesDifferOnRoot() {
            EntityTreeInflater.RelationIdentifier id4 = new EntityTreeInflater.RelationIdentifier(new Object(), Entity1.class, (Object)1, this.rowConsumerReference);
            Assertions.assertThat((int)this.reference.hashCode()).isNotEqualTo(id4.hashCode());
        }

        @Test
        void hashCode_instancesDifferOnEntityType() {
            EntityTreeInflater.RelationIdentifier id5 = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity2.class, (Object)1, this.rowConsumerReference);
            Assertions.assertThat((int)this.reference.hashCode()).isNotEqualTo(id5.hashCode());
        }

        @Test
        void hashCode_instancesDifferOnNode() {
            RelationJoinNode.RelationJoinRowConsumer rowConsumer2 = (RelationJoinNode.RelationJoinRowConsumer)Mockito.mock(RelationJoinNode.RelationJoinRowConsumer.class);
            EntityTreeInflater.RelationIdentifier id6 = new EntityTreeInflater.RelationIdentifier((Object)this.rootEntityReference, Entity1.class, (Object)1, rowConsumer2);
            Assertions.assertThat((int)this.reference.hashCode()).isNotEqualTo(id6.hashCode());
        }
    }
}

