/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.stalactite.sql.statement.binder.InMemoryBlobSupport;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.io.IOs;
import org.junit.jupiter.api.Test;

class InMemoryBlobSupportTest {
    InMemoryBlobSupportTest() {
    }

    @Test
    void length() throws SQLException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport(3);
        Assertions.assertThat((long)testInstance.length()).isEqualTo(3L);
    }

    @Test
    void getBytes() throws SQLException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello".getBytes());
        Assertions.assertThat((String)new String(testInstance.getBytes(2L, 3))).isEqualTo("ell");
    }

    @Test
    void getBinaryStream() throws SQLException, IOException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello".getBytes());
        Assertions.assertThat((String)new String(IOs.toByteArray((InputStream)testInstance.getBinaryStream()))).isEqualTo("Hello");
    }

    @Test
    void getBinaryStream_offsetAndLength() throws SQLException, IOException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello".getBytes());
        Assertions.assertThat((String)new String(IOs.toByteArray((InputStream)testInstance.getBinaryStream(2L, 3L)))).isEqualTo("ell");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.getBinaryStream(2L, 55L)).extracting(t -> (SQLException)Exceptions.findExceptionInCauses((Throwable)t, SQLException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Incompatible position or length with actual byte count : 5 vs 2 + 55");
    }

    @Test
    void position() throws SQLException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        Assertions.assertThat((long)testInstance.position("ell".getBytes(), 1L)).isEqualTo(2L);
        Assertions.assertThat((long)testInstance.position("ld !".getBytes(), 3L)).isEqualTo(10L);
    }

    @Test
    void position_blob() throws SQLException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        Assertions.assertThat((long)testInstance.position((Blob)new InMemoryBlobSupport("ell".getBytes()), 1L)).isEqualTo(2L);
        Assertions.assertThat((long)testInstance.position((Blob)new InMemoryBlobSupport("ld !".getBytes()), 3L)).isEqualTo(10L);
    }

    @Test
    void setBytes() throws SQLException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBytes(7L, "Lord ".getBytes());
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello Lord  !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBytes(7L, "Sir   ".getBytes());
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello Sir   !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBytes(10L, "ms".getBytes());
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello worms !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBytes(7L, "everybody !".getBytes());
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello everybody !");
    }

    @Test
    void setBytes_offsetAndLength() throws SQLException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBytes(7L, "Lord Sir   ms".getBytes(), 0, 5);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello Lord  !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBytes(7L, "Lord Sir   ms".getBytes(), 5, 5);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello Sir   !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBytes(10L, "Lord Sir   ms".getBytes(), 11, 2);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello worms !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBytes(7L, "everybody !".getBytes(), 0, 11);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello everybody !");
    }

    @Test
    void setBinaryStream() throws SQLException, IOException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBinaryStream(7L).write("Lord Sir   ms".getBytes(), 0, 5);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello Lord  !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBinaryStream(7L).write("Lord Sir   ms".getBytes(), 5, 5);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello Sir   !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBinaryStream(10L).write("Lord Sir   ms".getBytes(), 11, 2);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello worms !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.setBinaryStream(7L).write("everybody !".getBytes(), 0, 11);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello everybody !");
    }

    @Test
    void truncate() throws SQLException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.truncate(5L);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.truncate(50L);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello world !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.truncate(testInstance.length());
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello world !");
        testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.truncate(testInstance.length() - 1L);
        Assertions.assertThat((String)new String(testInstance.getBuffer())).isEqualTo("Hello world ");
    }

    @Test
    void free() throws SQLException {
        InMemoryBlobSupport testInstance = new InMemoryBlobSupport("Hello world !".getBytes());
        testInstance.free();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((InMemoryBlobSupport)testInstance).getBinaryStream()).extracting(t -> (SQLException)Exceptions.findExceptionInCauses((Throwable)t, SQLException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Blob data is no more available because it was freed");
    }
}

