/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.singletable;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.DeleteExecutor;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityMappingWrapper;
import org.codefilarete.stalactite.engine.runtime.FirstPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.PersisterWrapper;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.stalactite.engine.runtime.RelationIds;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SecondPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.SingleTablePolymorphicRelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.singletable.SingleTablePolymorphismEntityFinder;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;

public class SingleTablePolymorphismPersister<C, I, T extends Table<T>, DTYPE>
extends AbstractPolymorphismPersister<C, I> {
    private static final ThreadLocal<Queue<Set<RelationIds<Object, Object, Object>>>> DIFFERED_ENTITY_LOADER = new ThreadLocal();
    private final Column<T, DTYPE> discriminatorColumn;
    private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;

    public SingleTablePolymorphismPersister(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, ConnectionProvider connectionProvider, Dialect dialect, final Column<T, DTYPE> discriminatorColumn, final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy) {
        super(mainPersister, subEntitiesPersisters, new SingleTablePolymorphismEntityFinder<C, I, T, DTYPE>(mainPersister, subEntitiesPersisters, discriminatorColumn, polymorphismPolicy, connectionProvider, dialect));
        this.discriminatorColumn = discriminatorColumn;
        this.polymorphismPolicy = polymorphismPolicy;
        Mapping.ShadowColumnValueProvider discriminatorValueProvider = new Mapping.ShadowColumnValueProvider<C, T>(){

            public Set<Column<T, ?>> getColumns() {
                return Arrays.asHashSet((Object[])new Column[]{discriminatorColumn});
            }

            public Map<Column<T, ?>, ?> giveValue(C bean) {
                HashMap result = new HashMap();
                result.put(discriminatorColumn, polymorphismPolicy.getDiscriminatorValue(bean.getClass()));
                return result;
            }
        };
        this.subEntitiesPersisters.values().forEach(arg_0 -> SingleTablePolymorphismPersister.lambda$new$0((Mapping.ShadowColumnValueProvider)discriminatorValueProvider, arg_0));
        subEntitiesPersisters.forEach((type, persister) -> mainPersister.copyRootJoinsTo(persister.getEntityJoinTree(), "ROOT"));
    }

    @Override
    public void registerRelation(ValueAccessPoint<C> relation, ConfiguredRelationalPersister<?, ?> persister) {
        this.criteriaSupport.registerRelation(relation, persister);
    }

    @Override
    public Column getColumn(List<? extends ValueAccessPoint<?>> accessorChain) {
        return this.criteriaSupport.getRootConfiguration().giveColumn(accessorChain);
    }

    @Override
    public Set<Class<? extends C>> getSupportedEntityTypes() {
        HashSet result = new HashSet();
        this.subEntitiesPersisters.forEach((c, p) -> {
            if (p instanceof PolymorphicPersister) {
                result.addAll(((PolymorphicPersister)((Object)p)).getSupportedEntityTypes());
            } else if (p instanceof PersisterWrapper && ((PersisterWrapper)p).getDeepestDelegate() instanceof PolymorphicPersister) {
                result.addAll(((PolymorphicPersister)((Object)((PersisterWrapper)p).getDeepestDelegate())).getSupportedEntityTypes());
            } else {
                result.add((Class)c);
            }
        });
        return result;
    }

    public Collection<Table<?>> giveImpliedTables() {
        Set subTables = this.subEntitiesPersisters.values().stream().flatMap(p -> p.giveImpliedTables().stream()).collect(Collectors.toSet());
        return Collections.cat((Collection[])new Collection[]{this.mainPersister.giveImpliedTables(), subTables});
    }

    public void doInsert(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(InsertExecutor::insert);
    }

    public void doUpdateById(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(UpdateExecutor::updateById);
    }

    public void doUpdate(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        KeepOrderMap entitiesPerType = new KeepOrderMap();
        differencesIterable.forEach(arg_0 -> this.lambda$doUpdate$6((Map)entitiesPerType, arg_0));
        entitiesPerType.forEach((updateExecutor, adhocEntities) -> updateExecutor.update((Iterable)adhocEntities, allColumnsStatement));
    }

    public void doDelete(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(DeleteExecutor::delete);
    }

    public void doDeleteById(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(DeleteExecutor::deleteById);
    }

    private Map<EntityPersister<C, I>, Set<C>> computeEntitiesPerPersister(Iterable<? extends C> entities) {
        KeepOrderMap entitiesPerType = new KeepOrderMap();
        entities.forEach(arg_0 -> this.lambda$computeEntitiesPerPersister$10((Map)entitiesPerType, arg_0));
        return entitiesPerType;
    }

    @Override
    public <E, ID> void copyRootJoinsTo(EntityJoinTree<E, ID> entityJoinTree, String joinName) {
        throw new UnsupportedOperationException();
    }

    public EntityMapping<C, I, T> getMapping() {
        return new EntityMappingWrapper<C, I, T>(this.mainPersister.getMapping()){

            @Override
            public void addTransformerListener(RowTransformer.TransformerListener<C> listener) {
                SingleTablePolymorphismPersister.this.subEntitiesPersisters.values().forEach(p -> p.getMapping().addTransformerListener(listener));
            }

            @Override
            public void addShadowColumnInsert(Mapping.ShadowColumnValueProvider<C, T> provider) {
                SingleTablePolymorphismPersister.this.subEntitiesPersisters.values().forEach(p -> p.getMapping().addShadowColumnInsert(provider));
            }

            @Override
            public void addShadowColumnUpdate(Mapping.ShadowColumnValueProvider<C, T> provider) {
                SingleTablePolymorphismPersister.this.subEntitiesPersisters.values().forEach(p -> p.getMapping().addShadowColumnUpdate(provider));
            }
        };
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsOne(RelationalEntityPersister<SRC, SRCID> sourcePersister, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, String rightTableAlias, BeanRelationFixer<SRC, C> beanRelationFixer, boolean optional, boolean loadSeparately) {
        if (loadSeparately) {
            SingleTableFirstPhaseRelationLoader singleTableFirstPhaseRelationLoader = new SingleTableFirstPhaseRelationLoader(this.mainPersister.getMapping().getIdMapping(), (SelectExecutor)this, DIFFERED_ENTITY_LOADER, this.discriminatorColumn, this.subEntitiesPersisters::get);
            String createdJoinNodeName = sourcePersister.getEntityJoinTree().addMergeJoin("ROOT", singleTableFirstPhaseRelationLoader, leftColumn, rightColumn, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER);
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, DIFFERED_ENTITY_LOADER));
            return createdJoinNodeName;
        }
        return this.join(sourcePersister.getEntityJoinTree(), "ROOT", this.mainPersister, leftColumn, rightColumn, new HashSet(this.subEntitiesPersisters.values()), beanRelationFixer, this.polymorphismPolicy, this.discriminatorColumn);
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsMany(RelationalEntityPersister<SRC, SRCID> sourcePersister, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, BeanRelationFixer<SRC, C> beanRelationFixer, @Nullable BiFunction<Row, ColumnedRow, Object> duplicateIdentifierProvider, String joinName, Set<? extends Column<T2, ?>> selectableColumns, boolean optional, boolean loadSeparately) {
        if (loadSeparately) {
            SingleTableFirstPhaseRelationLoader singleTableFirstPhaseRelationLoader = new SingleTableFirstPhaseRelationLoader(this.mainPersister.getMapping().getIdMapping(), (SelectExecutor)this, DIFFERED_ENTITY_LOADER, this.discriminatorColumn, this.subEntitiesPersisters::get);
            String createdJoinNodeName = sourcePersister.getEntityJoinTree().addMergeJoin(joinName, singleTableFirstPhaseRelationLoader, leftColumn, rightColumn, EntityJoinTree.JoinType.OUTER);
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, DIFFERED_ENTITY_LOADER));
            return createdJoinNodeName;
        }
        return this.join(sourcePersister.getEntityJoinTree(), joinName, this.mainPersister, leftColumn, rightColumn, new HashSet(this.subEntitiesPersisters.values()), beanRelationFixer, this.polymorphismPolicy, this.discriminatorColumn);
    }

    private <MAINTABLE extends Table<MAINTABLE>, SUBTABLE extends Table<SUBTABLE>, JOINID> Key.KeyBuilder<SUBTABLE, Object> projectPrimaryKey(Key<MAINTABLE, JOINID> rightColumn, ConfiguredRelationalPersister<? extends C, I> subPersister) {
        EntityMapping subTypeMapping = subPersister.getMapping();
        Key.KeyBuilder reverseKey = Key.from((Fromable)subTypeMapping.getTargetTable());
        rightColumn.getColumns().forEach(col -> {
            Column column = subTypeMapping.getTargetTable().addColumn(col.getExpression(), col.getJavaType());
            subTypeMapping.addShadowColumnSelect(column);
            reverseKey.addColumn((JoinLink)column);
        });
        return reverseKey;
    }

    private <SRC, SRCID, U extends C, T1 extends Table<T1>, T2 extends Table<T2>, ID, JOINCOLTYPE> String join(EntityJoinTree<SRC, SRCID> entityJoinTree, String leftStrategyName, ConfiguredRelationalPersister<U, ID> mainPersister, Key<T1, JOINCOLTYPE> leftJoinColumn, Key<T2, JOINCOLTYPE> rightJoinColumn, Set<ConfiguredRelationalPersister<? extends U, ID>> subPersisters, BeanRelationFixer<SRC, U> beanRelationFixer, PolymorphismPolicy.SingleTablePolymorphism<U, DTYPE> polymorphismPolicy, Column<T2, DTYPE> discriminatorColumn) {
        return entityJoinTree.addJoin(leftStrategyName, parent -> new SingleTablePolymorphicRelationJoinNode(parent, leftJoinColumn, rightJoinColumn, EntityJoinTree.JoinType.OUTER, mainPersister.getMainTable().getColumns(), null, new EntityInflater.EntityMappingAdapter(mainPersister.getMapping()), beanRelationFixer, discriminatorColumn, subPersisters, polymorphismPolicy));
    }

    private /* synthetic */ void lambda$computeEntitiesPerPersister$10(Map entitiesPerType, Object entity) {
        this.subEntitiesPersisters.values().forEach(persister -> {
            if (persister.getClassToPersist().isInstance(entity)) {
                entitiesPerType.computeIfAbsent(persister, p -> new KeepOrderSet()).add(entity);
            }
        });
    }

    private /* synthetic */ void lambda$doUpdate$6(Map entitiesPerType, Duo payload) {
        this.subEntitiesPersisters.values().forEach(persister -> {
            Object entity = Objects.preventNull((Object)payload.getLeft(), (Object)payload.getRight());
            if (persister.getClassToPersist().isInstance(entity)) {
                entitiesPerType.computeIfAbsent(persister, p -> new KeepOrderSet()).add(payload);
            }
        });
    }

    private static /* synthetic */ void lambda$new$0(Mapping.ShadowColumnValueProvider discriminatorValueProvider, ConfiguredRelationalPersister subclassPersister) {
        subclassPersister.getMapping().addShadowColumnInsert(discriminatorValueProvider);
    }

    private class SingleTableFirstPhaseRelationLoader
    extends FirstPhaseRelationLoader<C, I> {
        private final Column<T, DTYPE> discriminatorColumn;
        private final Function<Class, SelectExecutor> subtypeSelectors;
        private final Set<DTYPE> discriminatorValues;

        private SingleTableFirstPhaseRelationLoader(IdMapping<C, I> subEntityIdMapping, SelectExecutor<C, I> selectExecutor, ThreadLocal<Queue<Set<RelationIds<Object, C, I>>>> relationIdsHolder, Column<T, DTYPE> discriminatorColumn, Function<Class, SelectExecutor> subtypeSelectors) {
            super(subEntityIdMapping, selectExecutor, relationIdsHolder);
            this.discriminatorColumn = discriminatorColumn;
            this.subtypeSelectors = subtypeSelectors;
            this.discriminatorValues = (Set)Iterables.collect(SingleTablePolymorphismPersister.this.polymorphismPolicy.getSubClasses(), conf -> SingleTablePolymorphismPersister.this.polymorphismPolicy.getDiscriminatorValue(conf.getEntityType()), HashSet::new);
        }

        @Override
        protected void fillCurrentRelationIds(Row row, Object bean, ColumnedRow columnedRow) {
            Object discriminator = columnedRow.getValue(this.discriminatorColumn, row);
            if (this.discriminatorValues.contains(discriminator)) {
                Set relationIds = (Set)((Queue)this.relationIdsHolder.get()).peek();
                Object id = this.idMapping.getIdentifierAssembler().assemble(row, columnedRow);
                relationIds.add(new RelationIds<Object, Object, Object>(this.giveSelector(discriminator), arg_0 -> ((IdAccessor)this.idMapping.getIdAccessor()).getId(arg_0), bean, id));
            }
        }

        @Override
        public Set<Selectable<?>> getSelectableColumns() {
            HashSet result = new HashSet(this.idMapping.getIdentifierAssembler().getColumns());
            result.add((Selectable<?>)this.discriminatorColumn);
            return result;
        }

        private SelectExecutor giveSelector(DTYPE discriminator) {
            return this.subtypeSelectors.apply(SingleTablePolymorphismPersister.this.polymorphismPolicy.getClass(discriminator));
        }
    }
}

