/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.mapping.AbstractTransformer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;

public class TablePerClassRootJoinNode<C, I>
extends JoinRoot<C, I, QueryStatement.PseudoTable> {
    private final Map<String, ConfiguredRelationalPersister<C, I>> subPersisters;
    private final Selectable.SelectableString<String> discriminatorColumn;
    private TablePerClassPolymorphicJoinRootRowConsumer<C, I> rootConsumer;

    public TablePerClassRootJoinNode(EntityJoinTree<C, I> tree, ConfiguredRelationalPersister<C, I> mainPersister, Map<String, ConfiguredRelationalPersister<C, I>> subPersisters, QueryStatement.PseudoTable union, Selectable.SelectableString<String> discriminatorColumn) {
        super(tree, new EntityInflater.EntityMappingAdapter(mainPersister.getMapping()), union);
        this.subPersisters = subPersisters;
        this.discriminatorColumn = discriminatorColumn;
    }

    @Override
    public Set<Selectable<?>> getColumnsToSelect() {
        return ((QueryStatement.PseudoTable)this.getTable()).getColumns();
    }

    @Override
    public JoinRowConsumer.RootJoinRowConsumer<C> toConsumer(ColumnedRow columnedRow) {
        Set subEntityConsumers = this.subPersisters.values().stream().map(subPersister -> {
            EntityMapping mapping = subPersister.getMapping();
            return new SubPersisterConsumer(row -> mapping.getIdMapping().getIdentifierAssembler().assemble(row, columnedRow), mapping.getClassToPersist(), (AbstractTransformer)mapping.copyTransformerWithAliases(columnedRow));
        }).collect(Collectors.toSet());
        this.rootConsumer = new TablePerClassPolymorphicJoinRootRowConsumer(subEntityConsumers, this.getConsumptionListener() == null ? null : (rootEntity, row) -> this.getConsumptionListener().onNodeConsumption(rootEntity, column -> columnedRow.getValue((Selectable)column, row)), row -> (String)columnedRow.getValue(this.discriminatorColumn, row));
        return this.rootConsumer;
    }

    public void addSubPersister(ConfiguredRelationalPersister<C, I> persister, MergeJoinNode.MergeJoinRowConsumer<? extends C> subConsumer, String discriminatorValue, ColumnedRow columnedRow) {
        ((TablePerClassPolymorphicJoinRootRowConsumer)this.rootConsumer).subConsumers.forEach(pawnConsumer -> {
            if (((SubPersisterConsumer)pawnConsumer).subEntityType == persister.getClassToPersist()) {
                ((SubPersisterConsumer)pawnConsumer).subPropertiesApplier = subConsumer;
                ((SubPersisterConsumer)pawnConsumer).discriminatorValue = discriminatorValue;
            }
        });
    }

    static class TablePerClassPolymorphicJoinRootRowConsumer<C, I>
    implements JoinRowConsumer.ExcludingJoinRowConsumer<C> {
        private static final ThreadLocal<MergeJoinNode.MergeJoinRowConsumer<?>> CURRENTLY_FOUND_CONSUMER = new ThreadLocal();
        private final Set<SubPersisterConsumer<C, I>> subConsumers;
        @javax.annotation.Nullable
        private final BiConsumer<C, Row> consumptionListener;
        private final Function<Row, String> discriminatorValueReader;

        private TablePerClassPolymorphicJoinRootRowConsumer(Set<SubPersisterConsumer<C, I>> subConsumers, @javax.annotation.Nullable BiConsumer<C, Row> consumptionListener, Function<Row, String> discriminatorValueReader) {
            this.subConsumers = subConsumers;
            this.consumptionListener = consumptionListener;
            this.discriminatorValueReader = discriminatorValueReader;
        }

        @Override
        public C createRootInstance(Row row, EntityTreeInflater.TreeInflationContext context) {
            Object result;
            SubPersisterConsumer subInflater = this.findSubInflater(row);
            if (subInflater == null) {
                CURRENTLY_FOUND_CONSUMER.remove();
                result = null;
            } else {
                CURRENTLY_FOUND_CONSUMER.set(subInflater.subPropertiesApplier);
                Object identifier = subInflater.identifierAssembler.apply(row);
                result = context.giveEntityFromCache(subInflater.subEntityType, identifier, () -> subInflater.subEntityFactory.newBeanInstance(row));
            }
            if (this.consumptionListener != null) {
                this.consumptionListener.accept(result, row);
            }
            return (C)result;
        }

        @javax.annotation.Nullable
        public SubPersisterConsumer<C, I> findSubInflater(Row row) {
            String discriminatorValue = (String)Nullable.nullable((Object)this.discriminatorValueReader.apply(row)).map(String::trim).get();
            return (SubPersisterConsumer)Iterables.find(this.subConsumers, subConsumer -> ((SubPersisterConsumer)subConsumer).discriminatorValue.equals(discriminatorValue));
        }

        @Override
        public Set<JoinRowConsumer> giveExcludedConsumers() {
            return this.subConsumers.stream().map(subConsumer -> ((SubPersisterConsumer)subConsumer).subPropertiesApplier).filter(consumerPawn -> CURRENTLY_FOUND_CONSUMER.get() != consumerPawn).collect(Collectors.toSet());
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }
    }

    static class SubPersisterConsumer<C, I> {
        private final Function<Row, I> identifierAssembler;
        private final Class<C> subEntityType;
        private final AbstractTransformer<C> subEntityFactory;
        private MergeJoinNode.MergeJoinRowConsumer<? extends C> subPropertiesApplier;
        private String discriminatorValue;

        private SubPersisterConsumer(Function<Row, I> identifierAssembler, Class<C> subEntityType, AbstractTransformer<C> subEntityFactory) {
            this.identifierAssembler = identifierAssembler;
            this.subEntityType = subEntityType;
            this.subEntityFactory = subEntityFactory;
        }
    }
}

