/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Reflections;

public class PassiveJoinNode<C, T1 extends Fromable, T2 extends Fromable, I>
extends AbstractJoinNode<C, T1, T2, I> {
    PassiveJoinNode(JoinNode<T1> parent, JoinLink<T1, I> leftJoinColumn, JoinLink<T2, I> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias);
    }

    PassiveJoinNode(JoinNode<T1> parent, Key<T1, I> leftJoinColumn, Key<T2, I> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias);
    }

    @Override
    public JoinRowConsumer toConsumer(ColumnedRow columnedRow) {
        return new PassiveJoinRowConsumer(this.getConsumptionListener(), columnedRow);
    }

    public static class PassiveJoinRowConsumer<C>
    implements JoinRowConsumer {
        @Nullable
        private final EntityTreeJoinNodeConsumptionListener<C> consumptionListener;
        @Nullable
        private final ColumnedRow columnedRow;

        public PassiveJoinRowConsumer(@Nullable EntityTreeJoinNodeConsumptionListener<C> consumptionListener, @Nullable ColumnedRow columnedRow) {
            this.consumptionListener = consumptionListener;
            this.columnedRow = columnedRow;
        }

        void consume(C parentJoinEntity, Row row) {
            if (this.consumptionListener != null) {
                this.consumptionListener.onNodeConsumption(parentJoinEntity, col -> this.columnedRow.getValue((Selectable)col, row));
            }
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }
    }
}

