/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.codefilarete.stalactite.query.model.AbstractCriterion;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.query.model.RawCriterion;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.collection.Iterables;

public class Criteria<SELF extends Criteria<SELF>>
extends AbstractCriterion
implements CriteriaChain<SELF> {
    protected List<AbstractCriterion> conditions = new ArrayList<AbstractCriterion>();

    public static void copy(Iterable<AbstractCriterion> source, CriteriaChain target, Function<Selectable<?>, Selectable<?>> columnClones) {
        source.forEach(criterion -> {
            if (criterion instanceof ColumnCriterion) {
                ColumnCriterion columnCriterion = (ColumnCriterion)criterion;
                target.add(criterion.getOperator(), columnCriterion.copyFor((Selectable)columnClones.apply(columnCriterion.getColumn())));
            } else if (criterion instanceof Criteria) {
                target.add(criterion.getOperator(), ((Criteria)criterion).copyFor(columnClones));
            } else {
                target.add((AbstractCriterion)criterion);
            }
        });
    }

    public Criteria() {
    }

    public Criteria(Selectable<?> column, String condition) {
        this.add(new ColumnCriterion(column, condition));
    }

    public <O> Criteria(Selectable<O> column, ConditionalOperator<? super O, ?> condition) {
        this.add(new ColumnCriterion(column, condition));
    }

    public Criteria(Object ... columns) {
        this.add(new RawCriterion(columns));
    }

    public List<AbstractCriterion> getConditions() {
        return this.conditions;
    }

    @Override
    public SELF add(AbstractCriterion condition) {
        this.conditions.add(condition);
        return (SELF)this;
    }

    @Override
    public SELF add(LogicalOperator logicalOperator, Column column, CharSequence condition) {
        return (SELF)this.add(new ColumnCriterion(logicalOperator, column, condition));
    }

    @Override
    public SELF add(LogicalOperator logicalOperator, Column column, ConditionalOperator condition) {
        return (SELF)this.add(new ColumnCriterion(logicalOperator, column, condition));
    }

    @Override
    public SELF add(LogicalOperator logicalOperator, CriteriaChain<?> criteria) {
        Criteria<SELF> toAdd;
        if (criteria instanceof Criteria) {
            toAdd = (Criteria<SELF>)criteria;
        } else {
            toAdd = new Criteria<SELF>();
            Criteria.copy(criteria, toAdd, Function.identity());
        }
        toAdd.setOperator(logicalOperator);
        this.conditions.add(toAdd);
        return (SELF)this;
    }

    @Override
    public SELF add(LogicalOperator logicalOperator, Object ... columns) {
        return (SELF)this.add(new RawCriterion(logicalOperator, columns));
    }

    public Object remove(int index) {
        return this.conditions.remove(index);
    }

    public List<AbstractCriterion> clear() {
        List result = Iterables.copy(this.conditions);
        this.conditions.clear();
        return result;
    }

    @Override
    public Iterator<AbstractCriterion> iterator() {
        return this.conditions.iterator();
    }

    public Criteria copyFor(Function<Selectable<?>, Selectable<?>> columnClones) {
        Criteria<SELF> result = new Criteria<SELF>();
        result.setOperator(this.getOperator());
        Criteria.copy(this.conditions, result, columnClones);
        return result;
    }
}

