/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections4.map.LinkedMap;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.PassiveJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.ThreadLocals;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.IdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTreeInflater<C> {
    public static final Logger LOGGER = LoggerFactory.getLogger(EntityTreeInflater.class);
    private static final ThreadLocal<TreeInflationContext> CURRENT_CONTEXT = new ThreadLocal();
    private final ConsumerNode consumerRoot;
    private final EntityTreeQueryRowDecoder rowDecoder;

    public static TreeInflationContext currentContext() {
        return CURRENT_CONTEXT.get();
    }

    EntityTreeInflater(ConsumerNode consumerRoot, IdentityMap<Selectable, String> columnAliases, Map<String, Fromable> tablePerJoinNodeName) {
        this.consumerRoot = consumerRoot;
        this.rowDecoder = new EntityTreeQueryRowDecoder(columnAliases, tablePerJoinNodeName);
    }

    public Set<C> transform(Iterable<Row> rows, int resultSize) {
        return (Set)ThreadLocals.doWithThreadLocal(CURRENT_CONTEXT, () -> new TreeInflationContext(), context -> this.transform(rows, resultSize, (TreeInflationContext)context));
    }

    private Set<C> transform(Iterable<Row> rows, int resultSize, TreeInflationContext context) {
        Set result = java.util.Collections.newSetFromMap(new IdentityLinkedMap(resultSize));
        for (Row row : rows) {
            Nullable<C> newInstance = this.transform(row, context);
            newInstance.invoke(result::add);
        }
        return result;
    }

    Nullable<C> transform(final Row row, final TreeInflationContext context) {
        context.setCurrentRow(row);
        LOGGER.debug("Creating instance with " + this.consumerRoot.consumer);
        NodeVisitor.EntityCreationResult rootEntityCreationResult = this.getRootEntityCreationResult(row, context);
        if (rootEntityCreationResult != null) {
            this.foreachNode(rootEntityCreationResult.consumers, new NodeVisitor(rootEntityCreationResult.entity){

                @Override
                public NodeVisitor.EntityCreationResult apply(ConsumerNode join, Object entity) {
                    LOGGER.debug("Consuming " + join.consumer + " on object " + entity);
                    JoinRowConsumer consumer = join.getConsumer();
                    if (consumer instanceof PassiveJoinNode.PassiveJoinRowConsumer) {
                        ((PassiveJoinNode.PassiveJoinRowConsumer)consumer).consume(entity, row);
                        return new NodeVisitor.EntityCreationResult(entity, join);
                    }
                    if (consumer instanceof MergeJoinNode.MergeJoinRowConsumer) {
                        ((MergeJoinNode.MergeJoinRowConsumer)consumer).mergeProperties(entity, row);
                        return new NodeVisitor.EntityCreationResult(entity, join);
                    }
                    if (consumer instanceof RelationJoinNode.RelationJoinRowConsumer) {
                        Object relatedEntity = ((RelationJoinNode.RelationJoinRowConsumer)consumer).applyRelatedEntity(entity, row, context);
                        if (consumer instanceof JoinRowConsumer.ForkJoinRowConsumer) {
                            JoinRowConsumer nextRowConsumer = ((JoinRowConsumer.ForkJoinRowConsumer)consumer).giveNextConsumer();
                            if (nextRowConsumer == null) {
                                return new NodeVisitor.EntityCreationResult(null, (List<ConsumerNode>)null);
                            }
                            Optional<ConsumerNode> consumerNode = join.consumers.stream().filter(c -> nextRowConsumer == ((ConsumerNode)c).consumer).findFirst();
                            if (!consumerNode.isPresent()) {
                                throw new IllegalStateException("Can't find consumer node for " + nextRowConsumer + " in " + join.consumers);
                            }
                            return new NodeVisitor.EntityCreationResult(relatedEntity, Arrays.asList(consumerNode.get()));
                        }
                        return new NodeVisitor.EntityCreationResult(relatedEntity, join);
                    }
                    throw new IllegalArgumentException("Unexpected join type, only " + Reflections.toString(PassiveJoinNode.PassiveJoinRowConsumer.class) + ", " + Reflections.toString(MergeJoinNode.MergeJoinRowConsumer.class) + " and " + Reflections.toString(RelationJoinNode.RelationJoinRowConsumer.class) + " are handled, not " + (consumer == null ? "null" : Reflections.toString(consumer.getClass())));
                }
            });
        }
        return Nullable.nullable((Object)rootEntityCreationResult).map(c -> ((NodeVisitor.EntityCreationResult)c).entity);
    }

    private NodeVisitor.EntityCreationResult getRootEntityCreationResult(Row row, TreeInflationContext context) {
        Object rootInstance = ((JoinRowConsumer.RootJoinRowConsumer)this.consumerRoot.consumer).createRootInstance(row, context);
        if (rootInstance != null) {
            if (this.consumerRoot.consumer instanceof JoinRowConsumer.ExcludingJoinRowConsumer) {
                Set<JoinRowConsumer> deadBranches = ((JoinRowConsumer.ExcludingJoinRowConsumer)this.consumerRoot.consumer).giveExcludedConsumers();
                ArrayList<ConsumerNode> consumerNodes = new ArrayList<ConsumerNode>(this.consumerRoot.consumers);
                consumerNodes.removeIf(consumer -> deadBranches.contains(((ConsumerNode)consumer).consumer));
                return new NodeVisitor.EntityCreationResult(rootInstance, consumerNodes);
            }
            return new NodeVisitor.EntityCreationResult(rootInstance, this.consumerRoot.consumers);
        }
        return null;
    }

    @VisibleForTesting
    void foreachNode(Collection<ConsumerNode> seeds, NodeVisitor nodeVisitor) {
        Queue joinNodeStack = Collections.newLifoQueue();
        joinNodeStack.addAll(seeds);
        HashMap entityPerConsumer = new HashMap(10);
        joinNodeStack.forEach(node -> entityPerConsumer.put(node, nodeVisitor.entityRoot));
        while (!joinNodeStack.isEmpty()) {
            ConsumerNode joinNode = (ConsumerNode)joinNodeStack.poll();
            NodeVisitor.EntityCreationResult result = nodeVisitor.apply(joinNode, entityPerConsumer.get(joinNode));
            if (result.getEntity() == null) continue;
            List<ConsumerNode> nextConsumers = result.nextConsumers();
            joinNodeStack.addAll(nextConsumers);
            nextConsumers.forEach(node -> entityPerConsumer.put(node, result.getEntity()));
        }
    }

    private static class IdentityLinkedMap<K, V>
    extends LinkedMap<K, V> {
        public IdentityLinkedMap(int initialCapacity) {
            super(initialCapacity);
        }

        protected int hash(Object key) {
            return System.identityHashCode(key);
        }

        protected boolean isEqualKey(Object key1, Object key2) {
            return key1 == key2;
        }
    }

    public static class EntityTreeQueryRowDecoder {
        private final IdentityMap<Selectable, String> columnAliases;
        private final Map<String, Fromable> tablePerJoinNodeName;

        EntityTreeQueryRowDecoder(IdentityMap<Selectable, String> columnAliases, Map<String, Fromable> tablePerJoinNodeName) {
            this.columnAliases = columnAliases;
            this.tablePerJoinNodeName = tablePerJoinNodeName;
        }

        @javax.annotation.Nullable
        public <T extends Table<T>, O> O giveValue(String joinNodeName, Column<T, O> column, Row row) {
            Fromable table = this.tablePerJoinNodeName.get(joinNodeName);
            if (table == null) {
                throw new MappingConfigurationException("Can't find node named " + joinNodeName + " in joins : " + this.tablePerJoinNodeName);
            }
            Column columnClone = (Column)table.findColumn(column.getName());
            return (O)row.get((String)this.columnAliases.get((Object)columnClone));
        }
    }

    public class TreeInflationContext {
        private final RelationJoinNode.EntityCache entityCache;
        private final Set<RelationIdentifier> treatedRelations = new HashSet<RelationIdentifier>();
        private Row currentRow;

        @VisibleForTesting
        TreeInflationContext() {
            this(new RelationJoinNode.BasicEntityCache());
        }

        public TreeInflationContext(RelationJoinNode.EntityCache entityCache) {
            this.entityCache = entityCache;
        }

        private TreeInflationContext setCurrentRow(Row currentRow) {
            this.currentRow = currentRow;
            return this;
        }

        @javax.annotation.Nullable
        public <T extends Table<T>, O> O giveValue(String joinNodeName, Column<T, O> column) {
            return this.getRowDecoder().giveValue(joinNodeName, column, this.currentRow);
        }

        public EntityTreeQueryRowDecoder getRowDecoder() {
            return EntityTreeInflater.this.rowDecoder;
        }

        public boolean isTreatedOrAppend(RelationIdentifier relationIdentifier) {
            boolean alreadyTreated = this.treatedRelations.contains(relationIdentifier);
            if (!alreadyTreated) {
                this.treatedRelations.add(relationIdentifier);
            }
            return !alreadyTreated;
        }

        public <E> E giveEntityFromCache(Class<E> clazz, Object identifier, Supplier<E> fallbackFactory) {
            return this.entityCache.computeIfAbsent(clazz, identifier, fallbackFactory);
        }
    }

    static class RelationIdentifier {
        protected final Object rootEntity;
        protected final Class relatedEntityType;
        protected final Object relatedBeanIdentifier;
        protected final RelationJoinNode.RelationJoinRowConsumer joinNode;

        RelationIdentifier(Object rootEntity, Class<?> relatedEntityType, Object relatedBeanIdentifier, RelationJoinNode.RelationJoinRowConsumer joinNode) {
            this.rootEntity = rootEntity;
            this.relatedEntityType = relatedEntityType;
            this.relatedBeanIdentifier = relatedBeanIdentifier;
            this.joinNode = joinNode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RelationIdentifier)) {
                return false;
            }
            RelationIdentifier other = (RelationIdentifier)o;
            if (this.rootEntity != other.rootEntity) {
                return false;
            }
            if (!this.relatedEntityType.equals(other.relatedEntityType)) {
                return false;
            }
            if (!this.relatedBeanIdentifier.equals(other.relatedBeanIdentifier)) {
                return false;
            }
            return this.joinNode == other.joinNode;
        }

        public int hashCode() {
            int result = this.rootEntity.hashCode();
            result = 31 * result + this.relatedEntityType.hashCode();
            result = 31 * result + this.relatedBeanIdentifier.hashCode();
            result = 31 * result + this.joinNode.hashCode();
            return result;
        }
    }

    static abstract class NodeVisitor {
        private final Object entityRoot;

        NodeVisitor(Object entityRoot) {
            this.entityRoot = entityRoot;
        }

        abstract EntityCreationResult apply(ConsumerNode var1, Object var2);

        static class EntityCreationResult {
            private final Object entity;
            private final List<ConsumerNode> consumers;

            EntityCreationResult(Object entity, ConsumerNode entityCreator) {
                this(entity, entityCreator.consumers);
            }

            EntityCreationResult(Object entity, List<ConsumerNode> consumers) {
                this.entity = entity;
                this.consumers = consumers;
            }

            public Object getEntity() {
                return this.entity;
            }

            List<ConsumerNode> nextConsumers() {
                return this.consumers;
            }
        }
    }

    static class ConsumerNode {
        private final JoinRowConsumer consumer;
        private final List<ConsumerNode> consumers = new ArrayList<ConsumerNode>();

        ConsumerNode(JoinRowConsumer consumer) {
            this.consumer = consumer;
        }

        public JoinRowConsumer getConsumer() {
            return this.consumer;
        }

        void addConsumer(ConsumerNode consumer) {
            this.consumers.add(consumer);
        }
    }
}

