/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformer;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.function.Sequence;
import org.codefilarete.tool.trace.MutableInt;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportBeforeInsertIdentifierTest {
    private Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;
    private Sequence<Long> longSequence;

    @BeforeEach
    public void initTest() {
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
        this.longSequence = new Sequence<Long>(){
            private final MutableInt counter = new MutableInt(0);

            public Long next() {
                return this.counter.increment();
            }
        };
    }

    @Test
    void insert_basic() {
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.pooledHiLoSequence(this.longSequence)).map(Car::getModel).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car();
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)1L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
    }

    @Test
    void insert_basic_withDatabaseSequence() {
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseSequence((String)"CAR_SEQUENCE")).map(Car::getModel).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car();
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)1L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
    }

    @Test
    void insert_oneToOne() {
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.pooledHiLoSequence(this.longSequence)).map(Car::getModel).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Long.TYPE).mapKey(Engine::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.pooledHiLoSequence(this.longSequence)).map(Engine::getModel)).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car();
        dummyCar.setModel("Renault");
        dummyCar.setEngine(new Engine("XFE45K-TRE"));
        carPersister.insert((Object)dummyCar);
        Assertions.assertThat((Long)dummyCar.getEngine().getId()).isNotNull();
        ResultSetRowTransformer engineTransformer = new ResultSetRowTransformer(Engine.class, "engineId", DefaultResultSetReaders.LONG_READER, Engine::new);
        engineTransformer.add("engineModel", DefaultResultSetReaders.STRING_READER, Engine::setModel);
        BeanRelationFixer carEngineRelationFixer = BeanRelationFixer.of(Vehicle::setEngine);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model, Engine.id as engineId, Engine.model as engineModel from Car inner join Engine on Car.engineId = Engine.id", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).map(carEngineRelationFixer, engineTransformer).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)2L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        Assertions.assertThat((Object)loadedCar.getEngine()).isEqualTo((Object)dummyCar.getEngine());
    }

    @Test
    void insert_oneToOne_ownedByReverseSide() {
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.pooledHiLoSequence(this.longSequence)).map(Car::getModel).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Long.TYPE).mapKey(Engine::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.pooledHiLoSequence(this.longSequence)).map(Engine::getModel)).mappedBy(Engine::getCar).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car();
        dummyCar.setModel("Renault");
        Engine engine = new Engine("XFE45K-TRE");
        dummyCar.setEngine(engine);
        engine.setCar(dummyCar);
        carPersister.insert((Object)dummyCar);
        Assertions.assertThat((Long)dummyCar.getEngine().getId()).isNotNull();
        ResultSetRowTransformer engineTransformer = new ResultSetRowTransformer(Engine.class, "engineId", DefaultResultSetReaders.LONG_READER, Engine::new);
        engineTransformer.add("engineModel", DefaultResultSetReaders.STRING_READER, Engine::setModel);
        BeanRelationFixer carEngineRelationFixer = BeanRelationFixer.of(Vehicle::setEngine);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model, Engine.id as engineId, Engine.model as engineModel from Car inner join Engine on Car.id = Engine.carId", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).map(carEngineRelationFixer, engineTransformer).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)1L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        Assertions.assertThat((Object)loadedCar.getEngine()).isEqualTo((Object)dummyCar.getEngine());
    }

    @Test
    void multipleInheritance() {
        EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.pooledHiLoSequence(this.longSequence)).getConfiguration();
        EntityMappingConfiguration inheritanceConfiguration2 = MappingEase.entityBuilder(Vehicle.class, Long.TYPE).map(Vehicle::getName).mapSuperClass(inheritanceConfiguration).getConfiguration();
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).map(Car::getModel).mapSuperClass(inheritanceConfiguration2).build(this.persistenceContext);
        Assertions.assertThat((String)((ConfiguredPersister)this.persistenceContext.getPersister(Car.class)).getMapping().getTargetTable().getName()).isEqualTo("Car");
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car();
        dummyCar.setName("Toto");
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model, name from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).map("name", Vehicle::setName).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)1L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
    }

    @Test
    void multipleInheritance_joinedTables() {
        EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.pooledHiLoSequence(this.longSequence)).getConfiguration();
        EntityMappingConfiguration inheritanceConfiguration2 = MappingEase.entityBuilder(Vehicle.class, Long.TYPE).mapSuperClass(inheritanceConfiguration).withJoinedTable().getConfiguration();
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).map(Car::getModel).mapSuperClass(inheritanceConfiguration2).withJoinedTable().build(this.persistenceContext);
        Assertions.assertThat((Collection)DDLDeployer.collectTables((PersistenceContext)this.persistenceContext).stream().map(Table::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"Car", "Vehicle", "AbstractVehicle"}));
        Assertions.assertThat((String)((ConfiguredPersister)this.persistenceContext.getPersister(Car.class)).getMapping().getTargetTable().getName()).isEqualTo("Car");
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car();
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)1L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
    }

    static class Engine {
        private Long id;
        private String model;
        private Car car;

        public Engine() {
        }

        public Engine(Long id) {
            this.id = id;
        }

        public Engine(String model) {
            this.model = model;
        }

        public Long getId() {
            return this.id;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Engine engine = (Engine)o;
            return Objects.equals(this.id, engine.id);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }

        public String toString() {
            return "Engine{id=" + this.id + '}';
        }

        public Car getCar() {
            return this.car;
        }

        public void setCar(Car car) {
            this.car = car;
        }
    }

    static class Car
    extends Vehicle {
        private String model;

        public Car() {
        }

        public Car(Long id) {
            super(id);
        }

        public Car(Long id, String model) {
            super(id);
            this.setModel(model);
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    static class Color {
        private int rgb;

        public Color() {
        }

        public Color(int rgb) {
            this.rgb = rgb;
        }

        public int getRgb() {
            return this.rgb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Color color = (Color)o;
            return this.rgb == color.rgb;
        }

        public int hashCode() {
            return Objects.hash(this.rgb);
        }
    }

    static class Vehicle
    extends AbstractVehicle {
        private Color color;
        private Engine engine;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Vehicle(Long id) {
            super(id);
        }

        public Vehicle() {
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Engine getEngine() {
            return this.engine;
        }

        public void setEngine(Engine engine) {
            this.engine = engine;
        }
    }

    static abstract class AbstractVehicle {
        private Long id;
        private Timestamp timestamp;

        public AbstractVehicle() {
        }

        private AbstractVehicle(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }
    }
}

