/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model.operator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.query.model.Variable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;

public class TupleIn
extends ConditionalOperator<Object[], List<Object[]>> {
    private final Column[] columns;
    private Variable<List<Object[]>> values;

    public static TupleIn transformBeanColumnValuesToTupleInValues(int inSize, Map<? extends Column<?, ?>, ?> values) {
        ArrayList<Object[]> resultValues = new ArrayList<Object[]>(inSize);
        Column[] columns = new ArrayList(values.keySet()).toArray(new Column[0]);
        for (int i = 0; i < inSize; ++i) {
            ArrayList<Object> beanValues = new ArrayList<Object>(columns.length);
            for (Column column : columns) {
                Object value = values.get(column);
                if (value instanceof List) {
                    beanValues.add(((List)value).get(i));
                    continue;
                }
                beanValues.add(value);
            }
            resultValues.add(beanValues.toArray());
        }
        return new TupleIn(columns, resultValues);
    }

    public TupleIn(Column[] columns, Variable<List<Object[]>> values) {
        this.columns = columns;
        this.values = values;
    }

    public TupleIn(Column[] columns, List<Object[]> values) {
        this(columns, new ValuedVariable<List<Object[]>>(values));
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Variable<List<Object[]>> getValue() {
        return this.values;
    }

    @Override
    public void setValue(Variable<List<Object[]>> value) {
        this.values = value;
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

