/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Collections;
import java.util.Map;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.ExpandableSQLAppender;
import org.codefilarete.stalactite.query.builder.FromSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.PreparableSQLBuilder;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.SelectSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.builder.WhereSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.AbstractCriterion;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.GroupBy;
import org.codefilarete.stalactite.query.model.Having;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.KeepOrderSet;

public class QuerySQLBuilderFactory {
    private final ColumnBinderRegistry parameterBinderRegistry;
    private final SelectSQLBuilderFactory selectBuilderFactory;
    private final FromSQLBuilderFactory fromBuilderFactory;
    private final WhereSQLBuilderFactory whereBuilderFactory;
    private final WhereSQLBuilderFactory havingBuilderFactory;
    private final FunctionSQLBuilderFactory functionSQLBuilderFactory;
    private final DMLNameProviderFactory dmlNameProviderFactory;

    public QuerySQLBuilderFactory(DMLNameProviderFactory dmlNameProviderFactory, ColumnBinderRegistry parameterBinderRegistry, SelectSQLBuilderFactory selectBuilderFactory, FromSQLBuilderFactory fromBuilderFactory, WhereSQLBuilderFactory whereBuilderFactory, WhereSQLBuilderFactory havingBuilderFactory, FunctionSQLBuilderFactory functionSQLBuilderFactory) {
        this.dmlNameProviderFactory = dmlNameProviderFactory;
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.selectBuilderFactory = selectBuilderFactory;
        this.fromBuilderFactory = fromBuilderFactory;
        this.whereBuilderFactory = whereBuilderFactory;
        this.havingBuilderFactory = havingBuilderFactory;
        this.functionSQLBuilderFactory = functionSQLBuilderFactory;
    }

    public QuerySQLBuilderFactory(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping, DMLNameProviderFactory dmlNameProviderFactory, ColumnBinderRegistry parameterBinderRegistry) {
        this.dmlNameProviderFactory = dmlNameProviderFactory;
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.selectBuilderFactory = new SelectSQLBuilderFactory(javaTypeToSqlTypeMapping);
        this.fromBuilderFactory = new FromSQLBuilderFactory();
        this.whereBuilderFactory = new WhereSQLBuilderFactory(javaTypeToSqlTypeMapping, parameterBinderRegistry);
        this.havingBuilderFactory = new WhereSQLBuilderFactory(javaTypeToSqlTypeMapping, parameterBinderRegistry);
        this.functionSQLBuilderFactory = new FunctionSQLBuilderFactory(javaTypeToSqlTypeMapping);
    }

    public ColumnBinderRegistry getParameterBinderRegistry() {
        return this.parameterBinderRegistry;
    }

    public SelectSQLBuilderFactory getSelectBuilderFactory() {
        return this.selectBuilderFactory;
    }

    public FromSQLBuilderFactory getFromBuilderFactory() {
        return this.fromBuilderFactory;
    }

    public WhereSQLBuilderFactory getWhereBuilderFactory() {
        return this.whereBuilderFactory;
    }

    public WhereSQLBuilderFactory getHavingBuilderFactory() {
        return this.havingBuilderFactory;
    }

    public FunctionSQLBuilderFactory getFunctionSQLBuilderFactory() {
        return this.functionSQLBuilderFactory;
    }

    public DMLNameProviderFactory getDmlNameProviderFactory() {
        return this.dmlNameProviderFactory;
    }

    public QuerySQLBuilder queryBuilder(Query query, Iterable<AbstractCriterion> where) {
        if (where.iterator().hasNext()) {
            query.getWhere().and(where);
        }
        return this.queryBuilder(query);
    }

    public QuerySQLBuilder queryBuilder(Query query, Iterable<AbstractCriterion> where, Map<? extends Selectable<?>, ? extends Selectable<?>> columnClones) {
        if (where.iterator().hasNext()) {
            Criteria.copy(where, query.getWhere(), columnClones::get);
        }
        return this.queryBuilder(query);
    }

    public QuerySQLBuilder queryBuilder(Query query) {
        DMLNameProvider dmlNameProvider = this.dmlNameProviderFactory.build(arg_0 -> query.getFromDelegate().getTableAliases().get(arg_0));
        return new QuerySQLBuilder(query, dmlNameProvider, this.selectBuilderFactory.queryBuilder(query.getSelectDelegate(), dmlNameProvider), this.fromBuilderFactory.fromBuilder(query.getFromDelegate(), dmlNameProvider, this), this.whereBuilderFactory.whereBuilder(query.getWhereDelegate(), dmlNameProvider), this.havingBuilderFactory.whereBuilder(query.getHavingDelegate(), dmlNameProvider), this.functionSQLBuilderFactory.functionSQLBuilder(dmlNameProvider), this.parameterBinderRegistry);
    }

    public UnionSQLBuilder unionBuilder(Union union) {
        return new UnionSQLBuilder(union, this);
    }

    public QueryStatementSQLBuilder queryStatementBuilder(QueryStatement queryStatement) {
        if (queryStatement instanceof Query) {
            return this.queryBuilder((Query)queryStatement);
        }
        if (queryStatement instanceof Union) {
            return this.unionBuilder((Union)queryStatement);
        }
        throw new IllegalArgumentException("Unsupported query statement type: " + Reflections.toString(queryStatement.getClass()));
    }

    public static class UnionSQLBuilder
    implements QueryStatementSQLBuilder {
        private static final String UNION_ALL_SEPARATOR = " union all ";
        private final Union union;
        private final QuerySQLBuilderFactory querySQLBuilderFactory;
        private final DMLNameProviderFactory dmlNameProviderFactory;

        public UnionSQLBuilder(Union union, QuerySQLBuilderFactory querySQLBuilderFactory) {
            this.union = union;
            this.querySQLBuilderFactory = querySQLBuilderFactory;
            this.dmlNameProviderFactory = querySQLBuilderFactory.getDmlNameProviderFactory();
        }

        @Override
        public CharSequence toSQL() {
            StringSQLAppender result = new StringSQLAppender(this.dmlNameProviderFactory.build(Collections.emptyMap()));
            this.appendTo(result);
            return result.getSQL();
        }

        @Override
        public ExpandableSQLAppender toPreparableSQL() {
            ExpandableSQLAppender expandableSQLAppender = new ExpandableSQLAppender(this.querySQLBuilderFactory.getParameterBinderRegistry(), this.dmlNameProviderFactory.build(Collections.emptyMap()));
            this.appendTo(expandableSQLAppender);
            return expandableSQLAppender;
        }

        @Override
        public void appendTo(SQLAppender preparedSQLAppender) {
            KeepOrderSet<Query> queries = this.union.getQueries();
            queries.forEach(query -> {
                QuerySQLBuilder sqlBuilder = this.querySQLBuilderFactory.queryBuilder((Query)query);
                SQLAppender.SubSQLAppender subAppender = preparedSQLAppender.newSubPart(this.dmlNameProviderFactory.build(arg_0 -> query.getFromDelegate().getTableAliases().get(arg_0)));
                sqlBuilder.appendTo(subAppender);
                subAppender.close();
                preparedSQLAppender.cat(UNION_ALL_SEPARATOR, new String[0]);
            });
            preparedSQLAppender.removeLastChars(UNION_ALL_SEPARATOR.length());
        }
    }

    public static class QuerySQLBuilder
    implements QueryStatementSQLBuilder {
        private final Query query;
        private final DMLNameProvider dmlNameProvider;
        private final SelectSQLBuilderFactory.SelectSQLBuilder selectSQLBuilder;
        private final FromSQLBuilderFactory.FromSQLBuilder fromSqlBuilder;
        private final WhereSQLBuilderFactory.WhereSQLBuilder whereSqlBuilder;
        private final WhereSQLBuilderFactory.WhereSQLBuilder havingBuilder;
        private final FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder;
        private final ColumnBinderRegistry parameterBinderRegistry;

        public QuerySQLBuilder(Query query, DMLNameProvider dmlNameProvider, SelectSQLBuilderFactory.SelectSQLBuilder selectSQLBuilder, FromSQLBuilderFactory.FromSQLBuilder fromSqlBuilder, WhereSQLBuilderFactory.WhereSQLBuilder whereSqlBuilder, WhereSQLBuilderFactory.WhereSQLBuilder havingBuilder, FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder, ColumnBinderRegistry parameterBinderRegistry) {
            this.query = query;
            this.dmlNameProvider = dmlNameProvider;
            this.selectSQLBuilder = selectSQLBuilder;
            this.fromSqlBuilder = fromSqlBuilder;
            this.whereSqlBuilder = whereSqlBuilder;
            this.havingBuilder = havingBuilder;
            this.functionSQLBuilder = functionSQLBuilder;
            this.parameterBinderRegistry = parameterBinderRegistry;
        }

        @Override
        public String toSQL() {
            StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
            this.appendTo(result);
            return result.getSQL();
        }

        @Override
        public ExpandableSQLAppender toPreparableSQL() {
            ExpandableSQLAppender preparedSQLAppender = new ExpandableSQLAppender(this.parameterBinderRegistry, this.dmlNameProvider);
            this.appendTo(preparedSQLAppender);
            return preparedSQLAppender;
        }

        @Override
        public void appendTo(SQLAppender sqlWrapper) {
            Limit limit;
            OrderBy orderBy;
            Having having;
            GroupBy groupBy;
            sqlWrapper.cat("select ", this.selectSQLBuilder.toSQL());
            sqlWrapper.cat(" from ", new String[0]);
            this.fromSqlBuilder.appendTo(sqlWrapper);
            if (!this.query.getWhereDelegate().getConditions().isEmpty()) {
                sqlWrapper.cat(" where ", new String[0]);
                this.whereSqlBuilder.appendTo(sqlWrapper);
            }
            if (!(groupBy = this.query.getGroupByDelegate()).getGroups().isEmpty()) {
                this.cat(groupBy, sqlWrapper.cat(" group by ", new String[0]));
            }
            if (!(having = this.query.getHavingDelegate()).getConditions().isEmpty()) {
                sqlWrapper.cat(" having ", new String[0]);
                this.havingBuilder.appendTo(sqlWrapper);
            }
            if (!(orderBy = this.query.getOrderByDelegate()).getColumns().isEmpty()) {
                sqlWrapper.cat(" order by ", new String[0]);
                this.cat(orderBy, sqlWrapper);
            }
            if ((limit = this.query.getLimitDelegate()).getCount() != null) {
                sqlWrapper.cat(" limit ", new String[0]);
                sqlWrapper.catValue(new ValuedVariable<Integer>(limit.getCount()));
                if (limit.getOffset() != null) {
                    sqlWrapper.cat(" offset ", new String[0]);
                    sqlWrapper.catValue(new ValuedVariable<Integer>(limit.getOffset()));
                }
            }
        }

        private void cat(OrderBy orderBy, SQLAppender sql) {
            for (OrderBy.OrderedColumn o : orderBy) {
                Object column = o.getColumn();
                this.cat(column, sql);
                sql.catIf(o.getOrder() != null, o.getOrder() == OrderByChain.Order.ASC ? " asc" : " desc").cat(", ", new String[0]);
            }
            sql.removeLastChars(2);
        }

        private void cat(GroupBy groupBy, SQLAppender sql) {
            for (Object o : groupBy) {
                this.cat(o, sql);
                sql.cat(", ", new String[0]);
            }
            sql.removeLastChars(2);
        }

        private void cat(Object column, SQLAppender sql) {
            if (column instanceof String) {
                sql.cat((String)column, new String[0]);
            } else if (column instanceof SQLFunction) {
                this.functionSQLBuilder.cat((SQLFunction)column, sql);
            } else if (column instanceof Selectable) {
                sql.catColumn((Selectable)column);
            }
        }
    }

    public static interface QueryStatementSQLBuilder
    extends SQLBuilder,
    PreparableSQLBuilder {
        public void appendTo(SQLAppender var1);
    }
}

