/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Element;
import org.codefilarete.stalactite.engine.model.Part;
import org.codefilarete.stalactite.engine.model.Question;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.Sequence;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SingleTablePolymorphismBuilderTest {
    public static final PolymorphismPolicy.SingleTablePolymorphism<Element, String> POLYMORPHISM_POLICY = PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Question.class).map(Question::getLabel), (Object)"QUESTION").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Part.class).map(Part::getName), (Object)"PART");

    SingleTablePolymorphismBuilderTest() {
    }

    @Test
    void build_targetTableAndOverridingColumnsAreDifferent_throwsException() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        PersistenceContext persistenceContext = new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), dialect);
        Table expectedResult = new Table("MyOverridingTable");
        Column colorTable = expectedResult.addColumn("myOverridingColumn", Integer.class);
        FluentEntityMappingBuilder configuration = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE, (Table)new Table("TargetTable")).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).embed(Vehicle::getColor, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Color.class).map(Color::getRgb)).override(Color::getRgb, colorTable), (Object)"CAR"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> configuration.build(persistenceContext)).extracting(t -> (MappingConfigurationException)Exceptions.findExceptionInCauses((Throwable)t, MappingConfigurationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Table declared in inheritance is different from given one in embeddable properties override : MyOverridingTable, TargetTable");
    }

    @Test
    void build_withAlreadyAssignedIdentifierPolicy_entitiesMustHaveTheirIdSet() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        EntityPersister configuration = MappingEase.entityBuilder(Element.class, Long.TYPE).mapKey(Element::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(c -> {}, c -> false)).mapPolymorphism(POLYMORPHISM_POLICY).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Question theUltimateQuestion = new Question(1L).setLabel("What's the answer to Life, the Universe and Everything ?");
        configuration.persist((Iterable)Arrays.asList((Object[])new Question[]{theUltimateQuestion}));
        Assertions.assertThat((long)theUltimateQuestion.getId()).isEqualTo(1L);
    }

    @Test
    void build_withAfterInsertIdentifierPolicy_entitiesMustHaveTheirIdSet() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        EntityPersister configuration = MappingEase.entityBuilder(Element.class, Long.TYPE).mapKey(Element::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).mapPolymorphism(POLYMORPHISM_POLICY).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Question theUltimateQuestion = new Question().setLabel("What's the answer to Life, the Universe and Everything ?");
        configuration.persist((Iterable)Arrays.asList((Object[])new Question[]{theUltimateQuestion}));
        Assertions.assertThat((long)theUltimateQuestion.getId()).isEqualTo(1L);
    }

    @Test
    void build_withBeforeInsertIdentifierPolicy_entitiesMustHaveTheirIdSet() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        Sequence<Long> identifierGenerator = new Sequence<Long>(){
            private long counter = 0L;

            public Long next() {
                return ++this.counter;
            }
        };
        EntityPersister configuration = MappingEase.entityBuilder(Element.class, Long.TYPE).mapKey(Element::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.pooledHiLoSequence((Sequence)identifierGenerator)).mapPolymorphism(POLYMORPHISM_POLICY).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Question theUltimateQuestion = new Question().setLabel("What's the answer to Life, the Universe and Everything ?");
        configuration.persist((Iterable)Arrays.asList((Object[])new Question[]{theUltimateQuestion}));
        Assertions.assertThat((long)theUltimateQuestion.getId()).isEqualTo(1L);
    }
}

