/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.binder.InMemoryBlobSupport;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.stalactite.sql.test.DatabaseIntegrationTest;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.io.IOs;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractParameterBindersITTest
extends DatabaseIntegrationTest {
    protected ParameterBinderRegistry parameterBinderRegistry;
    protected JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping;

    @BeforeEach
    abstract void createParameterBinderRegistry();

    @BeforeEach
    abstract void createJavaTypeToSqlTypeMapping();

    @Test
    void longBinder() throws SQLException {
        this.testParameterBinder(Long.class, Arrays.asSet((Object[])new Long[]{null, 42L}));
    }

    @Test
    void longPrimitiveBinder() throws SQLException {
        this.testParameterBinder(Long.TYPE, Arrays.asSet((Object[])new Long[]{42L}));
    }

    @Test
    void longPrimitiveBinder_nullValuePassed_NPEThrown() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.testParameterBinder(Long.TYPE, Arrays.asSet(null)));
    }

    @Test
    void integerBinder() throws SQLException {
        this.testParameterBinder(Integer.class, Arrays.asSet((Object[])new Integer[]{null, 42}));
    }

    @Test
    void integerPrimitiveBinder() throws SQLException {
        this.testParameterBinder(Integer.TYPE, Arrays.asSet((Object[])new Integer[]{42}));
    }

    @Test
    void integerPrimitiveBinder_nullValuePassed_NPEThrown() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.testParameterBinder(Integer.TYPE, Arrays.asSet(null)));
    }

    @Test
    void byteBinder() throws SQLException {
        this.testParameterBinder(Byte.class, Arrays.asSet((Object[])new Byte[]{null, (byte)42}));
    }

    @Test
    void bytePrimitiveBinder() throws SQLException {
        this.testParameterBinder(Byte.TYPE, Arrays.asSet((Object[])new Byte[]{(byte)42}));
    }

    @Test
    void bytePrimitiveBinder_nullValuePassed_NPEThrown() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.testParameterBinder(Byte.TYPE, Arrays.asSet(null)));
    }

    @Test
    void bytesBinder() throws SQLException {
        byte[] inputStream = "Hello world !".getBytes();
        LinkedHashSet valuesToInsert = Arrays.asSet((Object[])new byte[][]{inputStream, null});
        Set<byte[]> databaseContent = this.insertAndSelect((Class<T>)byte[].class, valuesToInsert);
        Assertions.assertThat(AbstractParameterBindersITTest.convertBytesToString(databaseContent)).isEqualTo((Object)Arrays.asSet((Object[])new String[]{null, "Hello world !"}));
    }

    static Set<String> convertBytesToString(Set<byte[]> databaseContent) {
        return databaseContent.stream().map(s -> (String)Nullable.nullable((Object)s).map(String::new).get()).collect(Collectors.toSet());
    }

    @Test
    void doubleBinder() throws SQLException {
        this.testParameterBinder(Double.class, Arrays.asSet((Object[])new Double[]{null, 42.57}));
    }

    @Test
    void doublePrimitiveBinder() throws SQLException {
        this.testParameterBinder(Double.TYPE, Arrays.asSet((Object[])new Double[]{42.57}));
    }

    @Test
    void doublePrimitiveBinder_nullValuePassed_NPEThrown() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.testParameterBinder(Double.TYPE, Arrays.asSet(null)));
    }

    @Test
    void floatBinder() throws SQLException {
        this.testParameterBinder(Float.class, Arrays.asSet((Object[])new Float[]{null, Float.valueOf(42.57f)}));
    }

    @Test
    void floatPrimitiveBinder() throws SQLException {
        this.testParameterBinder(Float.TYPE, Arrays.asSet((Object[])new Float[]{Float.valueOf(42.57f)}));
    }

    @Test
    void floatPrimitiveBinder_nullValuePassed_NPEThrown() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.testParameterBinder(Float.TYPE, Arrays.asSet(null)));
    }

    @Test
    void bigDecimalBinder() throws SQLException {
        BigDecimal nullInsertion = this.insertAndSelect(BigDecimal.class, (BigDecimal)null);
        Assertions.assertThat((BigDecimal)nullInsertion).isNull();
        this.clearSchema();
        BigDecimal real = this.insertAndSelect(BigDecimal.class, BigDecimal.valueOf(42.66));
        Assertions.assertThat((BigDecimal)real).isCloseTo(BigDecimal.valueOf(42.66), Offset.offset((Number)BigDecimal.valueOf(0.001)));
    }

    @Test
    void bigIntegerBinder() throws SQLException {
        this.testParameterBinder(BigInteger.class, Arrays.asSet((Object[])new BigInteger[]{null, new BigInteger("42", 10)}));
    }

    @Test
    void booleanBinder() throws SQLException {
        this.testParameterBinder(Boolean.class, Arrays.asSet((Object[])new Boolean[]{null, true, false}));
    }

    @Test
    void booleanPrimitiveBinder() throws SQLException {
        this.testParameterBinder(Boolean.TYPE, Arrays.asSet((Object[])new Boolean[]{true, false}));
    }

    @Test
    void booleanPrimitiveBinder_nullValuePassed_NPEThrown() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.testParameterBinder(Boolean.TYPE, Arrays.asSet(null)));
    }

    @Test
    void dateSqlBinder() throws SQLException {
        Date date = Date.valueOf(LocalDate.now());
        this.testParameterBinder(Date.class, Arrays.asSet((Object[])new Date[]{null, date}));
    }

    @Test
    void dateBinder() throws SQLException {
        java.util.Date date = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
        this.testParameterBinder(java.util.Date.class, Arrays.asSet((Object[])new java.util.Date[]{null, date}));
    }

    @Test
    void localDateBinder() throws SQLException {
        this.testParameterBinder(LocalDate.class, Arrays.asSet((Object[])new LocalDate[]{null, LocalDate.now()}));
    }

    @Test
    void localDateTimeBinder() throws SQLException {
        LocalDateTime initialTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123456789);
        LocalDateTime comparisonTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123456000);
        Set<LocalDateTime> databaseContent = this.insertAndSelect((Class<T>)LocalDateTime.class, Arrays.asSet((Object[])new LocalDateTime[]{null, initialTime}));
        Assertions.assertThat(databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalDateTime[]{null, comparisonTime}));
    }

    @Test
    void localTimeBinder() throws SQLException {
        LocalTime initialTime = LocalTime.of(4, 23, 35, 123456789);
        LocalTime comparisonTime = LocalTime.of(4, 23, 35, 123456000);
        Set<LocalTime> databaseContent = this.insertAndSelect((Class<T>)LocalTime.class, Arrays.asSet((Object[])new LocalTime[]{null, initialTime}));
        Assertions.assertThat(databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalTime[]{null, comparisonTime}));
    }

    @Test
    void timestampBinder() throws SQLException {
        this.testParameterBinder(Timestamp.class, Arrays.asSet((Object[])new Timestamp[]{null, new Timestamp(System.currentTimeMillis())}));
    }

    @Test
    void stringBinder() throws SQLException {
        this.testParameterBinder(this.parameterBinderRegistry.getBinder(String.class), "varchar(255)", Arrays.asSet((Object[])new String[]{null, "Hello world !"}));
    }

    @Test
    void binaryStreamBinder() throws SQLException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("Hello world !".getBytes());
        LinkedHashSet valuesToInsert = Arrays.asSet((Object[])new InputStream[]{inputStream, null});
        Set<InputStream> databaseContent = this.insertAndSelect((Class<T>)InputStream.class, valuesToInsert);
        Assertions.assertThat(AbstractParameterBindersITTest.convertInputStreamToString(databaseContent)).isEqualTo((Object)Arrays.asSet((Object[])new String[]{null, "Hello world !"}));
    }

    @Test
    void blobBinder() throws SQLException {
        InMemoryBlobSupport blob = new InMemoryBlobSupport("Hello world !".getBytes());
        LinkedHashSet valuesToInsert = Arrays.asSet((Object[])new Blob[]{blob, null});
        Set<Blob> databaseContent = this.insertAndSelect((Class<T>)Blob.class, valuesToInsert);
        Assertions.assertThat(AbstractParameterBindersITTest.convertBlobToString(databaseContent)).isEqualTo((Object)Arrays.asSet((Object[])new String[]{null, "Hello world !"}));
    }

    @Test
    void uuidBinder() throws SQLException {
        this.testParameterBinder(UUID.class, Arrays.asSet((Object[])new UUID[]{null, UUID.randomUUID()}));
    }

    @Test
    void pathBinder() throws SQLException {
        this.testParameterBinder(Path.class, Arrays.asSet((Object[])new Path[]{null, Paths.get("/path/to/my/file", new String[0])}));
    }

    @Test
    void fileBinder() throws SQLException {
        this.testParameterBinder(File.class, Arrays.asSet((Object[])new File[]{null, new File("/path/to/my/file")}));
    }

    protected <T> void testParameterBinder(Class<T> typeToTest, Set<T> valuesToInsert) throws SQLException {
        Set<T> databaseContent = this.insertAndSelect(typeToTest, valuesToInsert);
        Assertions.assertThat(databaseContent).isEqualTo(valuesToInsert);
    }

    protected <T> void testParameterBinder(ParameterBinder<T> testInstance, String sqlColumnType, Set<T> valuesToInsert) throws SQLException {
        Set<T> databaseContent = this.insertAndSelect(testInstance, sqlColumnType, valuesToInsert, this.connectionProvider.giveConnection());
        Assertions.assertThat(databaseContent).isEqualTo(valuesToInsert);
    }

    static Set<String> convertInputStreamToString(Set<InputStream> databaseContent) {
        return databaseContent.stream().map(s -> (String)Nullable.nullable((Object)s).map(inputStream -> {
            try (InputStream closeable = inputStream;){
                String string = new String(IOs.toByteArray((InputStream)closeable));
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).get()).collect(Collectors.toSet());
    }

    static Set<String> convertBlobToString(Set<Blob> databaseContent) {
        return databaseContent.stream().map(b -> {
            try {
                return (String)Nullable.nullable((Object)b).mapThrower(blob -> new String(blob.getBytes(1L, (int)blob.length()))).get();
            }
            catch (SQLException e) {
                throw new SQLExecutionException((Throwable)e);
            }
        }).collect(Collectors.toSet());
    }

    protected <T> T insertAndSelect(Class<T> typeToTest, T valuesToInsert) throws SQLException {
        ParameterBinder testInstance = this.parameterBinderRegistry.getBinder(typeToTest);
        String sqlColumnType = this.javaTypeToSqlTypeMapping.getTypeName(typeToTest);
        return (T)Iterables.first(this.insertAndSelect(testInstance, sqlColumnType, Arrays.asSet((Object[])new Object[]{valuesToInsert}), this.connectionProvider.giveConnection()));
    }

    protected <T> Set<T> insertAndSelect(Class<T> typeToTest, Set<T> valuesToInsert) throws SQLException {
        ParameterBinder testInstance = this.parameterBinderRegistry.getBinder(typeToTest);
        String sqlColumnType = this.javaTypeToSqlTypeMapping.getTypeName(typeToTest);
        return this.insertAndSelect(testInstance, sqlColumnType, valuesToInsert, this.connectionProvider.giveConnection());
    }

    protected void clearSchema() {
        try {
            this.connectionProvider.giveConnection().prepareStatement("drop table Toto").execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> Set<T> insertAndSelect(final ParameterBinder<T> testInstance, String sqlColumnType, Set<T> valuesToInsert, Connection connection) throws SQLException {
        connection.prepareStatement("create table Toto(a " + sqlColumnType + ")").execute();
        PreparedStatement statement = connection.prepareStatement("insert into Toto(a) values (?)");
        valuesToInsert.forEach(v -> {
            try {
                testInstance.set(statement, 1, v);
                statement.execute();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        final ResultSet resultSet = connection.prepareStatement("select a from Toto").executeQuery();
        ResultSetIterator resultSetIterator = new ResultSetIterator<T>(resultSet){

            public T convert(ResultSet rs) throws SQLException {
                return testInstance.get(resultSet, "a");
            }
        };
        return Iterables.stream((Iterator)resultSetIterator).collect(Collectors.toSet());
    }
}

