/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public interface ConnectionProvider {
    public Connection giveConnection();

    public static class DataSourceConnectionProvider
    implements ConnectionProvider {
        private final DataSource dataSource;

        public DataSourceConnectionProvider(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection giveConnection() {
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

