/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.assembly;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

public class SimpleIdentifierAssembler<I, T extends Table<T>>
implements IdentifierAssembler<I, T> {
    private final Column<T, I> primaryKey;

    public SimpleIdentifierAssembler(Column<T, I> primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Column<T, I> getColumn() {
        return this.primaryKey;
    }

    @Override
    public Set<Column<T, ?>> getColumns() {
        return Arrays.asHashSet((Object[])new Column[]{this.primaryKey});
    }

    @Override
    public I assemble(Function<Column<?, ?>, Object> columnValueProvider) {
        Object value = columnValueProvider.apply(this.primaryKey);
        return (I)(value == null || SimpleIdentifierAssembler.isDefaultPrimitiveValue(value) ? null : value);
    }

    @Override
    public Map<Column<T, ?>, Object> getColumnValues(I id) {
        return Collections.singletonMap(this.primaryKey, id);
    }

    @Override
    public Map<Column<T, ?>, Object> getColumnValues(List<I> ids) {
        HashMap pkValues = new HashMap();
        if (ids.size() == 1) {
            Map<Column<T, ?>, Object> localPkValues = this.getColumnValues(Iterables.first(ids));
            pkValues.put(this.primaryKey, localPkValues.get(this.primaryKey));
        } else {
            ids.forEach(id -> {
                Map<Column<T, ?>, Object> localPkValues = this.getColumnValues(id);
                ((List)pkValues.computeIfAbsent(this.primaryKey, k -> new ArrayList())).add(localPkValues.get(this.primaryKey));
            });
        }
        return pkValues;
    }

    public static boolean isDefaultPrimitiveValue(Object o) {
        return Reflections.PRIMITIVE_DEFAULT_VALUES.get(o.getClass()) == o;
    }
}

