/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.OptimizedUpdatePersister;
import org.codefilarete.stalactite.spring.repository.StalactiteRepository;
import org.codefilarete.stalactite.spring.repository.StalactiteRepositoryFactory;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.reflect.MethodDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;

public class StalactiteRepositoryFactoryBean<R extends Repository<C, I>, C, I>
extends TransactionalRepositoryFactoryBeanSupport<R, C, I> {
    private Class<?> entityType;
    private AdvancedEntityPersister<?, ?> entityPersister;
    private PersistenceContext persistenceContext;

    protected StalactiteRepositoryFactoryBean(Class<? extends R> repositoryInterface) {
        super(repositoryInterface);
        for (Type genericInterface : repositoryInterface.getGenericInterfaces()) {
            Type persistedType;
            if (!(genericInterface instanceof ParameterizedType) || !(((ParameterizedType)genericInterface).getRawType() instanceof Class) || !StalactiteRepository.class.isAssignableFrom((Class)((ParameterizedType)genericInterface).getRawType()) || !((persistedType = ((ParameterizedType)genericInterface).getActualTypeArguments()[0]) instanceof Class)) continue;
            this.entityType = (Class)persistedType;
        }
        if (this.entityType == null) {
            throw new UnsupportedOperationException("Entity type can't be deduced : repository class has unsupported generic type, must be a class");
        }
    }

    @Autowired
    public void setPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        applicationContext.getBeansOfType(EntityPersister.class);
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        EntityPersister foundPersister = this.persistenceContext.getPersister(this.entityType);
        if (foundPersister == null) {
            throw new IllegalArgumentException("No persister found for entityType " + Reflections.toString(this.entityType) + " in persistence context.");
        }
        ConfiguredRelationalPersister deepestDelegate = ((OptimizedUpdatePersister)foundPersister).getDeepestDelegate();
        MethodDispatcher methodDispatcher = new MethodDispatcher();
        methodDispatcher.redirect(AdvancedEntityPersister.class, (Object)((AdvancedEntityPersister)deepestDelegate)).redirect(ConfiguredPersister.class, (Object)((ConfiguredPersister)foundPersister));
        this.entityPersister = (AdvancedEntityPersister)methodDispatcher.build(AdvancedEntityPersister.class);
        return new StalactiteRepositoryFactory(this.entityPersister, this.persistenceContext.getDialect(), this.persistenceContext.getConnectionProvider());
    }
}

