/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetoone;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByMethod;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.onetoone.FirstPhaseCycleLoadListener;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.PassiveJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.onetoone.OneToOneOwnedByTargetEngine;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Duo;

public class OneToOneOwnedByTargetConfigurer<SRC, TRGT, SRCID, TRGTID, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>>
extends OneToOneConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, LEFTTABLE, RIGHTTABLE, SRCID> {
    private final Map<Column<LEFTTABLE, ?>, Column<RIGHTTABLE, ?>> keyColumnsMapping = new HashMap();
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private OneToOneOwnedByTargetEngine<SRC, TRGT, SRCID, TRGTID, LEFTTABLE, RIGHTTABLE> engine;
    private Key<RIGHTTABLE, SRCID> rightKey;

    public OneToOneOwnedByTargetConfigurer(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, OneToOneRelation<SRC, TRGT, TRGTID> oneToOneRelation, JoinColumnNamingStrategy joinColumnNamingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        super(sourcePersister, oneToOneRelation);
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
    }

    @Override
    protected Duo<Key<LEFTTABLE, SRCID>, Key<RIGHTTABLE, SRCID>> determineForeignKeyColumns(EntityMapping<SRC, SRCID, LEFTTABLE> mappingStrategy, EntityMapping<TRGT, TRGTID, RIGHTTABLE> targetMappingStrategy) {
        PrimaryKey leftKey = mappingStrategy.getTargetTable().getPrimaryKey();
        if (this.oneToOneRelation.getReverseColumn() != null) {
            this.rightKey = Key.ofSingleColumn(this.oneToOneRelation.getReverseColumn());
            PrimaryKey sourcePrimaryKey = this.sourcePersister.getMainTable().getPrimaryKey();
            if (sourcePrimaryKey.isComposed()) {
                throw new UnsupportedOperationException("Can't map composite primary key " + sourcePrimaryKey + " on single reverse foreign key : " + this.oneToOneRelation.getReverseColumn());
            }
            this.keyColumnsMapping.put((Column<LEFTTABLE, ?>)sourcePrimaryKey.getColumns().getAt(0), (Column<RIGHTTABLE, ?>)this.oneToOneRelation.getReverseColumn());
        }
        if (this.oneToOneRelation.getReverseGetter() != null) {
            AccessorByMethodReference localReverseGetter = Accessors.accessorByMethodReference(this.oneToOneRelation.getReverseGetter());
            AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)localReverseGetter);
            this.rightKey = this.createOrUseReverseColumn(targetMappingStrategy, (Column<RIGHTTABLE, SRCID>)this.oneToOneRelation.getReverseColumn(), (ValueAccessPoint<TRGT>)localReverseGetter, accessorDefinition);
        } else if (this.oneToOneRelation.getReverseSetter() != null) {
            MutatorByMethodReference reverseSetter = Accessors.mutatorByMethodReference(this.oneToOneRelation.getReverseSetter());
            AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)reverseSetter);
            this.rightKey = this.createOrUseReverseColumn(targetMappingStrategy, (Column<RIGHTTABLE, SRCID>)this.oneToOneRelation.getReverseColumn(), (ValueAccessPoint<TRGT>)reverseSetter, accessorDefinition);
        }
        String foreignKeyName = this.foreignKeyNamingStrategy.giveName(this.rightKey, leftKey);
        ((Table)this.rightKey.getTable()).addForeignKey(foreignKeyName, this.rightKey, (Key)leftKey);
        return new Duo((Object)leftKey, this.rightKey);
    }

    private Key<RIGHTTABLE, SRCID> createOrUseReverseColumn(EntityMapping<TRGT, TRGTID, RIGHTTABLE> targetMappingStrategy, Column<RIGHTTABLE, SRCID> reverseColumn, ValueAccessPoint<TRGT> reverseGetter, AccessorDefinition accessorDefinition) {
        if (reverseColumn == null && (reverseColumn = (Column)targetMappingStrategy.getPropertyToColumn().get(reverseGetter)) == null) {
            PrimaryKey sourcePrimaryKey = this.sourcePersister.getMainTable().getPrimaryKey();
            Key.KeyBuilder result = Key.from((Fromable)targetMappingStrategy.getTargetTable());
            sourcePrimaryKey.getColumns().forEach(pkColumn -> {
                Column column = targetMappingStrategy.getTargetTable().addColumn(this.joinColumnNamingStrategy.giveName(accessorDefinition, (Column<?, ?>)pkColumn), pkColumn.getJavaType());
                this.keyColumnsMapping.put((Column<LEFTTABLE, ?>)pkColumn, (Column<RIGHTTABLE, ?>)column);
                result.addColumn((JoinLink)column);
            });
            return result.build();
        }
        return Key.ofSingleColumn(reverseColumn);
    }

    @Override
    protected void addWriteCascades(ConfiguredPersister<TRGT, TRGTID> targetPersister) {
        boolean writeAuthorized;
        this.engine = new OneToOneOwnedByTargetEngine(this.sourcePersister, targetPersister, this.oneToOneRelation.getTargetProvider(), this.keyColumnsMapping);
        boolean bl = writeAuthorized = this.oneToOneRelation.getRelationMode() != CascadeOptions.RelationMode.READ_ONLY;
        if (writeAuthorized) {
            super.addWriteCascades(targetPersister);
        } else {
            this.engine.addForeignKeyMaintainer(this.dialect, this.connectionConfiguration, this.rightKey);
        }
    }

    @Override
    protected BeanRelationFixer<SRC, TRGT> determineRelationFixer() {
        BeanRelationFixer result;
        Mutator sourceIntoTargetFixer = this.oneToOneRelation.getTargetProvider().toMutator();
        if (this.oneToOneRelation.getReverseGetter() != null) {
            AccessorByMethodReference localReverseGetter = Accessors.accessorByMethodReference(this.oneToOneRelation.getReverseGetter());
            AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)localReverseGetter);
            MutatorByMethod targetIntoSourceFixer = Accessors.mutatorByMethod((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName());
            result = (arg_0, arg_1) -> OneToOneOwnedByTargetConfigurer.lambda$determineRelationFixer$1((Mutator)targetIntoSourceFixer, sourceIntoTargetFixer, arg_0, arg_1);
        } else {
            result = this.oneToOneRelation.getReverseSetter() != null ? (target, input) -> {
                this.oneToOneRelation.getReverseSetter().accept(input, target);
                sourceIntoTargetFixer.set(target, input);
            } : (arg_0, arg_1) -> ((Mutator)sourceIntoTargetFixer).set(arg_0, arg_1);
        }
        return result;
    }

    @Override
    protected void addSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, Key<LEFTTABLE, SRCID> leftKey, Key<RIGHTTABLE, SRCID> rightKey, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        Table targetTable = targetPersister.getMapping().getTargetTable();
        Table targetTableClone = new Table(targetTable.getName());
        Key.KeyBuilder relationOwnerForeignKey = Key.from((Fromable)targetTableClone);
        rightKey.getColumns().forEach(column -> relationOwnerForeignKey.addColumn((JoinLink)targetTableClone.addColumn(column.getName(), column.getJavaType())));
        Key.KeyBuilder relationOwnerPrimaryKey = Key.from((Fromable)targetTableClone);
        targetTable.getPrimaryKey().getColumns().forEach(column -> relationOwnerPrimaryKey.addColumn((JoinLink)targetTableClone.addColumn(column.getName(), column.getJavaType())));
        String joinName = this.sourcePersister.getEntityJoinTree().addPassiveJoin("ROOT", leftKey, relationOwnerForeignKey.build(), tableAlias, this.oneToOneRelation.isNullable() ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, relationOwnerPrimaryKey.build().getColumns(), (nodeEntity, columnValueProvider) -> {
            Object trgtId = targetPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(columnValueProvider);
            firstPhaseCycleLoadListener.onFirstPhaseRowRead(nodeEntity, trgtId);
        }, true);
        PassiveJoinNode passiveJoin = (PassiveJoinNode)this.sourcePersister.getEntityJoinTree().getJoin(joinName);
        targetPersister.getEntityJoinTree().foreachJoin(joinNode -> {
            if (joinNode instanceof RelationJoinNode && ((RelationJoinNode)joinNode).getEntityInflater().getEntityType() == this.sourcePersister.getClassToPersist()) {
                EntityJoinTree.copyNodeToParent(passiveJoin, joinNode, leftKey);
            }
        });
    }

    @Override
    protected void addInsertCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister) {
        super.addInsertCascade(targetPersister);
        this.engine.addInsertCascade();
    }

    @Override
    protected void addUpdateCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister, boolean orphanRemoval) {
        super.addUpdateCascade(targetPersister, orphanRemoval);
        this.engine.addUpdateCascade(orphanRemoval);
    }

    @Override
    protected void addDeleteCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister, boolean orphanRemoval) {
        this.engine.addDeleteCascade(orphanRemoval);
    }

    private static /* synthetic */ void lambda$determineRelationFixer$1(Mutator targetIntoSourceFixer, Mutator sourceIntoTargetFixer, Object src, Object target) {
        if (target != null) {
            targetIntoSourceFixer.set(target, src);
        }
        sourceIntoTargetFixer.set(src, target);
    }
}

