/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.RelationalMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementCollectionRelation;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementCollectionRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelation;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.EntityAsKeyAndValueMapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.EntityAsKeyMapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.MapRelation;
import org.codefilarete.stalactite.engine.configurer.map.MapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.ValueAsKeyMapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelationConfigurer;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.cycle.ManyToManyCycleConfigurer;
import org.codefilarete.stalactite.engine.runtime.cycle.OneToManyCycleConfigurer;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;

public class RelationConfigurer<C, I, T extends Table<T>> {
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final ConfiguredRelationalPersister<C, I> sourcePersister;
    private final NamingConfiguration namingConfiguration;
    private final OneToOneRelationConfigurer<C, I> oneToOneRelationConfigurer;

    public RelationConfigurer(Dialect dialect, ConnectionConfiguration connectionConfiguration, ConfiguredRelationalPersister<C, I> sourcePersister, NamingConfiguration namingConfiguration) {
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.sourcePersister = sourcePersister;
        this.namingConfiguration = namingConfiguration;
        this.oneToOneRelationConfigurer = new OneToOneRelationConfigurer<C, I>(this.dialect, this.connectionConfiguration, this.sourcePersister, namingConfiguration.getJoinColumnNamingStrategy(), namingConfiguration.getForeignKeyNamingStrategy());
    }

    public <TRGT, TRGTID> void configureRelations(RelationalMappingConfiguration<C> entityMappingConfiguration) {
        PersisterBuilderImpl.PostInitializer cycleSolver;
        Class targetEntityType;
        String relationName;
        PersisterBuilderContext currentBuilderContext = PersisterBuilderContext.CURRENT.get();
        for (OneToOneRelation oneToOneRelation : entityMappingConfiguration.getOneToOnes()) {
            this.oneToOneRelationConfigurer.configure(oneToOneRelation);
        }
        for (OneToManyRelation oneToManyRelation : entityMappingConfiguration.getOneToManys()) {
            OneToManyRelationConfigurer oneToManyRelationConfigurer = new OneToManyRelationConfigurer(oneToManyRelation, this.sourcePersister, this.dialect, this.connectionConfiguration, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getJoinColumnNamingStrategy(), this.namingConfiguration.getAssociationTableNamingStrategy(), this.namingConfiguration.getIndexColumnNamingStrategy());
            relationName = AccessorDefinition.giveDefinition(oneToManyRelation.getCollectionProvider()).getName();
            if (currentBuilderContext.isCycling(oneToManyRelation.getTargetMappingConfiguration())) {
                targetEntityType = oneToManyRelation.getTargetMappingConfiguration().getEntityType();
                cycleSolver = (OneToManyCycleConfigurer)Iterables.find(currentBuilderContext.getBuildLifeCycleListeners(), p -> p instanceof OneToManyCycleConfigurer && ((OneToManyCycleConfigurer)p).getEntityType() == targetEntityType);
                if (cycleSolver == null) {
                    cycleSolver = new OneToManyCycleConfigurer(targetEntityType);
                    currentBuilderContext.addBuildLifeCycleListener(cycleSolver);
                }
                ((OneToManyCycleConfigurer)cycleSolver).addCycleSolver(relationName, oneToManyRelationConfigurer);
            } else {
                oneToManyRelationConfigurer.configure(new PersisterBuilderImpl(oneToManyRelation.getTargetMappingConfiguration()));
            }
            currentBuilderContext.addBuildLifeCycleListener(new GraphLoadingRelationRegisterer(oneToManyRelation.getTargetMappingConfiguration().getEntityType(), oneToManyRelation.getCollectionProvider(), this.sourcePersister.getClassToPersist()));
        }
        for (ManyToManyRelation manyToManyRelation : entityMappingConfiguration.getManyToManyRelations()) {
            ManyToManyRelationConfigurer manyRelationConfigurer = new ManyToManyRelationConfigurer(manyToManyRelation, this.sourcePersister, this.dialect, this.connectionConfiguration, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getJoinColumnNamingStrategy(), this.namingConfiguration.getIndexColumnNamingStrategy(), this.namingConfiguration.getAssociationTableNamingStrategy());
            relationName = AccessorDefinition.giveDefinition(manyToManyRelation.getCollectionAccessor()).getName();
            if (currentBuilderContext.isCycling(manyToManyRelation.getTargetMappingConfiguration())) {
                targetEntityType = manyToManyRelation.getTargetMappingConfiguration().getEntityType();
                cycleSolver = (ManyToManyCycleConfigurer)Iterables.find(currentBuilderContext.getBuildLifeCycleListeners(), p -> p instanceof ManyToManyCycleConfigurer && ((ManyToManyCycleConfigurer)p).getEntityType() == targetEntityType);
                if (cycleSolver == null) {
                    cycleSolver = new ManyToManyCycleConfigurer(targetEntityType);
                    currentBuilderContext.addBuildLifeCycleListener(cycleSolver);
                }
                ((ManyToManyCycleConfigurer)cycleSolver).addCycleSolver(relationName, manyRelationConfigurer);
            } else {
                manyRelationConfigurer.configure(new PersisterBuilderImpl(manyToManyRelation.getTargetMappingConfiguration()));
            }
            currentBuilderContext.addBuildLifeCycleListener(new GraphLoadingRelationRegisterer(manyToManyRelation.getTargetMappingConfiguration().getEntityType(), manyToManyRelation.getCollectionAccessor(), this.sourcePersister.getClassToPersist()));
        }
        for (ElementCollectionRelation elementCollectionRelation : entityMappingConfiguration.getElementCollections()) {
            ElementCollectionRelationConfigurer elementCollectionRelationConfigurer = new ElementCollectionRelationConfigurer(elementCollectionRelation, this.sourcePersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getElementCollectionTableNamingStrategy(), this.dialect, this.connectionConfiguration);
            final SimpleRelationalEntityPersister collectionPersister = elementCollectionRelationConfigurer.configure();
            currentBuilderContext.addBuildLifeCycleListener(new GraphLoadingRelationRegisterer<C, I, C>(entityMappingConfiguration.getEntityType(), elementCollectionRelation.getCollectionProvider(), this.sourcePersister.getClassToPersist()){

                @Override
                public void consume(ConfiguredRelationalPersister<C, ?> targetPersister) {
                    super.consume(collectionPersister);
                }
            });
        }
        for (MapRelation mapRelation : entityMappingConfiguration.getMaps()) {
            ConfiguredRelationalPersister keyEntityPersister;
            EntityMappingConfiguration keyEntityConfiguration;
            if (mapRelation.getKeyEntityConfigurationProvider() != null && mapRelation.getValueEntityConfigurationProvider() != null) {
                keyEntityConfiguration = mapRelation.getKeyEntityConfigurationProvider().getConfiguration();
                keyEntityPersister = new PersisterBuilderImpl(keyEntityConfiguration).build(this.dialect, this.connectionConfiguration, null);
                EntityMappingConfiguration valueEntityConfiguration = mapRelation.getValueEntityConfigurationProvider().getConfiguration();
                ConfiguredRelationalPersister valueEntityPersister = new PersisterBuilderImpl(valueEntityConfiguration).build(this.dialect, this.connectionConfiguration, null);
                EntityAsKeyAndValueMapRelationConfigurer entityAsKeyMapRelationConfigurer = new EntityAsKeyAndValueMapRelationConfigurer(mapRelation, this.sourcePersister, keyEntityPersister, valueEntityPersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getEntryMapTableNamingStrategy(), this.dialect, this.connectionConfiguration);
                entityAsKeyMapRelationConfigurer.configure();
                continue;
            }
            if (mapRelation.getKeyEntityConfigurationProvider() != null) {
                keyEntityConfiguration = mapRelation.getKeyEntityConfigurationProvider().getConfiguration();
                keyEntityPersister = new PersisterBuilderImpl(keyEntityConfiguration).build(this.dialect, this.connectionConfiguration, null);
                EntityAsKeyMapRelationConfigurer entityAsKeyMapRelationConfigurer = new EntityAsKeyMapRelationConfigurer(mapRelation, this.sourcePersister, keyEntityPersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getEntryMapTableNamingStrategy(), this.dialect, this.connectionConfiguration);
                entityAsKeyMapRelationConfigurer.configure();
                continue;
            }
            if (mapRelation.getValueEntityConfigurationProvider() != null) {
                EntityMappingConfiguration valueEntityConfiguration = mapRelation.getValueEntityConfigurationProvider().getConfiguration();
                ConfiguredRelationalPersister valueEntityPersister = new PersisterBuilderImpl(valueEntityConfiguration).build(this.dialect, this.connectionConfiguration, null);
                ValueAsKeyMapRelationConfigurer valueAsKeyMapRelationConfigurer = new ValueAsKeyMapRelationConfigurer(mapRelation, this.sourcePersister, valueEntityPersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getEntryMapTableNamingStrategy(), this.dialect, this.connectionConfiguration);
                valueAsKeyMapRelationConfigurer.configure();
                continue;
            }
            MapRelationConfigurer mapRelationConfigurer = new MapRelationConfigurer(mapRelation, this.sourcePersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getEntryMapTableNamingStrategy(), this.dialect, this.connectionConfiguration);
            mapRelationConfigurer.configure();
        }
    }

    public static class GraphLoadingRelationRegisterer<C, I, TRGT>
    extends PersisterBuilderImpl.PostInitializer<TRGT> {
        private final ReversibleAccessor<C, Object> targetEntityAccessor;
        private final Class<C> sourceEntityType;

        public GraphLoadingRelationRegisterer(Class<TRGT> targetEntityType, ReversibleAccessor<C, ?> targetEntityAccessor, Class<C> sourceEntityType) {
            super(targetEntityType);
            this.targetEntityAccessor = targetEntityAccessor;
            this.sourceEntityType = sourceEntityType;
        }

        @Override
        public void consume(ConfiguredRelationalPersister<TRGT, ?> targetPersister) {
            PersisterRegistry persisterRegistry = PersisterBuilderContext.CURRENT.get().getPersisterRegistry();
            ConfiguredRelationalPersister registeredSourcePersister = (ConfiguredRelationalPersister)persisterRegistry.getPersister(this.sourceEntityType);
            registeredSourcePersister.registerRelation((ValueAccessPoint)this.targetEntityAccessor, targetPersister);
        }
    }
}

