/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.runtime.AssociationRecord;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordInsertionCascader;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class AssociationRecordInsertionCascaderTest {
    AssociationRecordInsertionCascaderTest() {
    }

    @Test
    void testAssociationRecordInsertionCascader_getTargets() {
        ClassMapping classMappingStrategyMock = (ClassMapping)Mockito.mock(ClassMapping.class);
        Mockito.when((Object)classMappingStrategyMock.getId(ArgumentMatchers.any(Keyboard.class))).thenAnswer(invocation -> ((Keyboard)invocation.getArgument(0)).getId());
        IdMapping idMappingStrategymock = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)idMappingStrategymock.getIdentifierInsertionManager()).thenReturn(Mockito.mock(IdentifierInsertionManager.class));
        Mockito.when((Object)classMappingStrategyMock.getIdMapping()).thenReturn((Object)idMappingStrategymock);
        ClassMapping keyClassMappingStrategyMock = (ClassMapping)Mockito.mock(ClassMapping.class);
        Mockito.when((Object)keyClassMappingStrategyMock.getId(ArgumentMatchers.any(Key.class))).thenAnswer(invocation -> ((Key)invocation.getArgument(0)).getId());
        AssociationRecordPersister persisterStub = new AssociationRecordPersister(classMappingStrategyMock, (Dialect)new DefaultDialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(ConnectionProvider.class), 1));
        AssociationRecordInsertionCascader testInstance = new AssociationRecordInsertionCascader(persisterStub, Keyboard::getKeys, (EntityMapping)classMappingStrategyMock, (EntityMapping)keyClassMappingStrategyMock);
        Keyboard inputData = new Keyboard(1L);
        Key key1 = new Key(1L);
        Key key2 = new Key(2L);
        Key key3 = new Key(3L);
        inputData.getKeys().addAll(Arrays.asList((Object[])new Key[]{key1, key2, key3}));
        Collection targets = testInstance.getTargets((Object)inputData);
        List expectedResult = Arrays.asList((Object[])new AssociationRecord[]{new AssociationRecord(inputData.getId(), key1.getId()), new AssociationRecord(inputData.getId(), key2.getId()), new AssociationRecord(inputData.getId(), key3.getId())});
        Assertions.assertThat((String)AssociationRecordInsertionCascaderTest.printAssociationRecord(targets)).isEqualTo(AssociationRecordInsertionCascaderTest.printAssociationRecord(expectedResult));
    }

    private static String printAssociationRecord(Iterable<AssociationRecord> records) {
        StringAppender result = new StringAppender(){

            public StringAppender cat(Object o) {
                if (o instanceof AssociationRecord) {
                    return super.cat((Object)AssociationRecordInsertionCascaderTest.print((AssociationRecord)o));
                }
                return super.cat(o);
            }
        };
        result.ccat(records, (Object)", ");
        return result.toString();
    }

    private static String print(AssociationRecord record) {
        return "{" + record.getLeft() + ", " + record.getRight() + "}";
    }

    static class Key
    implements Identified<Long> {
        private Identifier<Long> id;

        Key(Long id) {
            this.id = new PersistableIdentifier<Long>(id);
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }
    }

    static class Keyboard
    implements Identified<Long> {
        private Identifier<Long> id;
        private List<Key> keys = new ArrayList<Key>();

        Keyboard(Long id) {
            this.id = new PersistableIdentifier<Long>(id);
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public List<Key> getKeys() {
            return this.keys;
        }

        public void setKeys(List<Key> keys) {
            this.keys = keys;
        }
    }
}

