/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.cycle;

import java.util.LinkedHashSet;
import java.util.Set;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneConfigurerTemplate;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.cycle.OneToOneCycleLoader;

public class OneToOneCycleConfigurer<TRGT>
extends PersisterBuilderImpl.PostInitializer<TRGT> {
    private final Set<RelationConfigurer<?, ?, ?>> relations = new LinkedHashSet();

    public OneToOneCycleConfigurer(Class<TRGT> entityType) {
        super(entityType);
    }

    public <SRC> void addCycleSolver(String relationIdentifier, OneToOneConfigurerTemplate<SRC, TRGT, ?, ?, ?, ?, ?> oneToOneRelationConfigurer) {
        this.relations.add(new RelationConfigurer(relationIdentifier, oneToOneRelationConfigurer));
    }

    @Override
    public void consume(ConfiguredRelationalPersister<TRGT, ?> targetPersister) {
        this.registerRelationLoader(targetPersister);
    }

    private <SRC, TRGTID> void registerRelationLoader(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        OneToOneCycleLoader oneToOneCycleLoader = new OneToOneCycleLoader(targetPersister);
        targetPersister.addSelectListener(oneToOneCycleLoader);
        this.relations.forEach(c -> {
            String tableAlias = ((RelationConfigurer)c).relationName.replaceAll("\\W", "_");
            CascadeConfigurationResult configurationResult = ((RelationConfigurer)c).oneToOneRelationConfigurer.configureWithSelectIn2Phases(tableAlias, targetPersister, oneToOneCycleLoader);
            oneToOneCycleLoader.addRelation(((RelationConfigurer)c).relationName, configurationResult);
        });
    }

    private class RelationConfigurer<SRC, SRCID, TRGTID> {
        private final String relationName;
        private final OneToOneConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, ?, ?, ?> oneToOneRelationConfigurer;

        public RelationConfigurer(String relationName, OneToOneConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, ?, ?, ?> oneToOneRelationConfigurer) {
            this.relationName = relationName;
            this.oneToOneRelationConfigurer = oneToOneRelationConfigurer;
        }
    }
}

