/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformerTest;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;

class AccumulatorsTest {
    AccumulatorsTest() {
    }

    @Test
    void toCollection() {
        Accumulator testInstance = Accumulators.toCollection(ArrayDeque::new);
        ResultSetRowTransformerTest.Person titi = new ResultSetRowTransformerTest.Person("titi");
        ResultSetRowTransformerTest.Person tata = new ResultSetRowTransformerTest.Person("tata");
        ResultSetRowTransformerTest.Person toto = new ResultSetRowTransformerTest.Person("toto");
        Queue collect = (Queue)testInstance.collect((Iterable)Arrays.asHashSet((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto}));
        Assertions.assertThat((Collection)collect).containsExactlyInAnyOrder((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto});
    }

    @Test
    void toList() {
        Accumulator testInstance = Accumulators.toList();
        ResultSetRowTransformerTest.Person titi = new ResultSetRowTransformerTest.Person("titi");
        ResultSetRowTransformerTest.Person tata = new ResultSetRowTransformerTest.Person("tata");
        ResultSetRowTransformerTest.Person toto = new ResultSetRowTransformerTest.Person("toto");
        List collect = (List)testInstance.collect((Iterable)Arrays.asHashSet((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto}));
        Assertions.assertThat((List)collect).containsExactlyInAnyOrder((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto});
    }

    @Test
    void toUnmodifiableList() {
        Accumulator testInstance = Accumulators.toUnmodifiableList();
        ResultSetRowTransformerTest.Person titi = new ResultSetRowTransformerTest.Person("titi");
        ResultSetRowTransformerTest.Person tata = new ResultSetRowTransformerTest.Person("tata");
        ResultSetRowTransformerTest.Person toto = new ResultSetRowTransformerTest.Person("toto");
        List collect = (List)testInstance.collect((Iterable)Arrays.asHashSet((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto}));
        Assertions.assertThat((List)collect).containsExactlyInAnyOrder((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto});
        Assertions.assertThat((List)collect).isUnmodifiable();
    }

    @Test
    void toSet() {
        Accumulator testInstance = Accumulators.toSet();
        ResultSetRowTransformerTest.Person titi = new ResultSetRowTransformerTest.Person("titi");
        ResultSetRowTransformerTest.Person tata = new ResultSetRowTransformerTest.Person("tata");
        ResultSetRowTransformerTest.Person toto = new ResultSetRowTransformerTest.Person("toto");
        Set collect = (Set)testInstance.collect((Iterable)Arrays.asHashSet((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto}));
        Assertions.assertThat((Collection)collect).containsExactlyInAnyOrder((Object[])new ResultSetRowTransformerTest.Person[]{toto, titi, tata});
    }

    @Test
    void toUnmodifiableSet() {
        Accumulator testInstance = Accumulators.toUnmodifiableSet();
        ResultSetRowTransformerTest.Person titi = new ResultSetRowTransformerTest.Person("titi");
        ResultSetRowTransformerTest.Person tata = new ResultSetRowTransformerTest.Person("tata");
        ResultSetRowTransformerTest.Person toto = new ResultSetRowTransformerTest.Person("toto");
        Set collect = (Set)testInstance.collect((Iterable)Arrays.asHashSet((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto}));
        Assertions.assertThat((Collection)collect).containsExactlyInAnyOrder((Object[])new ResultSetRowTransformerTest.Person[]{toto, titi, tata});
        Assertions.assertThat((Collection)collect).isUnmodifiable();
    }

    @Test
    void toKeepingOrderSet() {
        Accumulator testInstance = Accumulators.toKeepingOrderSet();
        ResultSetRowTransformerTest.Person titi = new ResultSetRowTransformerTest.Person("titi");
        ResultSetRowTransformerTest.Person tata = new ResultSetRowTransformerTest.Person("tata");
        ResultSetRowTransformerTest.Person toto = new ResultSetRowTransformerTest.Person("toto");
        Set collect = (Set)testInstance.collect((Iterable)Arrays.asList((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto}));
        Assertions.assertThat((Collection)collect).containsExactly((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto});
    }

    @Test
    void toSortedSet() {
        Accumulator testInstance = Accumulators.toSortedSet(Comparator.comparing(ResultSetRowTransformerTest.Person::getName));
        ResultSetRowTransformerTest.Person titi = new ResultSetRowTransformerTest.Person("titi");
        ResultSetRowTransformerTest.Person tata = new ResultSetRowTransformerTest.Person("tata");
        ResultSetRowTransformerTest.Person toto = new ResultSetRowTransformerTest.Person("toto");
        NavigableSet collect = (NavigableSet)testInstance.collect((Iterable)Arrays.asHashSet((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto}));
        Assertions.assertThat((Collection)collect).containsExactly((Object[])new ResultSetRowTransformerTest.Person[]{tata, titi, toto});
    }

    @Test
    void groupingBy() {
        Accumulator testInstance = Accumulators.groupingBy(ResultSetRowTransformerTest.Person::getName);
        ResultSetRowTransformerTest.Person titi = new ResultSetRowTransformerTest.Person("titi");
        ResultSetRowTransformerTest.Person tata = new ResultSetRowTransformerTest.Person("tata");
        ResultSetRowTransformerTest.Person toto = new ResultSetRowTransformerTest.Person("toto");
        Map collect = (Map)testInstance.collect((Iterable)Arrays.asHashSet((Object[])new ResultSetRowTransformerTest.Person[]{titi, tata, toto}));
        Assertions.assertThat((Map)collect).containsExactlyInAnyOrderEntriesOf((Map)Maps.forHashMap(String.class, ResultSetRowTransformerTest.Person.class).add((Object)"titi", (Object)titi).add((Object)"tata", (Object)tata).add((Object)"toto", (Object)toto));
    }

    @Test
    void groupingBy_withMapping() {
        Accumulator testInstance = Accumulators.groupingBy(ResultSetRowTransformerTest.Vehicle::getName, (Accumulator)Accumulators.mapping(ResultSetRowTransformerTest.Vehicle::getColor, (Accumulator)Accumulators.toList()));
        ResultSetRowTransformerTest.Vehicle titi1 = new ResultSetRowTransformerTest.Vehicle("titi");
        titi1.setColor("yellow");
        ResultSetRowTransformerTest.Vehicle titi2 = new ResultSetRowTransformerTest.Vehicle("titi");
        titi2.setColor("blue");
        ResultSetRowTransformerTest.Vehicle toto = new ResultSetRowTransformerTest.Vehicle("toto");
        toto.setColor("brown");
        Map collect = (Map)testInstance.collect((Iterable)Arrays.asSet((Object[])new ResultSetRowTransformerTest.Vehicle[]{titi1, titi2, toto}));
        Assertions.assertThat((Map)collect).containsExactlyInAnyOrderEntriesOf((Map)Maps.forHashMap(String.class, (Class)null).add((Object)"titi", (Object)Arrays.asList((Object[])new String[]{"yellow", "blue"})).add((Object)"toto", (Object)Arrays.asList((Object[])new String[]{"brown"})));
    }

    @Test
    void mapping() {
        Accumulator testInstance = Accumulators.mapping(ResultSetRowTransformerTest.Vehicle::getColor, (Accumulator)Accumulators.toList());
        ResultSetRowTransformerTest.Vehicle titi1 = new ResultSetRowTransformerTest.Vehicle("titi");
        titi1.setColor("yellow");
        ResultSetRowTransformerTest.Vehicle titi2 = new ResultSetRowTransformerTest.Vehicle("titi");
        titi2.setColor("blue");
        ResultSetRowTransformerTest.Vehicle toto = new ResultSetRowTransformerTest.Vehicle("toto");
        toto.setColor("brown");
        List collect = (List)testInstance.collect((Iterable)Arrays.asSet((Object[])new ResultSetRowTransformerTest.Vehicle[]{titi1, titi2, toto}));
        Assertions.assertThat((List)collect).containsExactlyInAnyOrder((Object[])new String[]{"yellow", "blue", "brown"});
    }

    @Test
    void getFirst() {
        Accumulator testInstance = Accumulators.getFirst();
        String collect = (String)testInstance.collect((Iterable)Arrays.asList((Object[])new String[]{"tata", "titi", "toto"}));
        Assertions.assertThat((String)collect).isEqualTo("tata");
        collect = (String)testInstance.collect((Iterable)Arrays.asList((Object[])new String[]{null, "titi", "toto"}));
        Assertions.assertThat((String)collect).isEqualTo("titi");
        collect = (String)testInstance.collect((Iterable)Arrays.asList((Object[])new String[]{null, null, null}));
        Assertions.assertThat((String)collect).isNull();
    }

    @Test
    void getFirstUnique() {
        Accumulator testInstance = Accumulators.getFirstUnique();
        Assertions.assertThatCode(() -> {
            String cfr_ignored_0 = (String)testInstance.collect((Iterable)Arrays.asList((Object[])new String[]{"tata", "titi", "toto"}));
        }).hasMessage("Object was expected to be a lonely one but another object is present");
    }
}

