/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.PassiveJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Randomizer;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.ReadOnlyList;

public class EntityJoinTree<C, I> {
    public static final String ROOT_STRATEGY_NAME = "ROOT";
    private final JoinRoot<C, I, ?> root;
    private final Map<String, JoinNode<?>> joinIndex = new HashMap();
    private final NodeKeyGenerator indexKeyGenerator = new NodeKeyGenerator();
    private final Set<Table> tablesToBeExcludedFromDDL = Collections.newIdentitySet();

    public EntityJoinTree(EntityInflater<C, I> rootEntityInflater, Fromable table) {
        this.root = new JoinRoot<C, I, Fromable>(this, rootEntityInflater, table);
        this.joinIndex.put(ROOT_STRATEGY_NAME, this.root);
    }

    public EntityJoinTree(Function<EntityJoinTree<C, I>, JoinRoot<C, I, ?>> joinRootCreator) {
        this.root = joinRootCreator.apply(this);
        this.joinIndex.put(ROOT_STRATEGY_NAME, this.root);
    }

    public JoinRoot<C, I, ?> getRoot() {
        return this.root;
    }

    Map<String, JoinNode> getJoinIndex() {
        return java.util.Collections.unmodifiableMap(this.joinIndex);
    }

    public <U, T1 extends Table<T1>, T2 extends Table<T2>, ID> String addRelationJoin(String leftStrategyName, EntityInflater<U, ID> inflater, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn, String rightTableAlias, JoinType joinType, BeanRelationFixer<C, U> beanRelationFixer, Set<? extends Column<T2, ?>> additionalSelectableColumns) {
        return this.addRelationJoin(leftStrategyName, inflater, leftJoinColumn, rightJoinColumn, rightTableAlias, joinType, beanRelationFixer, additionalSelectableColumns, null);
    }

    public <U, T1 extends Table<T1>, T2 extends Table<T2>, ID, JOINTYPE> String addRelationJoin(String leftStrategyName, EntityInflater<U, ID> inflater, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, @Nullable String rightTableAlias, JoinType joinType, BeanRelationFixer<C, U> beanRelationFixer, Set<? extends Column<T2, ?>> additionalSelectableColumns, @Nullable BiFunction<Row, ColumnedRow, Object> relationIdentifierProvider) {
        return this.addJoin(leftStrategyName, parent -> new RelationJoinNode(parent, leftJoinColumn, rightJoinColumn, joinType, (Set<? extends Selectable<?>>)((Set<Selectable<?>>)new KeepOrderSet((Collection)Collections.cat((Collection[])new Collection[]{inflater.getSelectableColumns(), additionalSelectableColumns}))), rightTableAlias, inflater, beanRelationFixer, (BiFunction<Row, ColumnedRow, ?>)relationIdentifierProvider));
    }

    public <U, T1 extends Fromable, T2 extends Fromable, ID> String addMergeJoin(String leftStrategyName, EntityMerger<U> inflater, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn) {
        return this.addJoin(leftStrategyName, parent -> new MergeJoinNode(parent, leftJoinColumn, rightJoinColumn, JoinType.INNER, null, inflater));
    }

    public <U, T1 extends Fromable, T2 extends Fromable, ID> String addMergeJoin(String leftStrategyName, EntityMerger<U> entityMerger, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn, JoinType joinType) {
        return this.addJoin(leftStrategyName, parent -> new MergeJoinNode(parent, leftJoinColumn, rightJoinColumn, joinType, null, entityMerger));
    }

    public <U, T1 extends Fromable, T2 extends Fromable, ID> String addMergeJoin(String leftStrategyName, EntityMerger<U> entityMerger, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn, JoinType joinType, final Function<ColumnedRow, MergeJoinNode.MergeJoinRowConsumer<U>> columnedRowConsumer) {
        return this.addJoin(leftStrategyName, parent -> new MergeJoinNode<U, T1, T2, ID>((JoinNode)parent, leftJoinColumn, rightJoinColumn, joinType, null, entityMerger){

            @Override
            public MergeJoinNode.MergeJoinRowConsumer<U> toConsumer(ColumnedRow columnedRow) {
                return (MergeJoinNode.MergeJoinRowConsumer)columnedRowConsumer.apply(columnedRow);
            }
        });
    }

    public <T1 extends Table<T1>, T2 extends Table<T2>, JOINTYPE> String addPassiveJoin(String leftStrategyName, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, JoinType joinType, Set<? extends JoinLink<T2, ?>> columnsToSelect) {
        return this.addJoin(leftStrategyName, parent -> new PassiveJoinNode(parent, leftJoinColumn, rightJoinColumn, joinType, (Set<? extends Selectable<?>>)((Set<Selectable<?>>)columnsToSelect), null));
    }

    public <T1 extends Table<T1>, T2 extends Table<T2>, JOINTYPE> String addPassiveJoin(String leftStrategyName, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, JoinType joinType, Set<Column<T2, ?>> columnsToSelect, EntityTreeJoinNodeConsumptionListener<C> consumptionListener) {
        return this.addJoin(leftStrategyName, parent -> new PassiveJoinNode(parent, leftJoinColumn, rightJoinColumn, joinType, (Set<? extends Selectable<?>>)((Set<Selectable<?>>)columnsToSelect), null).setConsumptionListener(consumptionListener));
    }

    public <T1 extends Table<T1>, T2 extends Table<T2>, JOINTYPE> String addPassiveJoin(String leftStrategyName, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, String tableAlias, JoinType joinType, Set<Column<T2, ?>> columnsToSelect, EntityTreeJoinNodeConsumptionListener<C> consumptionListener, boolean rightTableParticipatesToDDL) {
        if (rightTableParticipatesToDDL) {
            this.tablesToBeExcludedFromDDL.add((Table)rightJoinColumn.getTable());
        }
        return this.addJoin(leftStrategyName, parent -> new PassiveJoinNode(parent, leftJoinColumn, rightJoinColumn, joinType, (Set<? extends Selectable<?>>)((Set<Selectable<?>>)columnsToSelect), tableAlias).setConsumptionListener(consumptionListener));
    }

    public String addJoin(String leftStrategyName, Function<? super JoinNode<Fromable>, ? extends AbstractJoinNode<?, ?, ?, ?>> joinNodeSupplier) {
        JoinNode<Fromable> owningJoin = this.getJoin(leftStrategyName);
        if (owningJoin == null) {
            throw new IllegalArgumentException("No join named " + leftStrategyName + " exists to add a new join on");
        }
        AbstractJoinNode<?, ?, ?, ?> joinNode = joinNodeSupplier.apply(owningJoin);
        String joinName = this.indexKeyGenerator.generateKey(joinNode);
        this.joinIndex.put(joinName, joinNode);
        return joinName;
    }

    @Nullable
    public JoinNode<Fromable> getJoin(String leftStrategyName) {
        return this.joinIndex.get(leftStrategyName);
    }

    @VisibleForTesting
    <T1 extends Table<T1>, T2 extends Table<T2>, E, ID, O> AbstractJoinNode<E, T1, T2, ID> giveJoin(Key<T1, O> leftKey, Key<T2, O> rightKey) {
        return (AbstractJoinNode)Iterables.find(this.joinIterator(), node -> node.getLeftJoinLink().getColumns().equals((Object)leftKey.getColumns()) && node.getRightJoinLink().getColumns().equals((Object)rightKey.getColumns()));
    }

    public Set<Table<?>> giveTables() {
        HashSet result = new HashSet();
        result.add((Table)this.root.getTable());
        this.foreachJoin(node -> {
            if (node.getTable() instanceof Table && !this.tablesToBeExcludedFromDDL.contains(node.getTable())) {
                result.add((Table)node.getTable());
            } else if (node.getTable() instanceof QueryStatement.PseudoTable) {
                result.addAll(this.lookupTable((QueryStatement.PseudoTable)node.getTable()));
            }
        });
        return result;
    }

    @VisibleForTesting
    Set<Table<?>> lookupTable(QueryStatement.PseudoTable pseudoTable) {
        Object queries;
        HashSet result = new HashSet();
        if (pseudoTable.getQueryStatement() instanceof Query) {
            queries = Arrays.asSet((Object[])new Query[]{(Query)pseudoTable.getQueryStatement()});
        } else if (pseudoTable.getQueryStatement() instanceof Union) {
            queries = ((Union)pseudoTable.getQueryStatement()).getQueries();
        } else {
            throw new IllegalArgumentException("Pseudo table type is not supported: " + Reflections.toString(pseudoTable.getClass()));
        }
        queries.forEach(query -> {
            Fromable rightTable = query.getFromDelegate().getRoot();
            if (rightTable instanceof Table) {
                result.add((Table)rightTable);
            } else if (rightTable instanceof QueryStatement.PseudoTable) {
                result.addAll(this.lookupTable((QueryStatement.PseudoTable)rightTable));
            }
        });
        queries.forEach(query -> query.getFromDelegate().getJoins().forEach(join -> {
            Fromable rightTable = join.getRightTable();
            if (rightTable instanceof Table) {
                result.add((Table)rightTable);
            } else if (rightTable instanceof QueryStatement.PseudoTable) {
                result.addAll(this.lookupTable((QueryStatement.PseudoTable)rightTable));
            }
        }));
        return result;
    }

    public void foreachJoin(Consumer<AbstractJoinNode<?, ?, ?, ?>> consumer) {
        this.joinIterator().forEachRemaining(consumer);
    }

    public <E, ID> void projectTo(EntityJoinTree<E, ID> target, String joinNodeName) {
        this.projectTo(target.getJoin(joinNodeName));
    }

    public void projectTo(JoinNode<Fromable> joinNode) {
        EntityJoinTree tree = joinNode.getTree();
        this.foreachJoinWithDepth(joinNode, (targetOwner, currentNode) -> {
            currentNode.getLeftJoinLink().getColumns().forEach(leftColumn -> {
                Selectable projectedLeftColumn = targetOwner.getTable().findColumn(leftColumn.getExpression());
                if (projectedLeftColumn == null) {
                    throw new IllegalArgumentException("Expected column " + leftColumn.getExpression() + " to exist in target table " + targetOwner.getTable().getName() + " but couldn't be found among " + Iterables.collect((Iterable)targetOwner.getTable().getColumns(), Selectable::getExpression, ArrayList::new));
                }
            });
            AbstractJoinNode nodeClone = EntityJoinTree.copyNodeToParent(currentNode, targetOwner, currentNode.getLeftJoinLink());
            Set<Map.Entry<String, JoinNode<?>>> set = this.joinIndex.entrySet();
            Map.Entry nodeName = (Map.Entry)Iterables.find(set, entry -> entry.getValue() == currentNode);
            tree.joinIndex.put((String)nodeName.getKey(), nodeClone);
            return nodeClone;
        });
    }

    public Iterator<AbstractJoinNode<?, ?, ?, ?>> joinIterator() {
        return new NodeIterator();
    }

    <S> void foreachJoinWithDepth(S initialNode, BiFunction<S, AbstractJoinNode<?, ?, ?, ?>, S> consumer) {
        ArrayDeque<S> targetPath = new ArrayDeque<S>();
        targetPath.add(initialNode);
        NodeIteratorWithDepth nodeIterator = new NodeIteratorWithDepth(targetPath, consumer);
        while (nodeIterator.hasNext()) {
            nodeIterator.next();
        }
    }

    public static AbstractJoinNode copyNodeToParent(AbstractJoinNode node, JoinNode parent, Key leftColumn) {
        AbstractJoinNode nodeCopy;
        if (node instanceof RelationJoinNode) {
            nodeCopy = new RelationJoinNode(parent, leftColumn, node.getRightJoinLink(), node.getJoinType(), node.getColumnsToSelect(), node.getTableAlias(), ((RelationJoinNode)node).getEntityInflater(), ((RelationJoinNode)node).getBeanRelationFixer(), ((RelationJoinNode)node).getRelationIdentifierProvider());
        } else if (node instanceof MergeJoinNode) {
            nodeCopy = new MergeJoinNode(parent, leftColumn, node.getRightJoinLink(), node.getJoinType(), node.getTableAlias(), ((MergeJoinNode)node).getMerger());
        } else if (node instanceof PassiveJoinNode) {
            nodeCopy = new PassiveJoinNode(parent, leftColumn, node.getRightJoinLink(), node.getJoinType(), (Set<? extends Selectable<?>>)node.getColumnsToSelect(), node.getTableAlias());
        } else {
            throw new UnsupportedOperationException("Unexpected type of join : some algorithm has changed, please implement it here or fix it : " + Reflections.toString(node.getClass()));
        }
        nodeCopy.setConsumptionListener(node.getConsumptionListener());
        return nodeCopy;
    }

    public static enum JoinType {
        INNER,
        OUTER;

    }

    private class NodeKeyGenerator {
        private final Randomizer keyGenerator = new Randomizer((Randomizer.IRandomGenerator)new Randomizer.LinearRandomGenerator(new Random()));

        private NodeKeyGenerator() {
        }

        private String generateKey(JoinNode node) {
            return node.getTable().getAbsoluteName() + "-" + Integer.toHexString(System.identityHashCode(EntityJoinTree.this)) + "-" + this.keyGenerator.randomHexString(6);
        }
    }

    private class NodeIteratorWithDepth<S>
    extends NodeIterator {
        private final Queue<S> targetPath;
        private final BiFunction<S, AbstractJoinNode<Object, Fromable, Fromable, Object>, S> consumer;

        public NodeIteratorWithDepth(Queue<S> targetPath, BiFunction<S, AbstractJoinNode<?, ?, ?, ?>, S> consumer) {
            this.targetPath = targetPath;
            this.consumer = consumer;
        }

        @Override
        public AbstractJoinNode next() {
            AbstractJoinNode nextIterationNode;
            super.next();
            S targetOwner = this.targetPath.peek();
            S nodeClone = this.consumer.apply(targetOwner, this.currentNode);
            if (this.nextDepth) {
                this.targetPath.add(nodeClone);
            }
            if ((nextIterationNode = (AbstractJoinNode)this.joinStack.peek()) != null && nextIterationNode.getParent() != this.currentNode.getParent()) {
                this.targetPath.remove();
            }
            return this.currentNode;
        }

        @Override
        public void forEachRemaining(Consumer<? super AbstractJoinNode<?, ?, ?, ?>> action) {
            throw new UnsupportedOperationException();
        }
    }

    private class NodeIterator
    implements Iterator<AbstractJoinNode<?, ?, ?, ?>> {
        protected final Queue<AbstractJoinNode> joinStack;
        protected AbstractJoinNode currentNode;
        protected boolean nextDepth = false;

        public NodeIterator() {
            this.joinStack = new ArrayDeque<AbstractJoinNode>((Collection<AbstractJoinNode>)EntityJoinTree.this.root.getJoins());
        }

        @Override
        public boolean hasNext() {
            return !this.joinStack.isEmpty();
        }

        @Override
        public AbstractJoinNode next() {
            this.currentNode = this.joinStack.remove();
            ReadOnlyList<AbstractJoinNode> nextJoins = this.currentNode.getJoins();
            this.joinStack.addAll((Collection<AbstractJoinNode>)nextJoins);
            this.nextDepth = !nextJoins.isEmpty();
            return this.currentNode;
        }
    }

    public static class PolymorphicMergeJoinRowConsumer<C, D extends C, I>
    extends MergeJoinNode.MergeJoinRowConsumer<D> {
        private final BiFunction<Row, ColumnedRow, I> identifierProvider = entityInflater::giveIdentifier;
        private final ColumnedRow columnedRow;

        public PolymorphicMergeJoinRowConsumer(PolymorphicEntityInflater<C, D, I, ?> entityInflater, ColumnedRow columnedRow) {
            super(entityInflater.copyTransformerWithAliases(columnedRow));
            this.columnedRow = columnedRow;
        }

        @Nullable
        public I giveIdentifier(Row row) {
            return this.identifierProvider.apply(row, this.columnedRow);
        }

        public D transform(Row row) {
            return (D)this.merger.transform(row);
        }
    }

    public static class PolymorphicEntityInflater<E, D extends E, I, T extends Table<T>>
    implements EntityInflater<D, I> {
        private final ConfiguredRelationalPersister<E, I> mainPersister;
        private final ConfiguredRelationalPersister<D, I> subPersister;

        public PolymorphicEntityInflater(ConfiguredRelationalPersister<E, I> mainPersister, ConfiguredRelationalPersister<D, I> subPersister) {
            this.mainPersister = mainPersister;
            this.subPersister = subPersister;
        }

        @Override
        public Class<D> getEntityType() {
            return this.subPersister.getClassToPersist();
        }

        @Override
        public I giveIdentifier(Row row, ColumnedRow columnedRow) {
            return (I)this.mainPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(row, columnedRow);
        }

        @Override
        public RowTransformer<D> copyTransformerWithAliases(ColumnedRow columnedRow) {
            return this.subPersister.getMapping().copyTransformerWithAliases(columnedRow);
        }

        @Override
        public Set<Selectable<?>> getSelectableColumns() {
            return this.subPersister.getMapping().getSelectableColumns();
        }
    }
}

