/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.runtime.SelectExecutor;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.DDLAppender;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSelect;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriterIndex;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Sorter;

public class EntityMappingTreeSelectExecutor<C, I, T extends Table<T>>
implements SelectExecutor<C, I> {
    private final EntityJoinTree<C, I> entityJoinTree;
    private final Dialect dialect;
    private final int blockSize;
    private final PrimaryKey<T, I> primaryKey;
    private final WhereClauseDMLNameProvider whereClauseDMLNameProvider;
    private final ConnectionProvider connectionProvider;
    private final IdentifierAssembler<I, T> identifierAssembler;
    protected SQLOperation.SQLOperationListener<Column<T, ?>> operationListener;
    private final DMLGenerator dmlGenerator;
    private String rawQuery;
    private EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery;
    private final ParameterBinderIndex.ParameterBinderIndexFromMap<Column<T, ?>, ParameterBinder<?>> parameterBinderForPKInSelect;

    public EntityMappingTreeSelectExecutor(EntityMapping<C, I, T> entityMapping, Dialect dialect, ConnectionProvider connectionProvider) {
        this.dialect = dialect;
        this.identifierAssembler = entityMapping.getIdMapping().getIdentifierAssembler();
        this.entityJoinTree = new EntityJoinTree(new EntityInflater.EntityMappingAdapter<C, I, T>(entityMapping), (Fromable)entityMapping.getTargetTable());
        this.blockSize = dialect.getInOperatorMaxSize();
        this.primaryKey = entityMapping.getTargetTable().getPrimaryKey();
        this.whereClauseDMLNameProvider = new WhereClauseDMLNameProvider(entityMapping.getTargetTable(), entityMapping.getTargetTable().getAbsoluteName(), dialect.getDmlNameProviderFactory());
        this.connectionProvider = connectionProvider;
        this.dmlGenerator = new DMLGenerator((ParameterBinderIndex)dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.NoopSorter(), k -> this.whereClauseDMLNameProvider);
        this.parameterBinderForPKInSelect = new ParameterBinderIndex.ParameterBinderIndexFromMap(Iterables.map((Iterable)this.primaryKey.getColumns(), Function.identity(), arg_0 -> ((ColumnBinderRegistry)dialect.getColumnBinderRegistry()).getBinder(arg_0)));
        PersisterBuilderContext currentBuilderContext = PersisterBuilderContext.CURRENT.get();
        currentBuilderContext.addBuildLifeCycleListener(new PersisterBuilderImpl.BuildLifeCycleListener(){

            @Override
            public void afterBuild() {
            }

            @Override
            public void afterAllBuild() {
                EntityMappingTreeSelectExecutor.this.prepareQuery();
            }
        });
    }

    @VisibleForTesting
    void prepareQuery() {
        ColumnBinderRegistry columnBinderRegistry = this.dialect.getColumnBinderRegistry();
        this.entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)columnBinderRegistry).buildSelectQuery();
        this.rawQuery = this.dialect.getQuerySQLBuilderFactory().queryBuilder(this.entityTreeQuery.getQuery()).toSQL();
    }

    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.entityJoinTree;
    }

    public void setOperationListener(SQLOperation.SQLOperationListener<Column<T, ?>> operationListener) {
        this.operationListener = operationListener;
    }

    public Set<C> select(Iterable<I> ids) {
        List parcels = Collections.parcel(ids, (int)this.blockSize);
        HashSet result = new HashSet(parcels.size() * this.blockSize);
        if (!parcels.isEmpty()) {
            DMLGenerator.ParameterizedWhere tableParameterizedWhere;
            JoinDDLAppender identifierCriteria = new JoinDDLAppender(this.whereClauseDMLNameProvider);
            List lastBlock = (List)Iterables.last((List)parcels, java.util.Collections.emptyList());
            int lastBlockSize = lastBlock.size();
            if (lastBlockSize != this.blockSize) {
                parcels = Iterables.cutTail((List)parcels);
            }
            InternalExecutor executor = this.newInternalExecutor(this.entityTreeQuery);
            if (!parcels.isEmpty()) {
                tableParameterizedWhere = this.dmlGenerator.appendTupledWhere((DDLAppender)identifierCriteria, (Collection)this.primaryKey.getColumns(), this.blockSize);
                result.addAll(executor.execute(this.rawQuery + " where " + (Object)((Object)identifierCriteria), parcels, tableParameterizedWhere.getColumnToIndex()));
            }
            if (!lastBlock.isEmpty()) {
                identifierCriteria.getAppender().setLength(0);
                tableParameterizedWhere = this.dmlGenerator.appendTupledWhere((DDLAppender)identifierCriteria, (Collection)this.primaryKey.getColumns(), lastBlock.size());
                result.addAll(executor.execute(this.rawQuery + " where " + (Object)((Object)identifierCriteria), java.util.Collections.singleton(lastBlock), tableParameterizedWhere.getColumnToIndex()));
            }
        }
        return result;
    }

    @VisibleForTesting
    InternalExecutor newInternalExecutor(EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery) {
        return new InternalExecutor(entityTreeQuery, (ConnectionProvider)new SimpleConnectionProvider(this.connectionProvider.giveConnection()));
    }

    private static class JoinDDLAppender
    extends DDLAppender {
        private JoinDDLAppender(DMLNameProvider dmlNameProvider) {
            super(dmlNameProvider, new Object[0]);
        }

        public StringAppender cat(Object o) {
            if (o instanceof Column) {
                return super.cat((Object)this.dmlNameProvider.getName((Selectable)((Column)o)));
            }
            return super.cat(o);
        }
    }

    private static class WhereClauseDMLNameProvider
    extends DMLNameProvider {
        private final Table whereTable;
        private final String whereTableAlias;
        private final DMLNameProvider delegate;

        private WhereClauseDMLNameProvider(Table whereTable, @Nullable String whereTableAlias, DMLNameProviderFactory delegateFactory) {
            super(java.util.Collections.emptyMap());
            this.whereTable = whereTable;
            this.whereTableAlias = whereTableAlias;
            this.delegate = delegateFactory.build(new HashMap());
        }

        public String getAlias(Fromable table) {
            if (table == this.whereTable) {
                return (String)Objects.preventNull((Object)this.whereTableAlias, (Object)table.getName());
            }
            throw new IllegalArgumentException("Table " + table.getName() + " is not expected to be used in the where clause");
        }

        public String getSimpleName(Selectable<?> column) {
            return this.delegate.getSimpleName(column);
        }

        public String getTablePrefix(Fromable table) {
            return this.delegate.getTablePrefix(table);
        }

        public String getName(Selectable<?> column) {
            return this.delegate.getName(column);
        }
    }

    @VisibleForTesting
    class InternalExecutor {
        private final EntityTreeInflater<C> entityTreeInflater;
        private final Map<String, ParameterBinder<?>> selectParameterBinders;
        private final SelectExecutor.InternalExecutor executor;
        private final ConnectionProvider connectionProvider;

        @VisibleForTesting
        InternalExecutor(EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery, ConnectionProvider connectionProvider) {
            this.entityTreeInflater = entityTreeQuery.getInflater();
            this.selectParameterBinders = entityTreeQuery.getSelectParameterBinders();
            this.connectionProvider = connectionProvider;
            this.executor = new SelectExecutor.InternalExecutor<C, I, T>(EntityMappingTreeSelectExecutor.this.identifierAssembler, null){

                protected Set<C> transform(Iterator<Row> rowIterator, int resultSize) {
                    return InternalExecutor.this.entityTreeInflater.transform(() -> rowIterator, resultSize);
                }
            };
        }

        @VisibleForTesting
        List<C> execute(String sql, Collection<? extends List<I>> idsParcels, Map<Column<T, ?>, int[]> inOperatorValueIndexes) {
            ColumnParameterizedSelect preparedSelect = new ColumnParameterizedSelect(sql, inOperatorValueIndexes, (PreparedStatementWriterIndex)EntityMappingTreeSelectExecutor.this.parameterBinderForPKInSelect, this.selectParameterBinders);
            ArrayList result = new ArrayList(idsParcels.size() * EntityMappingTreeSelectExecutor.this.blockSize);
            try (ReadOperation columnReadOperation = EntityMappingTreeSelectExecutor.this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSelect, this.connectionProvider);){
                columnReadOperation.setListener(EntityMappingTreeSelectExecutor.this.operationListener);
                for (List parcel : idsParcels) {
                    result.addAll(this.executor.execute(columnReadOperation, parcel));
                }
            }
            return result;
        }
    }
}

