/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.time.Month;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class JavaTypeToSqlTypeMappingTest {
    JavaTypeToSqlTypeMappingTest() {
    }

    static Object[][] getTypeName_withSingleton() {
        JavaTypeToSqlTypeMapping testInstance1 = new JavaTypeToSqlTypeMapping();
        testInstance1.put(String.class, "VARCHAR");
        JavaTypeToSqlTypeMapping testInstance2 = new JavaTypeToSqlTypeMapping();
        testInstance2.put(String.class, "CHAR($l)", (Size)Size.length((int)10));
        return new Object[][]{{testInstance1, String.class, null, "VARCHAR"}, {testInstance2, String.class, Size.length((int)10), "CHAR(10)"}};
    }

    @ParameterizedTest
    @MethodSource(value={"getTypeName_withSingleton"})
    void getTypeName_withSingleton(JavaTypeToSqlTypeMapping testInstance, Class javaType, Size size, String expected) {
        Assertions.assertThat((String)testInstance.getTypeName(javaType, size)).isEqualTo(expected);
    }

    static Object[][] getTypeName() {
        JavaTypeToSqlTypeMapping testInstance = new JavaTypeToSqlTypeMapping();
        testInstance.put(CharSequence.class, "VARCHAR");
        testInstance.put(String.class, "TEXT");
        testInstance.put(String.class, "CHAR($l)", (Size)Size.length((int)10));
        testInstance.put(String.class, "VARCHAR($l)", (Size)Size.length((int)100));
        testInstance.put(Double.class, "decimal(10, 2)");
        testInstance.put(Double.class, "decimal($p, $s)", (Size)Size.fixedPoint((int)Integer.MAX_VALUE, (Integer)Integer.MAX_VALUE));
        testInstance.put(Float.class, "decimal($p)", (Size)Size.fixedPoint((int)Integer.MAX_VALUE));
        testInstance.put(Enum.class, "myEnumType");
        testInstance.put(Month.class, "monthType");
        return new Object[][]{{testInstance, String.class, null, "TEXT"}, {testInstance, String.class, Size.length((int)5), "CHAR(5)"}, {testInstance, String.class, Size.length((int)10), "CHAR(10)"}, {testInstance, String.class, Size.length((int)50), "VARCHAR(50)"}, {testInstance, String.class, Size.length((int)100), "VARCHAR(100)"}, {testInstance, String.class, Size.length((int)101), "TEXT"}, {testInstance, Double.class, Size.fixedPoint((int)7, (Integer)3), "decimal(7, 3)"}, {testInstance, Double.class, null, "decimal(10, 2)"}, {testInstance, Float.class, Size.fixedPoint((int)10), "decimal(10)"}, {testInstance, CharSequence.class, null, "VARCHAR"}, {testInstance, CharSequence.class, Size.length((int)20), "VARCHAR"}, {testInstance, StringBuilder.class, null, "VARCHAR"}, {testInstance, StringBuilder.class, Size.length((int)20), "VARCHAR"}, {testInstance, TimeUnit.class, null, "myEnumType"}, {testInstance, Month.class, null, "monthType"}};
    }

    @ParameterizedTest
    @MethodSource(value={"getTypeName"})
    void getTypeName(JavaTypeToSqlTypeMapping testInstance, Class javaType, Size size, String expected) {
        Assertions.assertThat((String)testInstance.getTypeName(javaType, size)).isEqualTo(expected);
    }

    @Test
    void getTypeName_unknownType_returnsNull() {
        JavaTypeToSqlTypeMapping testInstance = new JavaTypeToSqlTypeMapping();
        Assertions.assertThat((String)testInstance.getTypeName(Object.class)).isNull();
    }
}

