/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.OperatorSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Variable;
import org.codefilarete.stalactite.query.model.operator.Cast;
import org.codefilarete.stalactite.query.model.operator.Coalesce;
import org.codefilarete.stalactite.query.model.operator.DateFormat;
import org.codefilarete.stalactite.query.model.operator.Equals;
import org.codefilarete.stalactite.query.model.operator.Greater;
import org.codefilarete.stalactite.query.model.operator.IsNull;
import org.codefilarete.stalactite.query.model.operator.Lesser;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.stalactite.query.model.operator.LowerCase;
import org.codefilarete.stalactite.query.model.operator.Max;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.query.model.operator.UpperCase;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class OperatorSQLBuilderTest {
    private final DMLNameProvider dmlNameProvider = new DMLNameProvider(Collections.emptyMap());

    OperatorSQLBuilderTest() {
    }

    @Test
    public void cat_nullValue_isTransformedToIsNull() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.cat((ConditionalOperator)new ConditionalOperator<Object, Object>(){

            public void setValue(Variable<Object> value) {
            }

            public boolean isNull() {
                return true;
            }
        }, (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("is null");
    }

    @Test
    public void catNullValue() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catNullValue(false, (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("is null");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catNullValue(true, (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("is not null");
    }

    @Test
    public void catIsNull() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catIsNull(new IsNull(), (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("is null");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catIsNull((IsNull)Operators.not((ConditionalOperator)new IsNull()), (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("is not null");
        result = new StringSQLAppender(this.dmlNameProvider);
        IsNull isNull = new IsNull();
        isNull.setValue((Object)42);
        testInstance.catIsNull(isNull, (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("is null");
    }

    @Test
    public void catLike() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(new Like((Object)"a"), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like 'a'");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(Operators.contains((CharSequence)"a"), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like '%a%'");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(Operators.startsWith((CharSequence)"a"), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like 'a%'");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(Operators.endsWith((CharSequence)"a"), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like '%a'");
    }

    @Test
    public void catLike_withFunction() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(new Like((Object)new LowerCase((Object)"a")), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like lower('a')");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(new Like((Object)new LowerCase((Object)"a"), true, true), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like lower('%a%')");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(new Like((Object)new LowerCase((Object)"a"), false, true), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like lower('a%')");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(new Like((Object)new LowerCase((Object)"a"), true, false), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like lower('%a')");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(new Like((Object)new LowerCase((Object)new UpperCase((Object)"a"))), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like lower(upper('a'))");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(new Like((Object)new LowerCase((Object)new UpperCase((Object)new DateFormat((Selectable)new Selectable.SelectableString("\"2018-09-24\"", CharSequence.class), "%D %b %Y")))), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like lower(upper(date_format(\"2018-09-24\", '%D %b %Y')))");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(Operators.contains((SQLFunction)Operators.lowerCase((SQLFunction)Operators.upperCase((SQLFunction)Operators.trim((CharSequence)"a")))), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like lower(upper(trim('%a%')))");
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", String.class);
        Column colB = tableToto.addColumn("b", String.class);
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLike(new Like((Object)new LowerCase((Object)new UpperCase((Object)new Coalesce((Selectable)colA, new Object[]{new Cast((Selectable)colB, String.class)}))), true, true), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("like lower(upper(coalesce(Toto.a, cast(Toto.b as varchar))))");
    }

    @Test
    public void catIn() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catIn(Operators.in((Object[])new String[]{"a", "b"}), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("in ('a', 'b')");
        result = new StringSQLAppender(this.dmlNameProvider);
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", Integer.class);
        Column colB = tableToto.addColumn("b", Integer.class);
        testInstance.catIn(Operators.in((Object[])new Max[]{Operators.max((Selectable)colA), Operators.max((Selectable)colB)}), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("in (max(Toto.a), max(Toto.b))");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catIn(Operators.in((Object[])new Object[0]), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("in ()");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.cat((ConditionalOperator)Operators.in((Object[])new Object[]{null}), (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("in (null)");
    }

    @Test
    public void catIn_tupled() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        Table dummyTable = new Table("dummyTable");
        Column firstName = dummyTable.addColumn("firstName", String.class);
        Column lastName = dummyTable.addColumn("lastName", String.class);
        TupleIn tupleIn = new TupleIn(new Column[]{firstName, lastName}, Arrays.asList((Object[])new Object[][]{{"John", "Doe"}, {"Jane", "Doe"}, {"Paul", "Smith"}}));
        testInstance.cat((ConditionalOperator)tupleIn, (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("(dummyTable.firstName, dummyTable.lastName) in (('John', 'Doe'), ('Jane', 'Doe'), ('Paul', 'Smith'))");
        result = new StringSQLAppender(this.dmlNameProvider);
        tupleIn = new TupleIn(new Column[]{firstName, lastName}, Collections.emptyList());
        testInstance.cat((ConditionalOperator)tupleIn, (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("(dummyTable.firstName, dummyTable.lastName) in ()");
        result = new StringSQLAppender(this.dmlNameProvider);
        tupleIn = new TupleIn(new Column[]{firstName, lastName}, (List)null);
        testInstance.cat((ConditionalOperator)tupleIn, (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("(dummyTable.firstName, dummyTable.lastName) in (null, null)");
        result = new StringSQLAppender(this.dmlNameProvider);
        ArrayList<Object[]> input = new ArrayList<Object[]>();
        input.add(new Object[]{"John", null});
        tupleIn = new TupleIn(new Column[]{firstName, lastName}, input);
        testInstance.cat((ConditionalOperator)tupleIn, (SQLAppender)result);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("(dummyTable.firstName, dummyTable.lastName) in (('John', null))");
    }

    @Test
    public void catBetween() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catBetween(Operators.between((Object)1, (Object)2), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("between 1 and 2");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catBetween(Operators.between((Object)1, null), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("> 1");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catBetween(Operators.between(null, (Object)2), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("< 2");
    }

    @Test
    public void catGreater() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catGreater(Operators.gt((Object)1), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("> 1");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catGreater((Greater)Operators.not((ConditionalOperator)Operators.gt((Object)1)), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("<= 1");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catGreater(Operators.gteq((Object)1), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo(">= 1");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catGreater((Greater)Operators.not((ConditionalOperator)Operators.gteq((Object)1)), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("< 1");
    }

    @Test
    public void catLower() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLower(Operators.lt((Object)1), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("< 1");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLower((Lesser)Operators.not((ConditionalOperator)Operators.lt((Object)1)), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo(">= 1");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLower(Operators.lteq((Object)1), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("<= 1");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catLower((Lesser)Operators.not((ConditionalOperator)Operators.lteq((Object)1)), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("> 1");
    }

    @Test
    public void catEquals() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catEquals(Operators.eq((Object)1), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("= 1");
    }

    @Test
    public void catEquals_withFunction() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catEquals(new Equals((Object)new LowerCase((Object)"a")), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("= lower('a')");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catEquals(new Equals((Object)new LowerCase((Object)new UpperCase((Object)"a"))), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("= lower(upper('a'))");
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catEquals(new Equals((Object)new LowerCase((Object)new UpperCase((Object)new DateFormat((Selectable)new Selectable.SelectableString("\"2018-09-24\"", CharSequence.class), "%D %b %Y")))), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("= lower(upper(date_format(\"2018-09-24\", '%D %b %Y')))");
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", String.class);
        Column colB = tableToto.addColumn("b", String.class);
        result = new StringSQLAppender(this.dmlNameProvider);
        testInstance.catEquals(new Equals((Object)new LowerCase((Object)new UpperCase((Object)new Coalesce((Selectable)colA, new Object[]{new Cast((Selectable)colB, String.class)})))), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("= lower(upper(coalesce(Toto.a, cast(Toto.b as varchar))))");
    }

    @Test
    public void catEquals_column() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder(new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", Integer.class);
        testInstance.catEquals(Operators.eq((Object)colA), (SQLAppender)result, null);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("= Toto.a");
    }

    @Nested
    class LikePatternAppenderTest {
        LikePatternAppenderTest() {
        }

        @Test
        public void likePattern() {
            OperatorSQLBuilderFactory.OperatorSQLBuilder.LikePatternAppender testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder.LikePatternAppender(new Like(false, true), (SQLAppender)new StringSQLAppender(OperatorSQLBuilderTest.this.dmlNameProvider));
            testInstance.cat("select * from Toto where a like(", new String[0]).catValue((Object)"me").cat(")", new String[0]);
            String preparedSQL = testInstance.getSQL();
            Assertions.assertThat((String)preparedSQL).isEqualTo("select * from Toto where a like('me%')");
        }

        @Test
        void newSubPart() {
            Table totoTable = new Table("Toto");
            OperatorSQLBuilderFactory.OperatorSQLBuilder.LikePatternAppender testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder.LikePatternAppender(new Like(false, true), (SQLAppender)new StringSQLAppender(new DMLNameProvider(k -> "Tutu")));
            testInstance.cat("select * from ", new String[0]).newSubPart(new DMLNameProvider(k -> "Tata")).cat("(select * from ", new String[0]).catTable((Fromable)totoTable).cat(" where a like(", new String[0]).catValue((Object)"me").cat("))", new String[0]).close().cat(", ", new String[0]).newSubPart(new DMLNameProvider(k -> "Titi")).cat("(select * from ", new String[0]).catTable((Fromable)totoTable).cat(")", new String[0]).close().cat(", ", new String[0]).catTable((Fromable)totoTable).cat(" where a like(", new String[0]).catValue((Object)"me").cat(")", new String[0]);
            String preparedSQL = testInstance.getSQL();
            Assertions.assertThat((String)preparedSQL).isEqualTo("select * from (select * from Toto where a like('me%')), (select * from Toto), Toto where a like('me%')");
        }
    }
}

