/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Placeholder;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.query.model.Variable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.trace.MutableInt;

public class PreparedSQLAppender
implements SQLAppender {
    private final SQLAppender delegate;
    private final ColumnBinderRegistry parameterBinderRegistry;
    private final Map<Integer, ParameterBinder<?>> parameterBinders;
    private final Map<Integer, Object> values;
    private final MutableInt paramCounter;

    public PreparedSQLAppender(SQLAppender sqlAppender, ColumnBinderRegistry parameterBinderRegistry) {
        this(sqlAppender, parameterBinderRegistry, new HashMap(), new HashMap<Integer, Object>(), new MutableInt(1));
    }

    private PreparedSQLAppender(SQLAppender delegate, ColumnBinderRegistry parameterBinderRegistry, Map<Integer, ? extends ParameterBinder<?>> parameterBinders, Map<Integer, Object> values, MutableInt paramCounter) {
        this.delegate = delegate;
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.parameterBinders = parameterBinders;
        this.values = values;
        this.paramCounter = paramCounter;
    }

    public Map<Integer, Object> getValues() {
        return this.values;
    }

    public Map<Integer, ParameterBinder<?>> getParameterBinders() {
        return this.parameterBinders;
    }

    @Override
    public PreparedSQLAppender cat(String s, String ... ss) {
        this.delegate.cat(s, ss);
        return this;
    }

    @Override
    public <V> PreparedSQLAppender catValue(@Nullable Selectable<V> column, Object value) {
        ParameterBinder<V> parameterBinder = column == null ? this.getParameterBinderFromRegistry(value) : (column instanceof Column ? this.parameterBinderRegistry.getBinder((Column)column) : this.parameterBinderRegistry.getBinder(column.getJavaType()));
        return this.catValue(value, parameterBinder);
    }

    @Override
    public PreparedSQLAppender catValue(Object value) {
        return this.catValue(value, this.getParameterBinderFromRegistry(value));
    }

    private ParameterBinder<?> getParameterBinderFromRegistry(Variable value) {
        Object parameterBinder = null;
        if (value instanceof ValuedVariable) {
            parameterBinder = this.getParameterBinderFromRegistry(((ValuedVariable)value).getValue());
        } else if (value instanceof Placeholder) {
            parameterBinder = this.parameterBinderRegistry.getBinder(((Placeholder)value).getValueType());
        }
        return parameterBinder;
    }

    private ParameterBinder<?> getParameterBinderFromRegistry(Object value) {
        ParameterBinder<?> parameterBinder;
        if (value instanceof Variable) {
            parameterBinder = this.getParameterBinderFromRegistry((Variable)value);
        } else {
            Class<?> binderType = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
            parameterBinder = this.parameterBinderRegistry.getBinder(binderType);
        }
        return parameterBinder;
    }

    private PreparedSQLAppender catValue(Object value, ParameterBinder<?> binderSupplier) {
        if (value instanceof ValuedVariable) {
            Object innerValue = ((ValuedVariable)value).getValue();
            if (innerValue instanceof Column) {
                this.delegate.catColumn((Column)innerValue);
            } else {
                this.appendPlaceholder(innerValue, binderSupplier);
            }
        } else {
            this.appendPlaceholder(value, binderSupplier);
        }
        return this;
    }

    private void appendPlaceholder(Object value, ParameterBinder<?> binderSupplier) {
        this.delegate.cat("?", new String[0]);
        this.values.put(this.paramCounter.getValue(), value);
        this.parameterBinders.put(this.paramCounter.getValue(), binderSupplier);
        this.paramCounter.increment();
    }

    @Override
    public PreparedSQLAppender catColumn(Selectable<?> column) {
        this.delegate.catColumn(column);
        return this;
    }

    @Override
    public SQLAppender catTable(Fromable table) {
        this.delegate.catTable(table);
        return this;
    }

    @Override
    public SQLAppender removeLastChars(int length) {
        this.delegate.removeLastChars(length);
        return this;
    }

    @Override
    public String getSQL() {
        return this.delegate.getSQL();
    }

    @Override
    public SQLAppender.SubSQLAppender newSubPart(DMLNameProvider dmlNameProvider) {
        final PreparedSQLAppender self = this;
        return new SQLAppender.DefaultSubSQLAppender(new PreparedSQLAppender(this.delegate.newSubPart(dmlNameProvider), this.parameterBinderRegistry, this.parameterBinders, this.values, this.paramCounter)){

            @Override
            public SQLAppender close() {
                return self;
            }
        };
    }
}

