/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.function.Sequence;
import org.codefilarete.tool.function.Serie;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class PersisterBuilderImplTest {
    private static final Dialect DIALECT = new DefaultDialect();

    @BeforeAll
    static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
        DIALECT.getColumnBinderRegistry().register(Color.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER, Color::new, Color::getRgb)));
        DIALECT.getSqlTypeRegistry().put(Color.class, "int");
        DIALECT.getDmlGenerator().sortColumnsAlphabetically();
    }

    @BeforeEach
    void initEntityCandidates() {
        PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class)));
    }

    @AfterEach
    void removeEntityCandidates() {
        PersisterBuilderContext.CURRENT.remove();
    }

    @Test
    void assertCompositeKeyIdentifierOverridesEqualsHashcode() throws NoSuchFieldException {
        EntityMappingConfiguration.CompositeKeyMapping compositeKeyMappingMock = (EntityMappingConfiguration.CompositeKeyMapping)Mockito.mock(EntityMappingConfiguration.CompositeKeyMapping.class, (Answer)Mockito.RETURNS_MOCKS);
        class DummyEntity {
            private 1DummyCompositeKeyIdentifier dummyCompositeKeyIdentifier;
            private 1DummyCompositeKeyIdentifierWithEqualsAndHashCode dummyCompositeKeyIdentifierWithEqualsAndHashCode;

            DummyEntity() {
            }
        }
        Mockito.when((Object)compositeKeyMappingMock.getAccessor()).thenReturn((Object)new AccessorByField(DummyEntity.class.getDeclaredField("dummyCompositeKeyIdentifier")));
        Assertions.assertThatCode(() -> PersisterBuilderImpl.assertCompositeKeyIdentifierOverridesEqualsHashcode((EntityMappingConfiguration.CompositeKeyMapping)compositeKeyMappingMock)).hasMessage("Composite key identifier class o.c.s.e.c.PersisterBuilderImplTest$DummyCompositeKeyIdentifier seems to have default implementation of equals() and hashcode() methods, which is not supported (identifiers must be distinguishable), please make it implement them");
        Mockito.when((Object)compositeKeyMappingMock.getAccessor()).thenReturn((Object)new AccessorByField(DummyEntity.class.getDeclaredField("dummyCompositeKeyIdentifierWithEqualsAndHashCode")));
        Assertions.assertThatCode(() -> PersisterBuilderImpl.assertCompositeKeyIdentifierOverridesEqualsHashcode((EntityMappingConfiguration.CompositeKeyMapping)compositeKeyMappingMock)).doesNotThrowAnyException();
    }

    @Test
    void collectEmbeddedMappingFromInheritance_fromMappedSuperClasses() {
        PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Car::getModel).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(AbstractVehicle.class).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate))));
        Table dummyTable = new Table("Car");
        testInstance.setColumnBinderRegistry(DIALECT.getColumnBinderRegistry()).setTable(dummyTable).mapEntityConfigurationToTable();
        PersisterBuilderImpl.MappingPerTable map = testInstance.collectPropertiesMappingFromInheritance();
        ArrayList expected = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Car::getModel), (Mutator)Accessors.mutatorByField(Car.class, (String)"model")), (Object)dummyTable.getColumn("model")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getCreationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("creationDate")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getModificationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("modificationDate")).entrySet());
        expected.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actual = new ArrayList(map.giveMapping(dummyTable).entrySet());
        actual.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actual).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expected);
    }

    @Test
    void collectEmbeddedMappingFromInheritance_fromInheritedClasses() {
        PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate))));
        Table dummyTable = new Table("Car");
        testInstance.setColumnBinderRegistry(DIALECT.getColumnBinderRegistry()).setTable(dummyTable).mapEntityConfigurationToTable();
        PersisterBuilderImpl.MappingPerTable mappingPerTable = testInstance.collectPropertiesMappingFromInheritance();
        ArrayList expected = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Car::getModel), (Mutator)Accessors.mutatorByField(Car.class, (String)"model")), (Object)dummyTable.getColumn("model")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getCreationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("creationDate")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getModificationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("modificationDate")).entrySet());
        expected.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        Assertions.assertThat((Collection)mappingPerTable.giveTables()).extracting(Table::getAbsoluteName).containsExactly((Object[])new String[]{"Car"});
        ArrayList actual = new ArrayList(mappingPerTable.giveMapping(dummyTable).entrySet());
        actual.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actual).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expected);
    }

    @Test
    void collectEmbeddedMappingFromInheritance_fromInheritedClasses_withJoinedTables() {
        Table carTable = new Table("Car");
        Table vehicleTable = new Table("Vehicle");
        Table abstractVehicleTable = new Table("AbstractVehicle");
        PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).embed(Vehicle::getColor, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Color.class).map(Color::getRgb)).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate))).withJoinedTable()).withJoinedTable(vehicleTable));
        testInstance.setColumnBinderRegistry(DIALECT.getColumnBinderRegistry()).setTable(carTable).mapEntityConfigurationToTable();
        PersisterBuilderImpl.MappingPerTable map = testInstance.collectPropertiesMappingFromInheritance();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)map.giveTables()).usingElementComparator(Comparator.comparing(Table::getAbsoluteName))).containsExactly((Object[])new Table[]{carTable, vehicleTable, abstractVehicleTable});
        ArrayList expectedCarMapping = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Car::getModel), (Mutator)Accessors.mutatorByField(Car.class, (String)"model")), (Object)carTable.getColumn("model")).entrySet());
        expectedCarMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actualCarMapping = new ArrayList(map.giveMapping(carTable).entrySet());
        actualCarMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actualCarMapping).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expectedCarMapping);
        ArrayList expectedVehicleMapping = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Vehicle::getColor), (Mutator)Accessors.mutatorByMethodReference(Vehicle::setColor)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Color::getRgb), (Mutator)Accessors.mutatorByField(Color.class, (String)"rgb"))}), (Object)vehicleTable.getColumn("rgb")).entrySet());
        expectedVehicleMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actualVehicleMapping = new ArrayList(map.giveMapping(vehicleTable).entrySet());
        actualVehicleMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actualVehicleMapping).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expectedVehicleMapping);
        abstractVehicleTable = (Table)Iterables.find((Iterable)map.giveTables(), arg_0 -> ((Table)abstractVehicleTable).equals(arg_0));
        ArrayList expectedAbstractVehicleMapping = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getCreationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)abstractVehicleTable.getColumn("creationDate")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getModificationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setModificationDate))}), (Object)abstractVehicleTable.getColumn("modificationDate")).entrySet());
        expectedAbstractVehicleMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actualAbstractVehicleMapping = new ArrayList(map.giveMapping(abstractVehicleTable).entrySet());
        actualAbstractVehicleMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actualAbstractVehicleMapping).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expectedAbstractVehicleMapping);
    }

    @Test
    void collectEmbeddedMappingFromInheritance_withoutHierarchy() {
        PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Car::getModel).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)));
        Table dummyTable = new Table("Car");
        testInstance.setColumnBinderRegistry(DIALECT.getColumnBinderRegistry()).setTable(dummyTable).mapEntityConfigurationToTable();
        PersisterBuilderImpl.MappingPerTable map = testInstance.collectPropertiesMappingFromInheritance();
        ArrayList expected = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Car::getModel), (Mutator)Accessors.mutatorByField(Car.class, (String)"model")), (Object)dummyTable.getColumn("model")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getCreationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("creationDate")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getModificationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("modificationDate")).entrySet());
        expected.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actual = new ArrayList(map.giveMapping(dummyTable).entrySet());
        actual.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actual).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expected);
    }

    @Test
    void addIdentifyingPrimaryKey_alreadyAssignedPolicy() {
        EntityMappingConfiguration identifyingConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(o -> {}, o -> true)).withColumnNaming(accessorDefinition -> "myId").getConfiguration();
        Table mainTable = new Table("AbstractVehicle");
        PersisterBuilderImpl testInstance = new PersisterBuilderImpl(identifyingConfiguration).setTable(mainTable);
        testInstance.mapEntityConfigurationToTable();
        testInstance.addIdentifyingPrimarykey((AbstractIdentification)AbstractIdentification.forSingleKey((EntityMappingConfiguration)identifyingConfiguration));
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mainTable.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{mainTable.getColumn("myId")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isAutoGenerated()).isFalse();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isNullable()).isFalse();
    }

    @Test
    void addIdentifyingPrimarykey_beforeInsertPolicy() {
        EntityMappingConfiguration identifyingConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.pooledHiLoSequence((Sequence)new Sequence<Identifier<Long>>(){
            private long identifier = 0L;

            public Identifier<Long> next() {
                return new PersistableIdentifier<Long>(this.identifier++);
            }
        })).withColumnNaming(accessorDefinition -> "myId").getConfiguration();
        Table mainTable = new Table("AbstractVehicle");
        PersisterBuilderImpl testInstance = new PersisterBuilderImpl(identifyingConfiguration).setTable(mainTable);
        testInstance.mapEntityConfigurationToTable();
        testInstance.addIdentifyingPrimarykey((AbstractIdentification)AbstractIdentification.forSingleKey((EntityMappingConfiguration)identifyingConfiguration));
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mainTable.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{mainTable.getColumn("myId")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isAutoGenerated()).isFalse();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isNullable()).isFalse();
    }

    @Test
    void addIdentifyingPrimarykey_afterInsertPolicy() {
        EntityMappingConfiguration identifyingConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).withColumnNaming(accessorDefinition -> "myId").getConfiguration();
        Table mainTable = new Table("AbstractVehicle");
        PersisterBuilderImpl testInstance = new PersisterBuilderImpl(identifyingConfiguration).setTable(mainTable);
        testInstance.mapEntityConfigurationToTable();
        testInstance.addIdentifyingPrimarykey((AbstractIdentification)AbstractIdentification.forSingleKey((EntityMappingConfiguration)identifyingConfiguration));
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mainTable.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{mainTable.getColumn("myId")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isAutoGenerated()).isTrue();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isNullable()).isFalse();
    }

    @Test
    void propagatePrimarykey() {
        EntityMappingConfiguration identifyingConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).getConfiguration();
        Table mainTable = new Table("AbstractVehicle");
        PersisterBuilderImpl testInstance = new PersisterBuilderImpl(identifyingConfiguration).setTable(mainTable);
        testInstance.mapEntityConfigurationToTable();
        testInstance.addIdentifyingPrimarykey((AbstractIdentification)AbstractIdentification.forSingleKey((EntityMappingConfiguration)identifyingConfiguration));
        Table tableB = new Table("Vehicle");
        Table tableC = new Table("Car");
        PersisterBuilderImpl.propagatePrimaryKey((PrimaryKey)mainTable.getPrimaryKey(), (Set)Arrays.asSet((Object[])new Table[]{tableB, tableC}));
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mainTable.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{mainTable.getColumn("id")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isAutoGenerated()).isTrue();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isNullable()).isFalse();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)tableB.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{tableB.getColumn("id")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)tableB.getPrimaryKey().getColumns())).isAutoGenerated()).isFalse();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)tableB.getPrimaryKey().getColumns())).isNullable()).isFalse();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)tableC.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{tableC.getColumn("id")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)tableC.getPrimaryKey().getColumns())).isAutoGenerated()).isFalse();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)tableC.getPrimaryKey().getColumns())).isNullable()).isFalse();
    }

    @Test
    void applyForeignKeys() {
        EntityMappingConfiguration identifyingConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).getConfiguration();
        Table mainTable = new Table("AbstractVehicle");
        PersisterBuilderImpl testInstance = new PersisterBuilderImpl(identifyingConfiguration).setTable(mainTable);
        testInstance.mapEntityConfigurationToTable();
        Table tableB = new Table("Vehicle");
        Table tableC = new Table("Car");
        PrimaryKey primaryKey = testInstance.addIdentifyingPrimarykey((AbstractIdentification)AbstractIdentification.forSingleKey((EntityMappingConfiguration)identifyingConfiguration));
        PersisterBuilderImpl.propagatePrimaryKey((PrimaryKey)primaryKey, (Set)Arrays.asSet((Object[])new Table[]{tableB, tableC}));
        testInstance.applyForeignKeys(primaryKey, (Set)Arrays.asSet((Object[])new Table[]{tableB, tableC}));
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, ToStringBuilder.asSeveral(columnPrinter)));
        Assertions.assertThat((Collection)tableB.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter)).containsExactly(new Object[]{new ForeignKey("FK_Vehicle_id_AbstractVehicle_id", tableB.getColumn("id"), mainTable.getColumn("id"))});
        Assertions.assertThat((Collection)tableC.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter)).containsExactly(new Object[]{new ForeignKey("FK_Car_id_Vehicle_id", tableC.getColumn("id"), tableB.getColumn("id"))});
    }

    public static class ToStringBuilder<E> {
        private final String separator;
        private final KeepOrderSet<Function<E, String>> mappers = new KeepOrderSet();

        @SafeVarargs
        public static <E> Function<E, String> of(String separator, Function<E, String> ... properties) {
            ToStringBuilder<E> result = new ToStringBuilder<E>(separator);
            for (Function<E, String> property : properties) {
                result.with(property);
            }
            return result::toString;
        }

        public static <E> Function<? extends Iterable<E>, String> asSeveral(final Function<E, String> mapper) {
            return coll -> new StringAppender(){

                public StringAppender cat(Object s) {
                    return super.cat(s instanceof String ? s : mapper.apply(s));
                }
            }.ccat(coll, (Object)"").wrap((Object)"{", (Object)"}").toString();
        }

        private ToStringBuilder(String separator) {
            this.separator = separator;
        }

        ToStringBuilder<E> with(Function<E, String> mapper) {
            this.mappers.add(mapper);
            return this;
        }

        String toString(E object) {
            return new StringAppender().ccat((Iterable)Iterables.collectToList(this.mappers, m -> (String)m.apply(object)), (Object)this.separator).toString();
        }
    }

    @Nested
    class BuildTest {
        BuildTest() {
        }

        @BeforeEach
        void removeEntityCandidates() {
            PersisterBuilderContext.CURRENT.remove();
        }

        @Test
        void build_connectionProviderIsNotRollbackObserver_throwsException() {
            DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
            PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).versionedBy(Country::getVersion, (Serie)new Serie.IntegerSerie()).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription));
            ConnectionConfiguration.ConnectionConfigurationSupport connectionConfiguration = new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new CurrentThreadConnectionProvider(dataSource), 10);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.build(DIALECT, (ConnectionConfiguration)connectionConfiguration, null)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Version control is only supported for o.c.s.s.ConnectionProvider that implements o.c.s.s.RollbackObserver");
        }

        @Test
        void build_twiceForSameClass_throwsException() {
            PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).map(Vehicle::getColor).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)));
            ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
            PersistenceContext persistenceContext = new PersistenceContext(connectionProviderMock, DIALECT);
            testInstance.build(persistenceContext);
            ((AbstractThrowableAssert)Assertions.assertThatCode(() -> testInstance.build(persistenceContext)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Persister already exists for class o.c.s.e.m.Car");
        }

        @Test
        void build_singleTable_singleClass() throws SQLException {
            PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).map(Vehicle::getColor).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)));
            ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
            Connection connectionMock = (Connection)Mockito.mock(Connection.class);
            Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connectionMock);
            ArgumentCaptor sqlCaptor = ArgumentCaptor.forClass(String.class);
            PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            Mockito.when((Object)connectionMock.prepareStatement((String)sqlCaptor.capture(), ArgumentMatchers.eq((int)1))).thenReturn((Object)preparedStatementMock);
            Mockito.when((Object)preparedStatementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
            ConfiguredRelationalPersister result = testInstance.build(new PersistenceContext(connectionProviderMock, DIALECT));
            Car entity = new Car(1L);
            entity.setModel("Renault");
            entity.setColor(new Color(123));
            entity.setTimestamp(new Timestamp());
            result.insert((Object)entity);
            Assertions.assertThat((List)sqlCaptor.getAllValues()).containsExactly((Object[])new String[]{"insert into Car(color, creationDate, id, model, modificationDate) values (?, ?, ?, ?, ?)"});
        }

        @Test
        void build_singleTable_withInheritance() throws SQLException {
            PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).map(Vehicle::getColor).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)))));
            ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
            Connection connectionMock = (Connection)Mockito.mock(Connection.class);
            Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connectionMock);
            ArgumentCaptor sqlCaptor = ArgumentCaptor.forClass(String.class);
            PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            Mockito.when((Object)connectionMock.prepareStatement((String)sqlCaptor.capture(), ArgumentMatchers.eq((int)1))).thenReturn((Object)preparedStatementMock);
            Mockito.when((Object)preparedStatementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
            ConfiguredRelationalPersister result = testInstance.build(new PersistenceContext(connectionProviderMock, DIALECT));
            Car entity = new Car(1L);
            entity.setModel("Renault");
            entity.setColor(new Color(123));
            entity.setTimestamp(new Timestamp());
            result.insert((Object)entity);
            Assertions.assertThat((List)sqlCaptor.getAllValues()).containsExactly((Object[])new String[]{"insert into Car(color, creationDate, id, model, modificationDate) values (?, ?, ?, ?, ?)"});
        }

        @Test
        void build_joinedTables() throws SQLException {
            PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).map(Vehicle::getColor).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate))).withJoinedTable()).withJoinedTable());
            ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
            Connection connectionMock = (Connection)Mockito.mock(Connection.class);
            Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connectionMock);
            ArgumentCaptor insertCaptor = ArgumentCaptor.forClass(String.class);
            PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            Mockito.when((Object)connectionMock.prepareStatement((String)insertCaptor.capture(), ArgumentMatchers.eq((int)1))).thenReturn((Object)preparedStatementMock);
            Mockito.when((Object)preparedStatementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
            Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet(Collections.emptyIterator()));
            ConfiguredRelationalPersister result = testInstance.build(new PersistenceContext(connectionProviderMock, DIALECT));
            Car entity = new Car(1L);
            entity.setModel("Renault");
            entity.setColor(new Color(123));
            entity.setTimestamp(new Timestamp());
            result.insert((Object)entity);
            Assertions.assertThat((List)insertCaptor.getAllValues()).containsExactly((Object[])new String[]{"insert into AbstractVehicle(creationDate, id, modificationDate) values (?, ?, ?)", "insert into Vehicle(color, id) values (?, ?)", "insert into Car(id, model) values (?, ?)"});
            ArgumentCaptor deleteCaptor = ArgumentCaptor.forClass(String.class);
            Mockito.when((Object)connectionMock.prepareStatement((String)deleteCaptor.capture())).thenReturn((Object)preparedStatementMock);
            result.delete((Object)entity);
            Assertions.assertThat((List)deleteCaptor.getAllValues()).containsExactly((Object[])new String[]{"delete from Car where id = ?", "delete from Vehicle where id = ?", "delete from AbstractVehicle where id = ?"});
            ArgumentCaptor selectCaptor = ArgumentCaptor.forClass(String.class);
            Mockito.when((Object)connectionMock.prepareStatement((String)selectCaptor.capture())).thenReturn((Object)preparedStatementMock);
            result.select(entity.getId());
            Assertions.assertThat((List)selectCaptor.getAllValues()).containsExactly((Object[])new String[]{"select Car.model as Car_model, Car.id as Car_id, AbstractVehicle.creationDate as AbstractVehicle_creationDate, AbstractVehicle.modificationDate as AbstractVehicle_modificationDate, AbstractVehicle.id as AbstractVehicle_id, Vehicle.color as Vehicle_color, Vehicle.id as Vehicle_id from Car inner join AbstractVehicle as AbstractVehicle on Car.id = AbstractVehicle.id inner join Vehicle as Vehicle on Car.id = Vehicle.id where Car.id in (?)"});
        }

        @Test
        void build_createsAnInstanceThatDoesntRequireTwoSelectsOnItsUpdateMethod() throws SQLException {
            PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Car::getModel));
            ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
            Connection connectionMock = (Connection)Mockito.mock(Connection.class);
            Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connectionMock);
            ArgumentCaptor insertCaptor = ArgumentCaptor.forClass(String.class);
            PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            Mockito.when((Object)connectionMock.prepareStatement((String)insertCaptor.capture())).thenReturn((Object)preparedStatementMock);
            Mockito.when((Object)connectionMock.prepareStatement((String)insertCaptor.capture(), ArgumentMatchers.eq((int)1))).thenReturn((Object)preparedStatementMock);
            Mockito.when((Object)preparedStatementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
            Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"Car_id", (Object)1L).add((Object)"Car_model", (Object)"Renault")})));
            ConfiguredRelationalPersister result = testInstance.build(new PersistenceContext(connectionProviderMock, DIALECT));
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            result.insert((Object)dummyCar);
            result.update(dummyCar.getId(), vehicle -> vehicle.setModel("Peugeot"));
            Assertions.assertThat((List)insertCaptor.getAllValues()).containsExactly((Object[])new String[]{"insert into Car(id, model) values (?, ?)", "select Car.model as Car_model, Car.id as Car_id from Car where Car.id in (?)", "update Car set model = ? where id = ?"});
            ArgumentCaptor valueIndexCaptor = ArgumentCaptor.forClass(Integer.TYPE);
            ArgumentCaptor valueCaptor = ArgumentCaptor.forClass(String.class);
            ((PreparedStatement)Mockito.verify((Object)preparedStatementMock, (VerificationMode)Mockito.times((int)2))).setString((Integer)valueIndexCaptor.capture(), (String)valueCaptor.capture());
            Assertions.assertThat((List)valueCaptor.getAllValues()).containsExactly((Object[])new String[]{"Renault", "Peugeot"});
            ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeQuery();
        }

        @Test
        void build_resultAssertsThatPersisterManageGivenEntities() {
            PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)));
            ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
            ConfiguredRelationalPersister result = testInstance.build(new PersistenceContext(connectionProviderMock, DIALECT));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$3((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$5((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$7((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$9((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$11((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$13((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
        }

        @Test
        void build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities() {
            PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Vehicle.class, Identifier.LONG_TYPE))));
            ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
            ConfiguredRelationalPersister result = testInstance.build(new PersistenceContext(connectionProviderMock, DIALECT));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$15((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$17((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$19((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$21((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$23((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$25((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        }

        @Test
        void build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities() {
            PersisterBuilderImpl testInstance = new PersisterBuilderImpl((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Vehicle.class, Identifier.LONG_TYPE), (Object)"Vehicle")));
            ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
            ConfiguredRelationalPersister result = testInstance.build(new PersistenceContext(connectionProviderMock, DIALECT));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$27((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$29((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$31((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$33((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$35((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuildTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$37((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        }

        private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$37(EntityPersister result) throws Throwable {
            result.deleteById((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$35(EntityPersister result) throws Throwable {
            result.delete((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$33(EntityPersister result) throws Throwable {
            result.updateById((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$31(EntityPersister result) throws Throwable {
            result.update((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$29(EntityPersister result) throws Throwable {
            result.insert((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$27(EntityPersister result) throws Throwable {
            result.persist((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$25(EntityPersister result) throws Throwable {
            result.deleteById((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$23(EntityPersister result) throws Throwable {
            result.delete((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$21(EntityPersister result) throws Throwable {
            result.updateById((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$19(EntityPersister result) throws Throwable {
            result.update((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$17(EntityPersister result) throws Throwable {
            result.insert((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$15(EntityPersister result) throws Throwable {
            result.persist((Object)new Car(42L));
        }

        private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$13(EntityPersister result) throws Throwable {
            result.deleteById((Object)new Vehicle(42L));
        }

        private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$11(EntityPersister result) throws Throwable {
            result.delete((Object)new Vehicle(42L));
        }

        private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$9(EntityPersister result) throws Throwable {
            result.updateById((Object)new Vehicle(42L));
        }

        private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$7(EntityPersister result) throws Throwable {
            result.update((Object)new Vehicle(42L));
        }

        private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$5(EntityPersister result) throws Throwable {
            result.insert((Object)new Vehicle(42L));
        }

        private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$3(EntityPersister result) throws Throwable {
            result.persist((Object)new Vehicle(42L));
        }
    }
}

