/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.mapping.AbstractTransformer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Duo;

public class JoinTableRootJoinNode<C, I, T extends Table<T>>
extends JoinRoot<C, I, T> {
    private final Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters;
    private final Set<Column<T, ?>> selectableColumns;
    private JoinTablePolymorphicJoinRootRowConsumer<C, I> rootConsumer;

    public JoinTableRootJoinNode(EntityJoinTree<C, I> tree, ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters, Set<? extends Column<T, ?>> selectableColumns, T mainTable) {
        super(tree, new EntityInflater.EntityMappingAdapter(mainPersister.getMapping()), mainTable);
        this.subPersisters = subPersisters;
        this.selectableColumns = selectableColumns;
    }

    @Override
    public Set<Selectable<?>> getColumnsToSelect() {
        return this.selectableColumns;
    }

    @Override
    public JoinRowConsumer.RootJoinRowConsumer<C> toConsumer(ColumnedRow columnedRow) {
        RowTransformer rootRowTransformer = this.getEntityInflater().copyTransformerWithAliases(columnedRow);
        Set subEntityConsumer = this.subPersisters.stream().map(subPersister -> {
            EntityMapping mapping = subPersister.getMapping();
            return new SubPersisterConsumer(row -> mapping.getIdMapping().getIdentifierAssembler().assemble(row, columnedRow), mapping.getClassToPersist(), (AbstractTransformer)mapping.copyTransformerWithAliases(columnedRow));
        }).collect(Collectors.toSet());
        this.rootConsumer = new JoinTablePolymorphicJoinRootRowConsumer(rootRowTransformer, subEntityConsumer, this.getConsumptionListener() == null ? null : (rootEntity, row) -> this.getConsumptionListener().onNodeConsumption(rootEntity, column -> columnedRow.getValue((Selectable)column, row)));
        return this.rootConsumer;
    }

    public void addSubPersister(ConfiguredRelationalPersister<C, I> persister, MergeJoinNode.MergeJoinRowConsumer<C> subConsumer, ColumnedRow columnedRow) {
        ((JoinTablePolymorphicJoinRootRowConsumer)this.rootConsumer).subConsumers.forEach(pawnConsumer -> {
            if (((SubPersisterConsumer)pawnConsumer).subEntityType == persister.getClassToPersist()) {
                ((SubPersisterConsumer)pawnConsumer).subPropertiesApplier = subConsumer;
                ((SubPersisterConsumer)pawnConsumer).identifierAssembler = row -> persister.getMapping().getIdMapping().getIdentifierAssembler().assemble(row, columnedRow);
            }
        });
    }

    static class JoinTablePolymorphicJoinRootRowConsumer<C, I>
    implements JoinRowConsumer.RootJoinRowConsumer<C> {
        private static final ThreadLocal<MergeJoinNode.MergeJoinRowConsumer<?>> CURRENTLY_FOUND_CONSUMER = new ThreadLocal();
        private final RowTransformer<C> rootRowTransformer;
        private final Set<SubPersisterConsumer<C, I>> subConsumers;
        @Nullable
        private final BiConsumer<C, Row> consumptionListener;

        private JoinTablePolymorphicJoinRootRowConsumer(RowTransformer<C> rootRowTransformer, Set<SubPersisterConsumer<C, I>> subConsumers, @Nullable BiConsumer<C, Row> consumptionListener) {
            this.rootRowTransformer = rootRowTransformer;
            this.subConsumers = subConsumers;
            this.consumptionListener = consumptionListener;
        }

        @Override
        public C createRootInstance(Row row, EntityTreeInflater.TreeInflationContext context) {
            Object result;
            Duo subInflater = this.findSubInflater(row);
            if (subInflater == null) {
                CURRENTLY_FOUND_CONSUMER.remove();
                result = null;
            } else {
                CURRENTLY_FOUND_CONSUMER.set(((SubPersisterConsumer)subInflater.getRight()).subPropertiesApplier);
                result = context.giveEntityFromCache(((SubPersisterConsumer)subInflater.getRight()).subEntityType, subInflater.getLeft(), () -> ((SubPersisterConsumer)subInflater.getRight()).subEntityFactory.newBeanInstance(row));
                this.rootRowTransformer.applyRowToBean(row, result);
            }
            if (this.consumptionListener != null) {
                this.consumptionListener.accept(result, row);
            }
            return (C)result;
        }

        @Nullable
        public Duo<I, SubPersisterConsumer<C, I>> findSubInflater(Row row) {
            for (SubPersisterConsumer<C, I> pawn : this.subConsumers) {
                Object assemble = ((SubPersisterConsumer)pawn).identifierAssembler.apply(row);
                if (assemble == null) continue;
                return new Duo(assemble, pawn);
            }
            return null;
        }

        public Set<JoinRowConsumer> giveExcludedConsumers() {
            return this.subConsumers.stream().map(subConsumer -> ((SubPersisterConsumer)subConsumer).subPropertiesApplier).filter(consumerPawn -> CURRENTLY_FOUND_CONSUMER.get() != consumerPawn).collect(Collectors.toSet());
        }
    }

    static class SubPersisterConsumer<C, I> {
        private Function<Row, I> identifierAssembler;
        private final Class<C> subEntityType;
        private final AbstractTransformer<C> subEntityFactory;
        private MergeJoinNode.MergeJoinRowConsumer<C> subPropertiesApplier;

        private SubPersisterConsumer(Function<Row, I> identifierAssembler, Class<C> subEntityType, AbstractTransformer<C> subEntityFactory) {
            this.identifierAssembler = identifierAssembler;
            this.subEntityType = subEntityType;
            this.subEntityFactory = subEntityFactory;
        }
    }
}

