/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.sequence.hilo;

import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequenceOptions;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequencePersister;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.tool.function.Sequence;

public class PooledHiLoSequence
implements Sequence<Long> {
    private LongPool sequenceState;
    private final PooledHiLoSequencePersister persister;
    private final PooledHiLoSequenceOptions options;

    public PooledHiLoSequence(PooledHiLoSequenceOptions options, Dialect dialect, SeparateTransactionExecutor separateTransactionExecutor, int jdbcBatchSize) {
        this(options, new PooledHiLoSequencePersister(options.getStorageOptions(), dialect, separateTransactionExecutor, jdbcBatchSize));
    }

    public PooledHiLoSequence(PooledHiLoSequenceOptions options, PooledHiLoSequencePersister persister) {
        this.options = options;
        this.persister = persister;
    }

    public PooledHiLoSequencePersister getPersister() {
        return this.persister;
    }

    public PooledHiLoSequenceOptions getOptions() {
        return this.options;
    }

    public synchronized Long next() {
        if (this.sequenceState == null) {
            this.initSequenceState();
        }
        return this.sequenceState.nextValue();
    }

    private void initSequenceState() {
        final String sequenceName = this.options.getSequenceName();
        PooledHiLoSequencePersister.Sequence existingSequence = (PooledHiLoSequencePersister.Sequence)this.persister.select(sequenceName);
        long initialValue = existingSequence == null ? this.options.getInitialValue() : existingSequence.getStep();
        this.sequenceState = new LongPool(this.options.getPoolSize(), --initialValue){

            @Override
            void onBoundReached() {
                PooledHiLoSequence.this.persister.reservePool(sequenceName, this.getPoolSize());
            }
        };
        this.sequenceState.onBoundReached();
    }

    private static abstract class LongPool {
        private final int poolSize;
        private long currentValue;
        protected long upperBound;

        public LongPool(int poolSize, long currentValue) {
            this.poolSize = poolSize;
            this.currentValue = currentValue;
            this.nextBound();
        }

        public int getPoolSize() {
            return this.poolSize;
        }

        public long getCurrentValue() {
            return this.currentValue;
        }

        public long nextValue() {
            if (this.currentValue == this.upperBound) {
                this.onBoundReached();
                this.nextBound();
            }
            ++this.currentValue;
            return this.currentValue;
        }

        protected void nextBound() {
            this.upperBound = this.currentValue + (long)this.poolSize;
        }

        abstract void onBoundReached();
    }
}

