/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.runtime.ColumnCloneAwareOrderBy;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.Maps;

public class EntityGraphSelector<C, I, T extends Table<T>>
implements EntitySelector<C, I> {
    private static final String PRIMARY_KEY_ALIAS = "rootId";
    private final EntityJoinTree<C, I> entityJoinTree;
    private final ConnectionProvider connectionProvider;
    private final Dialect dialect;

    public EntityGraphSelector(EntityJoinTree<C, I> entityJoinTree, ConnectionProvider connectionProvider, Dialect dialect) {
        this.entityJoinTree = entityJoinTree;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
    }

    public Set<C> selectFromQueryBean(String sql, Map<String, Object> values) {
        HashMap parameterBinders = new HashMap();
        values.forEach((paramName, value) -> {
            PreparedStatementWriter writer = this.dialect.getColumnBinderRegistry().getWriter(value.getClass());
            parameterBinders.put((String)paramName, (PreparedStatementWriter<?>)writer);
        });
        return this.selectFromQueryBean(sql, values, parameterBinders);
    }

    public Set<C> selectFromQueryBean(String sql, Map<String, Object> values, Map<String, PreparedStatementWriter<?>> parameterBinders) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        EntityTreeInflater<C> inflater = entityTreeQuery.getInflater();
        Query query = entityTreeQuery.getQuery();
        HashMap selectParameterBinders = new HashMap();
        query.getColumns().forEach(selectable -> {
            ResultSetReader reader;
            String alias = (String)Objects.preventNull(query.getAliases().get(selectable), (Object)selectable.getExpression());
            if (selectable instanceof Column) {
                reader = this.dialect.getColumnBinderRegistry().getReader((Object)((Column)selectable));
                selectParameterBinders.put(alias, reader);
            } else {
                reader = this.dialect.getColumnBinderRegistry().getReader(selectable.getJavaType());
            }
            selectParameterBinders.put(alias, reader);
        });
        StringParamedSQL statement = new StringParamedSQL(sql, parameterBinders);
        statement.setValues(values);
        return new InternalExecutor(inflater, selectParameterBinders).execute((SQLStatement<?>)statement);
    }

    @Override
    public Set<C> select(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer, Map<String, Object> valuesPerParam) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where.getCriteria(), entityTreeQuery.getColumnClones());
        ColumnCloneAwareOrderBy cloneAwareOrderBy = new ColumnCloneAwareOrderBy(query.orderBy(), entityTreeQuery.getColumnClones());
        if (where.hasCollectionCriteria()) {
            KeepOrderMap columns = query.getSelectDelegate().clear();
            Column pk = (Column)Iterables.first((Iterable)((Table)this.entityJoinTree.getRoot().getTable()).getPrimaryKey().getColumns());
            query.select((Selectable)pk, PRIMARY_KEY_ALIAS);
            Maps.ChainingMap columnReaders = Maps.asMap((Object)PRIMARY_KEY_ALIAS, (Object)this.dialect.getColumnBinderRegistry().getBinder((Object)pk));
            Maps.ChainingMap aliases = Maps.asMap((Object)pk, (Object)PRIMARY_KEY_ALIAS);
            ColumnedRow columnedRow = new ColumnedRow(((Map)aliases)::get);
            orderByClauseConsumer.accept(cloneAwareOrderBy);
            limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
            Set<I> ids = this.readIds(sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap()), (Map<String, ResultSetReader>)columnReaders, columnedRow);
            if (ids.isEmpty()) {
                return Collections.emptySet();
            }
            query.getSelectDelegate().remove((Selectable)pk);
            columns.forEach((arg_0, arg_1) -> ((Query)query).select(arg_0, arg_1));
            query.getWhereDelegate().clear();
            query.where(pk, (ConditionalOperator)Operators.in(ids));
            PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(valuesPerParam);
            return new InternalExecutor(entityTreeQuery).execute((SQLStatement<?>)preparedSQL);
        }
        orderByClauseConsumer.accept(cloneAwareOrderBy);
        limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(valuesPerParam);
        return new InternalExecutor(entityTreeQuery).execute((SQLStatement<?>)preparedSQL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<I> readIds(PreparedSQL preparedSQL, Map<String, ResultSetReader> columnReaders, ColumnedRow columnedRow) {
        EntityInflater<C, I> entityInflater = this.entityJoinTree.getRoot().getEntityInflater();
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            Set set = (Set)Iterables.collect(() -> rowIterator, row -> entityInflater.giveIdentifier((Row)row, columnedRow), HashSet::new);
            return set;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, CriteriaChain where, boolean distinct, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        query.getSelectDelegate().setDistinct(distinct);
        orderByClauseConsumer.accept((OrderByChain<?>)query.getQuery().orderBy());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, (Iterable)where, entityTreeQuery.getColumnClones());
        selectAdapter.accept(query.getSelectDelegate());
        Map aliases = query.getAliases();
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        Map columnReaders = Iterables.map((Iterable)query.getColumns(), new AliasAsserter(aliases::get), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        return this.readProjection(preparedSQL, columnReaders, columnedRow, accumulator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, O> R readProjection(PreparedSQL preparedSQL, Map<String, ResultSetReader<?>> columnReaders, ColumnedRow columnedRow, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator) {
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            Object object = accumulator.collect((Iterable)Iterables.stream((Iterator)rowIterator).map(row -> selectable -> columnedRow.getValue(selectable, row)).collect(Collectors.toList()));
            return (R)object;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private static class AliasAsserter<S extends Selectable>
    implements Function<S, String> {
        private final Function<S, String> delegate;

        private AliasAsserter(Function<S, String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String apply(S selectable) {
            String alias = this.delegate.apply(selectable);
            if (alias == null) {
                throw new IllegalArgumentException("Item " + selectable.getExpression() + " must have an alias");
            }
            return alias;
        }
    }

    private class InternalExecutor {
        private final EntityTreeInflater<C> inflater;
        private final Map<String, ResultSetReader<?>> selectParameterBinders;

        private InternalExecutor(EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery) {
            this(entityTreeQuery.getInflater(), entityTreeQuery.getSelectParameterBinders());
        }

        private InternalExecutor(EntityTreeInflater<C> inflater, Map<String, ? extends ResultSetReader<?>> selectParameterBinders) {
            this.inflater = inflater;
            this.selectParameterBinders = selectParameterBinders;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Set<C> execute(SQLStatement<?> query) {
            try (ReadOperation readOperation = new ReadOperation(query, EntityGraphSelector.this.connectionProvider);){
                Set set = this.transform(readOperation);
                return set;
            }
            catch (RuntimeException e) {
                throw new SQLExecutionException(query.getSQL(), (Throwable)e);
            }
        }

        protected Set<C> transform(ReadOperation<?> closeableOperation) {
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, this.selectParameterBinders);
            return this.transform((Iterator<Row>)rowIterator);
        }

        protected Set<C> transform(Iterator<Row> rowIterator) {
            return this.inflater.transform(() -> rowIterator, 50);
        }
    }
}

