/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Delete;
import org.codefilarete.stalactite.sql.order.DeleteCommandBuilder;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DeleteCommandBuilderTest {
    DeleteCommandBuilderTest() {
    }

    @Test
    <T extends Table<T>> void appendTo_singleTable() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Delete delete = new Delete(totoTable);
        delete.where(columnA, (ConditionalOperator)Operators.eq((Object)44)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnB));
        DeleteCommandBuilder testInstance = new DeleteCommandBuilder(delete, (Dialect)new DefaultDialect());
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("delete from Toto where a = 44 or a = b");
        delete = new Delete(totoTable);
        testInstance = new DeleteCommandBuilder(delete, (Dialect)new DefaultDialect());
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("delete from Toto");
    }

    @Test
    <T1 extends Table<T1>, T2 extends Table<T2>> void appendTo_multiTable() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Table tataTable = new Table("Tata");
        Column columnX = tataTable.addColumn("x", Long.class);
        Column columnY = tataTable.addColumn("y", String.class);
        Delete delete = new Delete(totoTable);
        delete.where(columnA, (ConditionalOperator)Operators.eq((Object)columnX)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnY));
        DeleteCommandBuilder testInstance = new DeleteCommandBuilder(delete, (Dialect)new DefaultDialect());
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("delete from Toto, Tata where Toto.a = Tata.x or Toto.a = Tata.y");
        delete = new Delete(totoTable);
        delete.where(columnA, (ConditionalOperator)Operators.eq((Object)columnX)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnY));
        testInstance = new DeleteCommandBuilder(delete, (Dialect)new DefaultDialect());
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("delete from Toto, Tata where Toto.a = Tata.x or Toto.a = Tata.y");
    }

    @Test
    <T extends Table<T>> void toPreparableSQL() throws SQLException {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Delete delete = new Delete(totoTable);
        delete.where(columnA, (ConditionalOperator)Operators.in((Object[])new Long[]{42L, 43L})).or(columnA, (ConditionalOperator)Operators.eq((Object)columnB));
        DefaultDialect dialect = new DefaultDialect();
        DeleteCommandBuilder testInstance = new DeleteCommandBuilder(delete, (Dialect)dialect);
        PreparedSQL result = testInstance.toPreparableSQL().toPreparedSQL(new HashMap());
        Assertions.assertThat((String)result.getSQL()).isEqualTo("delete from Toto where a in (?, ?) or a = b");
        Assertions.assertThat((Map)result.getValues()).isEqualTo((Object)Maps.asMap((Object)1, (Object)42L).add((Object)2, (Object)43L));
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        PreparedStatement mock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(1, 42L);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(2, 43L);
        dialect.getColumnBinderRegistry().register(columnA, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        result = testInstance.toPreparableSQL().toPreparedSQL(new HashMap());
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)2))).setLong(1, 42L);
        ((PreparedStatement)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)2))).setLong(2, 43L);
    }
}

