/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.cascade;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.codefilarete.stalactite.engine.cascade.AfterUpdateSupport;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AfterUpdateSupportTest {
    AfterUpdateSupportTest() {
    }

    @Test
    void constructorArgsAreInvoked() {
        BiConsumer actionMock = (BiConsumer)Mockito.mock(BiConsumer.class);
        Function targetProviderMock = (Function)Mockito.mock(Function.class);
        Mockito.when(targetProviderMock.apply(ArgumentMatchers.any())).thenAnswer(invocation -> ((String)invocation.getArgument(0)).toUpperCase());
        Predicate targetFilterMock = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)targetFilterMock.test(ArgumentMatchers.any())).thenAnswer(invocation -> !new Duo((Object)"B BIS", (Object)"B").equals(invocation.getArgument(0)));
        AfterUpdateSupport testInstance = new AfterUpdateSupport(actionMock, targetProviderMock, targetFilterMock);
        testInstance.afterUpdate((Iterable)Arrays.asList((Object[])new Duo[]{new Duo((Object)"a bis", (Object)"a"), new Duo((Object)"b bis", (Object)"b"), new Duo((Object)"c bis", (Object)"c")}), true);
        ((BiConsumer)Mockito.verify((Object)actionMock)).accept(ArgumentMatchers.eq((Object)Arrays.asList((Object[])new Duo[]{new Duo((Object)"A BIS", (Object)"A"), new Duo((Object)"C BIS", (Object)"C")})), ArgumentMatchers.eq((boolean)true));
        ((Function)Mockito.verify((Object)targetProviderMock, (VerificationMode)Mockito.times((int)6))).apply(ArgumentMatchers.any());
        ((Predicate)Mockito.verify((Object)targetFilterMock, (VerificationMode)Mockito.times((int)3))).test(ArgumentMatchers.any());
    }

    @Test
    void constructorWithDefaultFilter_acceptAll() {
        BiConsumer actionMock = (BiConsumer)Mockito.mock(BiConsumer.class);
        Function targetProviderMock = (Function)Mockito.mock(Function.class);
        Mockito.when(targetProviderMock.apply(ArgumentMatchers.any())).thenAnswer(invocation -> ((String)invocation.getArgument(0)).toUpperCase());
        AfterUpdateSupport testInstance = new AfterUpdateSupport(actionMock, targetProviderMock);
        testInstance.afterUpdate((Iterable)Arrays.asList((Object[])new Duo[]{new Duo((Object)"a bis", (Object)"a"), new Duo((Object)"b bis", (Object)"b"), new Duo((Object)"c bis", (Object)"c")}), true);
        ((BiConsumer)Mockito.verify((Object)actionMock)).accept(ArgumentMatchers.eq((Object)Arrays.asList((Object[])new Duo[]{new Duo((Object)"A BIS", (Object)"A"), new Duo((Object)"B BIS", (Object)"B"), new Duo((Object)"C BIS", (Object)"C")})), ArgumentMatchers.eq((boolean)true));
        ((Function)Mockito.verify((Object)targetProviderMock, (VerificationMode)Mockito.times((int)6))).apply(ArgumentMatchers.any());
    }
}

