/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.PreparedSQLAppender;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.builder.WhereSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.UnitaryOperator;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.MultiTableAwareDMLNameProvider;
import org.codefilarete.stalactite.sql.order.Update;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.trace.MutableInt;

public class UpdateCommandBuilder<T extends Table<T>>
implements SQLBuilder {
    private final Update<T> update;
    private final Dialect dialect;
    private final MultiTableAwareDMLNameProvider dmlNameProvider;

    public UpdateCommandBuilder(Update<T> update, Dialect dialect) {
        this.update = update;
        this.dialect = dialect;
        this.dmlNameProvider = new MultiTableAwareDMLNameProvider(dialect.getDmlNameProviderFactory());
    }

    @Override
    public String toSQL() {
        return this.toSQL(new StringSQLAppender(this.dmlNameProvider){

            @Override
            public <V> StringSQLAppender catValue(@Nullable Selectable<V> column, Object value) {
                if (value == Update.UpdateColumn.PLACEHOLDER) {
                    return this.cat("?", new String[0]);
                }
                return super.catValue((Selectable)column, value);
            }

            @Override
            public StringSQLAppender catValue(Object value) {
                if (value == Update.UpdateColumn.PLACEHOLDER) {
                    return this.cat("?", new String[0]);
                }
                return super.catValue(value);
            }
        }, this.dmlNameProvider);
    }

    private String toSQL(SQLAppender result, MultiTableAwareDMLNameProvider dmlNameProvider) {
        result.cat("update ", new String[0]);
        LinkedHashSet whereColumns = new LinkedHashSet();
        this.update.getCriteria().forEach(c -> {
            if (c instanceof ColumnCriterion && ((ColumnCriterion)c).getColumn() instanceof Column) {
                whereColumns.add((Column)((ColumnCriterion)c).getColumn());
                Object condition = ((ColumnCriterion)c).getCondition();
                if (condition instanceof UnitaryOperator && ((UnitaryOperator)condition).getValue() instanceof ValuedVariable && ((ValuedVariable)((UnitaryOperator)condition).getValue()).getValue() instanceof Column) {
                    whereColumns.add((Column)((ValuedVariable)((UnitaryOperator)condition).getValue()).getValue());
                }
            }
        });
        Set additionalTables = Iterables.minus((Collection)Iterables.collect(whereColumns, Column::getTable, HashSet::new), (Collection)Arrays.asList((Object[])new Table[]{this.update.getTargetTable()}));
        dmlNameProvider.setMultiTable(!additionalTables.isEmpty());
        result.cat(dmlNameProvider.getName((Fromable)this.update.getTargetTable()), new String[0]).catIf(dmlNameProvider.isMultiTable(), ", ");
        Iterator iterator = additionalTables.iterator();
        while (iterator.hasNext()) {
            Table next = (Table)iterator.next();
            result.cat(dmlNameProvider.getName(next), new String[0]).catIf(iterator.hasNext(), ", ");
        }
        result.cat(" set ", new String[0]);
        Iterator<Update.UpdateColumn<T>> columnIterator = this.update.getColumns().iterator();
        while (columnIterator.hasNext()) {
            Update.UpdateColumn<T> c2 = columnIterator.next();
            result.cat(dmlNameProvider.getName(c2.getColumn()), " = ");
            this.catUpdateObject(c2, result, dmlNameProvider);
            result.catIf(columnIterator.hasNext(), ", ");
        }
        if (!this.update.getCriteria().getConditions().isEmpty()) {
            result.cat(" where ", new String[0]);
            WhereSQLBuilderFactory.WhereSQLBuilder whereSqlBuilder = this.dialect.getQuerySQLBuilderFactory().getWhereBuilderFactory().whereBuilder(this.update.getCriteria(), dmlNameProvider);
            whereSqlBuilder.appendTo(result);
        }
        return result.getSQL();
    }

    protected void catUpdateObject(Update.UpdateColumn<T> updateColumn, SQLAppender result, MultiTableAwareDMLNameProvider dmlNameProvider) {
        Object value = updateColumn.getValue();
        if (value instanceof Column) {
            result.cat(dmlNameProvider.getName((Column)value), new String[0]);
        } else {
            result.catValue(updateColumn.getColumn(), value);
        }
    }

    public UpdateStatement<T> toStatement() {
        PreparedSQLAppender preparedSQLAppender = new PreparedSQLAppender(new StringSQLAppender(this.dmlNameProvider), this.dialect.getColumnBinderRegistry());
        String sql = this.toSQL(preparedSQLAppender, this.dmlNameProvider);
        HashMap<Integer, Object> values = new HashMap<Integer, Object>(preparedSQLAppender.getValues());
        HashMap parameterBinders = new HashMap(preparedSQLAppender.getParameterBinders());
        HashMap columnIndexes = new HashMap();
        MutableInt placeholderColumnCount = new MutableInt();
        this.update.getColumns().forEach(c -> {
            if (!(c.getValue() instanceof Column)) {
                int index = placeholderColumnCount.increment();
                if (values.get(index).equals(Update.UpdateColumn.PLACEHOLDER)) {
                    values.remove(index);
                }
                columnIndexes.put(c.getColumn(), index);
            }
        });
        UpdateStatement result = new UpdateStatement(sql, parameterBinders, columnIndexes);
        result.setValues(values);
        return result;
    }

    public static class UpdateStatement<T extends Table<T>>
    extends PreparedSQL {
        private final Map<Column<T, Object>, Integer> columnIndexes;

        private UpdateStatement(String sql, Map<Integer, ? extends ParameterBinder<?>> parameterBinders, Map<? extends Column<T, ?>, Integer> columnIndexes) {
            super(sql, parameterBinders);
            this.columnIndexes = columnIndexes;
        }

        public <C> void setValue(Column<T, C> column, C value) {
            Integer index = this.columnIndexes.get(column);
            if (index == null) {
                throw new IllegalArgumentException("Column " + column.getAbsoluteName() + " is not declared updatable with fixed value in the update clause");
            }
            this.setValue(index, value);
        }
    }
}

