/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.stream.LongStream;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.SQLOperationsFactories;
import org.codefilarete.stalactite.engine.SQLOperationsFactoriesBuilder;
import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSelector;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DatabaseSequenceSelectorFactory;
import org.codefilarete.stalactite.sql.DerbyDialectResolver;
import org.codefilarete.stalactite.sql.DerbyGeneratedKeysReader;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.DerbyDDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.DerbyReadOperation;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.DerbyParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.DerbyTypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.CaseInsensitiveSet;
import org.codefilarete.tool.collection.Sorter;
import org.codefilarete.tool.function.ThrowingBiFunction;

public class DerbyDatabaseSettings
extends DatabaseVendorSettings {
    @VisibleForTesting
    static final String[] KEYWORDS = new String[]{"ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BIT", "BOOLEAN", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GETCURRENTCONNECTION", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEADING", "LEFT", "LIKE", "LOWER", "LTRIM", "MATCH", "MAX", "MIN", "MINUTE", "NATIONAL", "NATURAL", "NCHAR", "NVARCHAR", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "RTRIM", "SCHEMA", "SCROLL", "SECOND", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTR", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USER", "USING", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHENEVER", "WHERE", "WINDOW", "WITH", "WORK", "WRITE", "XML", "XMLEXISTS", "XMLPARSE", "XMLQUERY", "XMLSERIALIZE", "YEAR"};
    public static final DerbyDatabaseSettings DERBY_10_14 = new DerbyDatabaseSettings();

    private DerbyDatabaseSettings() {
        this(new DerbySQLOperationsFactoriesBuilder(), new DerbyParameterBinderRegistry());
    }

    private DerbyDatabaseSettings(DerbySQLOperationsFactoriesBuilder sqlOperationsFactoriesBuilder, DerbyParameterBinderRegistry parameterBinderRegistry) {
        super((ServiceLoaderDialectResolver.DatabaseSignet)new DerbyDialectResolver.DerbyDatabaseSignet(10, 14), Collections.unmodifiableSet(new CaseInsensitiveSet(KEYWORDS)), '\"', (JavaTypeToSqlTypeMapping)new DerbyTypeMapping(), (ParameterBinderRegistry)parameterBinderRegistry, (SQLOperationsFactoriesBuilder)sqlOperationsFactoriesBuilder, (GeneratedKeysReaderFactory)new DerbyGeneratedKeysReaderFactory(), 1000, true);
    }

    @VisibleForTesting
    static class DerbyGeneratedKeysReaderFactory
    implements GeneratedKeysReaderFactory {
        DerbyGeneratedKeysReaderFactory() {
        }

        public <I> GeneratedKeysReader<I> build(String keyName, Class<I> columnType) {
            return new DerbyGeneratedKeysReader();
        }
    }

    private static class DerbySequenceSelectorFactory
    implements DatabaseSequenceSelectorFactory {
        private final ReadOperationFactory readOperationFactory;

        private DerbySequenceSelectorFactory(ReadOperationFactory readOperationFactory) {
            this.readOperationFactory = readOperationFactory;
        }

        public DatabaseSequenceSelector create(Sequence databaseSequence, ConnectionProvider connectionProvider) {
            return new DatabaseSequenceSelector(databaseSequence, "values next value for " + databaseSequence.getAbsoluteName(), this.readOperationFactory, connectionProvider);
        }
    }

    static class DerbyWriteOperation<ParamType>
    extends WriteOperation<ParamType> {
        private long updatedRowCount = 0L;

        public DerbyWriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener) {
            super(sqlGenerator, connectionProvider, rowCountListener);
        }

        public long getUpdatedRowCount() {
            return this.updatedRowCount;
        }

        protected long[] doExecuteBatch() throws SQLException {
            long[] rowCounts = super.doExecuteBatch();
            this.updatedRowCount = LongStream.of(rowCounts).sum();
            return rowCounts;
        }

        public void cancel() throws SQLException {
            EmbedConnection conn = this.preparedStatement.getConnection().unwrap(EmbedConnection.class);
            conn.cancelRunningStatement();
        }
    }

    public static class DerbyWriteOperationFactory
    extends WriteOperationFactory {
        protected <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, WriteOperation.RowCountListener rowCountListener) {
            return new DerbyWriteOperation<ParamType>(sqlGenerator, connectionProvider, rowCountListener){

                protected void prepareStatement(Connection connection) throws SQLException {
                    this.preparedStatement = (PreparedStatement)statementProvider.apply((Object)connection, (Object)this.getSQL());
                }
            };
        }
    }

    public static class DerbyReadOperationFactory
    extends ReadOperationFactory {
        public <ParamType> ReadOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider) {
            return new DerbyReadOperation(sqlGenerator, connectionProvider);
        }
    }

    private static class DerbySQLOperationsFactoriesBuilder
    implements SQLOperationsFactoriesBuilder {
        private final ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        private final DerbyWriteOperationFactory writeOperationFactory = new DerbyWriteOperationFactory();

        private DerbySQLOperationsFactoriesBuilder() {
        }

        private ReadOperationFactory getReadOperationFactory() {
            return this.readOperationFactory;
        }

        private DerbyWriteOperationFactory getWriteOperationFactory() {
            return this.writeOperationFactory;
        }

        public SQLOperationsFactories build(ParameterBinderIndex<Column, ParameterBinder> parameterBinders, DMLNameProviderFactory dmlNameProviderFactory, SqlTypeRegistry sqlTypeRegistry) {
            DMLGenerator dmlGenerator = new DMLGenerator(parameterBinders, (Sorter)DMLGenerator.NoopSorter.INSTANCE, dmlNameProviderFactory);
            DerbyDDLTableGenerator ddlTableGenerator = new DerbyDDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
            DDLSequenceGenerator ddlSequenceGenerator = new DDLSequenceGenerator(dmlNameProviderFactory);
            return new SQLOperationsFactories((WriteOperationFactory)this.writeOperationFactory, this.readOperationFactory, dmlGenerator, (DDLTableGenerator)ddlTableGenerator, ddlSequenceGenerator, (DatabaseSequenceSelectorFactory)new DerbySequenceSelectorFactory(this.readOperationFactory));
        }
    }
}

