/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.runtime.BeanPersister;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.CompositeKeyAlreadyAssignedIdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSelect;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Iterables;

public class CompositeKeyedBeanPersister<C, I, T extends Table<T>>
extends BeanPersister<C, I, T> {
    private final SelectCompositeKeyExecutor<I, T> selectCompositeKeyExecutor;
    protected SQLOperation.SQLOperationListener<Column<T, ?>> operationListener;
    private final CompositeKeyAlreadyAssignedIdentifierInsertionManager<C, I> compositeKeyInsertionManager;

    public CompositeKeyedBeanPersister(EntityMapping<C, I, T> mappingStrategy, CompositeKeyAlreadyAssignedIdentifierInsertionManager<C, I> compositeKeyInsertionManager, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        super(mappingStrategy, dialect, connectionConfiguration);
        IdentifierAssembler identifierAssembler = mappingStrategy.getIdMapping().getIdentifierAssembler();
        this.selectCompositeKeyExecutor = new SelectCompositeKeyExecutor(identifierAssembler);
        this.compositeKeyInsertionManager = compositeKeyInsertionManager;
        this.addPersistListener(this.compositeKeyInsertionManager.getPersistListener());
    }

    @Override
    protected void doPersist(Iterable<? extends C> entities) {
        Set<? extends C> newEntities = this.excludePersistedEntities(entities);
        PersistExecutor.persist(entities, newEntities::contains, this, this, this, this.getMapping()::getId);
    }

    private Set<? extends C> excludePersistedEntities(Iterable<? extends C> entities) {
        Map entitiesPerId = Iterables.map(entities, this.getMapping()::getId);
        List existingEntities = this.selectIds(entitiesPerId.keySet());
        entitiesPerId.keySet().removeIf(existingEntities::contains);
        return new HashSet(entitiesPerId.values());
    }

    @Override
    public boolean isNew(C c) {
        return this.compositeKeyInsertionManager.getIsPersistedFunction().apply(c) == false;
    }

    private List<I> selectIds(Iterable<I> ids) {
        int blockSize = this.getInOperatorMaxSize();
        List parcels = org.codefilarete.tool.collection.Collections.parcel(ids, (int)blockSize);
        ArrayList<I> result = new ArrayList<I>(50);
        if (!parcels.isEmpty()) {
            Throwable throwable;
            List lastParcel = (List)Iterables.last((List)parcels, Collections.emptyList());
            int lastBlockSize = lastParcel.size();
            if (lastBlockSize != blockSize) {
                parcels = Iterables.cutTail((List)parcels);
            } else {
                lastParcel = Collections.emptyList();
            }
            SimpleConnectionProvider localConnectionProvider = new SimpleConnectionProvider(this.getConnectionProvider().giveConnection());
            Object targetTable = this.getMapping().getTargetTable();
            Set columnsToRead = this.getMapping().getSelectableColumns();
            if (!parcels.isEmpty()) {
                throwable = null;
                try (ReadOperation defaultReadOperation = this.newReadOperation(targetTable, columnsToRead, blockSize, (ConnectionProvider)localConnectionProvider);){
                    parcels.forEach(parcel -> result.addAll(this.selectCompositeKeyExecutor.execute(defaultReadOperation, (List<I>)parcel)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            if (!lastParcel.isEmpty()) {
                throwable = null;
                try (ReadOperation lastReadOperation = this.newReadOperation(targetTable, columnsToRead, lastBlockSize, (ConnectionProvider)localConnectionProvider);){
                    result.addAll(this.selectCompositeKeyExecutor.execute(lastReadOperation, lastParcel));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
        return result;
    }

    private ReadOperation<Column<T, ?>> newReadOperation(T targetTable, Set<Column<T, ?>> columnsToRead, int blockSize, ConnectionProvider connectionProvider) {
        PrimaryKey primaryKey = ((Table)targetTable).getPrimaryKey();
        ColumnParameterizedSelect<T> selectStatement = this.getDmlGenerator().buildSelectByKey(targetTable, columnsToRead, primaryKey.getColumns(), blockSize);
        ReadOperation readOperation = new ReadOperation(selectStatement, connectionProvider);
        readOperation.setListener(this.operationListener);
        return readOperation;
    }

    @VisibleForTesting
    static class SelectCompositeKeyExecutor<I, T extends Table<T>> {
        private final IdentifierAssembler<I, T> primaryKeyProvider;
        private final Function<Row, I> transformer;

        SelectCompositeKeyExecutor(IdentifierAssembler<I, T> primaryKeyProvider) {
            this.primaryKeyProvider = primaryKeyProvider;
            ColumnedRow rowAliaser = new ColumnedRow();
            this.transformer = row -> primaryKeyProvider.assemble((Row)row, rowAliaser);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @VisibleForTesting
        List<I> execute(ReadOperation<Column<T, ?>> operation, List<I> ids) {
            Map<Column<T, ?>, Object> primaryKeyValues = this.primaryKeyProvider.getColumnValues(ids);
            try (ReadOperation<Column<T, ?>> closeableOperation = operation;){
                closeableOperation.setValues(primaryKeyValues);
                List<I> list = this.transform(closeableOperation, primaryKeyValues.size());
                return list;
            }
            catch (RuntimeException e) {
                throw new SQLExecutionException(operation.getSqlStatement().getSQL(), (Throwable)e);
            }
        }

        protected List<I> transform(ReadOperation<Column<T, ?>> closeableOperation, int size) {
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, ((ColumnParameterizedSelect)closeableOperation.getSqlStatement()).getSelectParameterBinders());
            return this.transform((Iterator<Row>)rowIterator, size);
        }

        protected List<I> transform(Iterator<Row> rowIterator, int resultSize) {
            return (List)Iterables.collect(() -> rowIterator, this.transformer, () -> new ArrayList(resultSize));
        }
    }
}

