/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.ClosedConnectionRetryerProvider;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class ClosedConnectionRetryerProviderTest {
    ClosedConnectionRetryerProviderTest() {
    }

    @Test
    void giveConnection_previousConnectionIsClosed_giveANewOne() throws SQLException {
        DataSource dataSourceMock = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)dataSourceMock.getConnection()).thenAnswer((Answer)new CloseableConnection(4));
        ClosedConnectionRetryerProvider testInstance = new ClosedConnectionRetryerProvider((ConnectionProvider)new ConnectionProvider.DataSourceConnectionProvider(dataSourceMock), 20);
        Connection givenConnection = testInstance.giveConnection();
        Assertions.assertThat((boolean)givenConnection.isClosed()).isFalse();
        ((DataSource)Mockito.verify((Object)dataSourceMock, (VerificationMode)Mockito.times((int)5))).getConnection();
    }

    private static class CloseableConnection
    implements Answer<Connection> {
        private final int closedConnectionsCount;
        private int currentClosedConnectionsCount;

        private CloseableConnection(int closedConnectionsCount) {
            this.closedConnectionsCount = closedConnectionsCount;
        }

        public Connection answer(InvocationOnMock invocation) throws Throwable {
            Connection connectionMock = (Connection)Mockito.mock(Connection.class);
            if (this.currentClosedConnectionsCount < this.closedConnectionsCount) {
                Mockito.when((Object)connectionMock.isClosed()).thenReturn((Object)true);
                ++this.currentClosedConnectionsCount;
            }
            return connectionMock;
        }
    }
}

