/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.runtime.AbstractDMLExecutorMockTest;
import org.codefilarete.stalactite.engine.runtime.DMLExecutorTest;
import org.codefilarete.stalactite.engine.runtime.ExtendedMapAssert;
import org.codefilarete.stalactite.engine.runtime.SelectExecutor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSelect;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.stalactite.test.PairSetList;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.Sorter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SelectExecutorTest<T extends Table<T>>
extends AbstractDMLExecutorMockTest {
    private final Dialect dialect = new DefaultDialect(new JavaTypeToSqlTypeMapping().with(Integer.class, "int"));
    private SelectExecutor<DMLExecutorTest.Toto, Integer, T> testInstance;

    SelectExecutorTest() {
    }

    @BeforeEach
    public void setUp() throws SQLException {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = SelectExecutorTest.giveDefaultPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        this.testInstance = new SelectExecutor(persistenceConfiguration.classMappingStrategy, this.jdbcMock.transactionManager, dmlGenerator, 3);
    }

    @Test
    void select_one() throws SQLException {
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        this.testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{7}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement)).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement)).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((String)((String)this.jdbcMock.sqlCaptor.getValue())).isEqualTo("select a, b, c from Toto where a in (?)");
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 7);
        SelectExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void listenerIsCalled() throws SQLException {
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        SQLOperation.SQLOperationListener listenerMock = (SQLOperation.SQLOperationListener)Mockito.mock(SQLOperation.SQLOperationListener.class);
        this.testInstance.setOperationListener(listenerMock);
        ArgumentCaptor statementArgCaptor = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor sqlArgCaptor = ArgumentCaptor.forClass(SQLStatement.class);
        this.testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{1, 2}));
        Table mappedTable = new Table("Toto");
        Column colA = mappedTable.addColumn("a", Integer.class);
        Column colB = mappedTable.addColumn("b", Integer.class);
        Column colC = mappedTable.addColumn("c", Integer.class);
        ((SQLOperation.SQLOperationListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.times((int)1))).onValuesSet((Map)statementArgCaptor.capture());
        ExtendedMapAssert.assertThatMap((Map)statementArgCaptor.getAllValues().get(0)).usingElementPredicate((entry1, entry2) -> ((Column)entry1.getKey()).getAbsoluteName().equals(((Column)entry2.getKey()).getAbsoluteName()) && ((List)entry1.getValue()).equals(entry2.getValue())).containsExactlyInAnyOrder(new Map.Entry[]{Assertions.entry((Object)colA, (Object)Arrays.asList((Object[])new Integer[]{1, 2}))});
        ((SQLOperation.SQLOperationListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.times((int)1))).onExecute((SQLStatement)sqlArgCaptor.capture());
        Assertions.assertThat((String)((SQLStatement)sqlArgCaptor.getValue()).getSQL()).isEqualTo("select a, b, c from Toto where a in (?, ?)");
    }

    @Test
    void select_multiple_lastBlockContainsOneValue() throws SQLException {
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        this.testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{11, 13, 17, 23}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select a, b, c from Toto where a in (?, ?, ?)", "select a, b, c from Toto where a in (?)"}));
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 11).add(2, 13).add(3, 17).newRow(1, 23);
        SelectExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void select_multiple_lastBlockContainsMultipleValue() throws SQLException {
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        this.testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{11, 13, 17, 23, 29}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)5))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select a, b, c from Toto where a in (?, ?, ?)", "select a, b, c from Toto where a in (?, ?)"}));
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 11).add(2, 13).add(3, 17).newRow(1, 23).add(2, 29);
        SelectExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void select_multiple_lastBlockSizeIsInOperatorSize() throws SQLException {
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        this.testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{11, 13, 17, 23, 29, 31}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)6))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select a, b, c from Toto where a in (?, ?, ?)"}));
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 11).add(2, 13).add(3, 17).newRow(1, 23).add(2, 29).add(3, 31);
        SelectExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void select_multiple_argumentWithOneBlock() throws SQLException {
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        this.testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{11, 13}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select a, b, c from Toto where a in (?, ?)"}));
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 11).add(2, 13);
        SelectExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void select_multiple_emptyArgument() throws SQLException {
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        Set result = this.testInstance.select((Iterable)Arrays.asList((Object[])new Integer[0]));
        Assertions.assertThat((boolean)result.isEmpty()).isTrue();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)0))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((boolean)this.jdbcMock.sqlCaptor.getAllValues().isEmpty()).isTrue();
    }

    @Test
    void select_multiple_composedId_lastBlockContainsOneValue() throws SQLException {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = SelectExecutorTest.giveIdAsItselfPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        SelectExecutor testInstance = new SelectExecutor(persistenceConfiguration.classMappingStrategy, this.jdbcMock.transactionManager, dmlGenerator, 3);
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        testInstance.select((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 11, 111), new DMLExecutorTest.Toto(2, 13, 222), new DMLExecutorTest.Toto(3, 17, 333), new DMLExecutorTest.Toto(4, 23, 444)}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)8))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select a, b, c from Toto where (a, b) in ((?, ?), (?, ?), (?, ?))", "select a, b, c from Toto where (a, b) in ((?, ?))"}));
        PairSetList<Integer, Integer> expectedPairs = new PairSetList<Integer, Integer>().add(1, 1).add(2, 11).add(3, 2).add(4, 13).add(5, 3).add(6, 17).newRow(1, 4).add(2, 23);
        SelectExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void select_multiple_composedId_lastBlockContainsMultipleValue() throws SQLException {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = SelectExecutorTest.giveIdAsItselfPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        SelectExecutor testInstance = new SelectExecutor(persistenceConfiguration.classMappingStrategy, this.jdbcMock.transactionManager, dmlGenerator, 3);
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        testInstance.select((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 11, 111), new DMLExecutorTest.Toto(2, 13, 222), new DMLExecutorTest.Toto(3, 17, 333), new DMLExecutorTest.Toto(4, 23, 444), new DMLExecutorTest.Toto(5, 29, 555)}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)10))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select a, b, c from Toto where (a, b) in ((?, ?), (?, ?), (?, ?))", "select a, b, c from Toto where (a, b) in ((?, ?), (?, ?))"}));
        PairSetList<Integer, Integer> expectedPairs = new PairSetList<Integer, Integer>().add(1, 1).add(2, 11).add(3, 2).add(4, 13).add(5, 3).add(6, 17).newRow(1, 4).add(2, 23).add(3, 5).add(4, 29);
        SelectExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void select_multiple_composedId_lastBlockSizeIsInOperatorSize() throws SQLException {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = SelectExecutorTest.giveIdAsItselfPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        SelectExecutor testInstance = new SelectExecutor(persistenceConfiguration.classMappingStrategy, this.jdbcMock.transactionManager, dmlGenerator, 3);
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.jdbcMock.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        testInstance.select((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 11, 111), new DMLExecutorTest.Toto(2, 13, 222), new DMLExecutorTest.Toto(3, 17, 333), new DMLExecutorTest.Toto(4, 23, 444), new DMLExecutorTest.Toto(5, 29, 555), new DMLExecutorTest.Toto(6, 31, 666)}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)12))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select a, b, c from Toto where (a, b) in ((?, ?), (?, ?), (?, ?))"}));
        PairSetList<Integer, Integer> expectedPairs = new PairSetList<Integer, Integer>().add(1, 1).add(2, 11).add(3, 2).add(4, 13).add(5, 3).add(6, 17).newRow(1, 4).add(2, 23).add(3, 5).add(4, 29).add(5, 6).add(6, 31);
        SelectExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void internalExecutor_execute() {
        Table targetTable = new Table("Toto");
        Column id = targetTable.addColumn("id", Long.TYPE).primaryKey();
        ClassMapping mappingStrategyMock = (ClassMapping)Mockito.mock(ClassMapping.class);
        Mockito.when((Object)mappingStrategyMock.getTargetTable()).thenReturn((Object)targetTable);
        Mockito.when((Object)mappingStrategyMock.getSelectableColumns()).thenAnswer(invocation -> targetTable.getColumns());
        IdMapping idMappingMock = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)mappingStrategyMock.getIdMapping()).thenReturn((Object)idMappingMock);
        IdentifierAssembler identifierAssemblerMock = (IdentifierAssembler)Mockito.mock(IdentifierAssembler.class);
        Mockito.when((Object)idMappingMock.getIdentifierAssembler()).thenReturn((Object)identifierAssemblerMock);
        Maps.ChainingMap idValuesPerEntity = Maps.asMap((Object)id, (Object)Arrays.asList((Object[])new Integer[]{10, 20}));
        Mockito.when((Object)identifierAssemblerMock.getColumnValues(ArgumentMatchers.anyList())).thenReturn((Object)idValuesPerEntity);
        ReadOperation readOperationMock = (ReadOperation)Mockito.mock(ReadOperation.class);
        Mockito.when((Object)readOperationMock.execute()).thenReturn((Object)new InMemoryResultSet(Collections.emptyList()));
        Mockito.when((Object)readOperationMock.getSqlStatement()).thenReturn((Object)new ColumnParameterizedSelect("", new HashMap(), new HashMap(), new HashMap()));
        ArgumentCaptor capturedValues = ArgumentCaptor.forClass(Map.class);
        SelectExecutor.InternalExecutor testInstance = new SelectExecutor.InternalExecutor((EntityMapping)mappingStrategyMock);
        testInstance.execute(readOperationMock, Arrays.asList((Object[])new Integer[]{1, 2}));
        ((ReadOperation)Mockito.verify((Object)readOperationMock)).setValues((Map)capturedValues.capture());
        Assertions.assertThat((Map)((Map)capturedValues.getValue())).isEqualTo((Object)Maps.asMap((Object)id, (Object)Arrays.asList((Object[])new Integer[]{10, 20})));
    }
}

