/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.SingleTablePolymorphicRelationJoinNode;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.collection.Iterables;

public class SingleTablePolymorphicRelationJoinNode<C, T1 extends Table<T1>, T2 extends Table<T2>, JOINCOLTYPE, I, DTYPE>
extends RelationJoinNode<C, T1, T2, JOINCOLTYPE, I> {
    private final Set<SubPersisterAndConsumer<C, ? extends C>> subPersisters = new HashSet<SubPersisterAndConsumer<C, ? extends C>>();
    private final Column<T2, DTYPE> discriminatorColumn;

    public SingleTablePolymorphicRelationJoinNode(JoinNode<T1> parent, Key<T1, JOINCOLTYPE> leftJoinColumn, Key<T2, JOINCOLTYPE> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias, EntityInflater<C, I> entityInflater, BeanRelationFixer<Object, C> beanRelationFixer, Column<T2, DTYPE> discriminatorColumn) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias, entityInflater, beanRelationFixer, null);
        this.discriminatorColumn = discriminatorColumn;
    }

    @Override
    public SingleTablePolymorphicRelationJoinRowConsumer toConsumer(ColumnedRow columnedRow) {
        return new SingleTablePolymorphicRelationJoinRowConsumer(columnedRow, this.discriminatorColumn, this.getConsumptionListener());
    }

    public <D extends C> void addSubPersisterJoin(ConfiguredRelationalPersister<D, I> subPersister, EntityJoinTree.PolymorphicMergeJoinRowConsumer<C, D, I> subPersisterJoin, DTYPE discriminatorValue) {
        this.subPersisters.add(new SubPersisterAndConsumer<C, D>(subPersister, subPersisterJoin, discriminatorValue));
    }

    protected class SingleTablePolymorphicRelationJoinRowConsumer
    implements RelationJoinNode.RelationJoinRowConsumer<C, I> {
        private final ColumnedRow columnedRow;
        @Nullable
        private final EntityTreeJoinNodeConsumptionListener<C> consumptionListener;
        private final Column<T2, DTYPE> discriminatorColumn;

        private SingleTablePolymorphicRelationJoinRowConsumer(ColumnedRow columnedRow, @Nullable Column<T2, DTYPE> discriminatorColumn, EntityTreeJoinNodeConsumptionListener<C> consumptionListener) {
            this.columnedRow = columnedRow;
            this.consumptionListener = consumptionListener;
            this.discriminatorColumn = discriminatorColumn;
        }

        @Override
        public C applyRelatedEntity(Object parentJoinEntity, Row row, EntityTreeInflater.TreeInflationContext context) {
            RowIdentifier rowIdentifier = this.giveIdentifier(row);
            if (rowIdentifier == null) {
                return null;
            }
            Object rightIdentifier = rowIdentifier.entityIdentifier;
            EntityTreeInflater.RelationIdentifier eventuallyApplied = new EntityTreeInflater.RelationIdentifier(parentJoinEntity, rowIdentifier.entityType, rowIdentifier.entityIdentifier, this);
            if (rightIdentifier != null && context.isTreatedOrAppend(eventuallyApplied)) {
                Object rightEntity = context.giveEntityFromCache(rowIdentifier.entityType, rightIdentifier, () -> rowIdentifier.rowConsumer.transform(row));
                SingleTablePolymorphicRelationJoinNode.this.getBeanRelationFixer().apply(parentJoinEntity, rightEntity);
                if (this.consumptionListener != null) {
                    this.consumptionListener.onNodeConsumption(rightEntity, col -> this.columnedRow.getValue((Selectable)col, row));
                }
                return rightEntity;
            }
            return null;
        }

        @Nullable
        public <D extends C> org.codefilarete.stalactite.engine.runtime.load.SingleTablePolymorphicRelationJoinNode$SingleTablePolymorphicRelationJoinRowConsumer.RowIdentifier<D> giveIdentifier(Row row) {
            Object assemble;
            SubPersisterAndConsumer discriminatorConsumer;
            Object discriminatorValue = this.columnedRow.getValue(this.discriminatorColumn, row);
            if (discriminatorValue != null && (discriminatorConsumer = (SubPersisterAndConsumer)Iterables.find((Iterable)SingleTablePolymorphicRelationJoinNode.this.subPersisters, o -> ((SubPersisterAndConsumer)o).discriminatorValue.equals(discriminatorValue))) != null && (assemble = discriminatorConsumer.subPersisterJoin.giveIdentifier(row)) != null) {
                return new RowIdentifier(assemble, discriminatorConsumer.subPersisterJoin, discriminatorConsumer.subPersister.getClassToPersist());
            }
            return null;
        }

        private class RowIdentifier<D extends C> {
            private final I entityIdentifier;
            private final EntityJoinTree.PolymorphicMergeJoinRowConsumer<C, D, I> rowConsumer;
            private final Class<D> entityType;

            private RowIdentifier(I entityIdentifier, EntityJoinTree.PolymorphicMergeJoinRowConsumer<C, D, I> rowConsumer, Class<D> entityType) {
                this.entityIdentifier = entityIdentifier;
                this.rowConsumer = rowConsumer;
                this.entityType = entityType;
            }
        }
    }

    private class SubPersisterAndConsumer<C, D extends C> {
        private final ConfiguredRelationalPersister<D, I> subPersister;
        private final EntityJoinTree.PolymorphicMergeJoinRowConsumer<C, D, I> subPersisterJoin;
        private final DTYPE discriminatorValue;

        public SubPersisterAndConsumer(ConfiguredRelationalPersister<D, I> subPersister, EntityJoinTree.PolymorphicMergeJoinRowConsumer<C, D, I> subPersisterJoin, DTYPE discriminatorValue) {
            this.subPersister = subPersister;
            this.subPersisterJoin = subPersisterJoin;
            this.discriminatorValue = discriminatorValue;
        }
    }
}

