/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.lang.invoke.SerializedLambda;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.MethodReferences;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.stalactite.sql.statement.binder.JdbcBinder;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.function.SerializableThrowingBiFunction;
import org.codefilarete.tool.function.SerializableThrowingFunction;
import org.codefilarete.tool.function.ThrowingBiFunction;

public interface ResultSetReader<I>
extends JdbcBinder<I> {
    public static <O> ResultSetReader<O> ofMethodReference(SerializableThrowingBiFunction<ResultSet, String, O, SQLException> resultSetGetter) {
        Class argumentType = MethodReferenceCapturer.giveArgumentTypes((SerializedLambda)MethodReferences.buildSerializedLambda(resultSetGetter)).getReturnType();
        return new LambdaResultSetReader<O>(resultSetGetter, argumentType);
    }

    default public I get(ResultSet resultSet, String columnName) {
        try {
            return this.doGet(resultSet, columnName);
        }
        catch (SQLException e) {
            throw new SQLStatement.BindingException("Error while reading column '" + columnName + "'", e);
        }
        catch (ClassCastException e) {
            String[] classNames = e.getMessage().split(" cannot be cast to ");
            CharSequence ellipsedValue = Strings.ellipsis((CharSequence)String.valueOf(DefaultResultSetReaders.OBJECT_READER.get(resultSet, columnName)), (int)15);
            throw new SQLStatement.BindingException("Error while reading column '" + columnName + "' : trying to read '" + ellipsedValue + "' as " + classNames[1] + " but was " + classNames[0], e);
        }
    }

    public I doGet(ResultSet var1, String var2) throws SQLException;

    default public <O> ResultSetReader<O> thenApply(SerializableThrowingFunction<I, O, ? extends Throwable> converter) {
        SerializedLambda methodReference = MethodReferences.buildSerializedLambda(converter);
        MethodReferenceCapturer.MethodDefinition methodDefinition = MethodReferenceCapturer.giveArgumentTypes((SerializedLambda)methodReference);
        Class readerType = methodReference.getImplMethodKind() == 6 ? methodDefinition.getReturnType() : (methodDefinition.getName().equals("<init>") ? methodDefinition.getDeclaringClass() : methodDefinition.getReturnType());
        return new LambdaResultSetReader<O>((rs, columnName) -> {
            try {
                return converter.apply(this.get((ResultSet)rs, (String)columnName));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, readerType){

            @Override
            public <U> Class<U> getColumnType() {
                return ResultSetReader.this.getColumnType();
            }
        };
    }

    public static class LambdaResultSetReader<I>
    implements ResultSetReader<I> {
        private final ThrowingBiFunction<ResultSet, String, I, SQLException> delegate;
        private final Class<I> type;

        public LambdaResultSetReader(ThrowingBiFunction<ResultSet, String, I, SQLException> delegate, Class<I> type) {
            this.delegate = delegate;
            this.type = type;
        }

        @Override
        public Class<I> getType() {
            return this.type;
        }

        @Override
        public I doGet(ResultSet resultSet, String columnName) throws SQLException {
            return (I)this.delegate.apply((Object)resultSet, (Object)columnName);
        }
    }
}

