/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.bean;

import java.lang.reflect.Method;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.query.bean.BeanQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.bean.BeanRepositoryQuery;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.tool.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class BeanQueryLookupStrategy<C>
implements QueryLookupStrategy {
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final BeanFactory beanFactory;
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;

    public BeanQueryLookupStrategy(AdvancedEntityPersister<C, ?> entityPersister, Dialect dialect, ConnectionProvider connectionProvider, BeanFactory beanFactory) {
        this.entityPersister = entityPersister;
        this.beanFactory = beanFactory;
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        Nullable bean;
        try {
            bean = Nullable.nullable((Object)this.beanFactory.getBean(method.getName(), EntityPersister.ExecutableEntityQuery.class));
        }
        catch (BeanNotOfRequiredTypeException | NoSuchBeanDefinitionException e) {
            bean = Nullable.nullable((Object)null);
        }
        if (bean.isPresent()) {
            BeanQueryMethod queryMethod = new BeanQueryMethod(method, metadata, factory);
            Accumulator accumulator = queryMethod.isCollectionQuery() ? Accumulators.toKeepingOrderSet() : Accumulators.getFirstUnique();
            return new BeanRepositoryQuery<C>(queryMethod, (EntityPersister.ExecutableEntityQuery)bean.get(), this.entityPersister, accumulator, this.dialect, this.connectionProvider);
        }
        return null;
    }
}

