/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manytomany;

import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointByMethodReference;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class ManyToManyRelation<SRC, TRGT, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>> {
    private final ReversibleAccessor<SRC, C1> collectionAccessor;
    private final ValueAccessPointByMethodReference<SRC> methodReference;
    private final EntityMappingConfigurationProvider<SRC, ?> sourceMappingConfiguration;
    private final EntityMappingConfigurationProvider<TRGT, TRGTID> targetMappingConfiguration;
    @Nullable
    private final Table targetTable;
    private CascadeOptions.RelationMode relationMode = CascadeOptions.RelationMode.ALL;
    private Supplier<C1> collectionFactory;
    private final MappedByConfiguration mappedByConfiguration = new MappedByConfiguration();
    private boolean fetchSeparately;
    private boolean ordered = false;
    private String indexingColumnName;

    public ManyToManyRelation(ReversibleAccessor<SRC, C1> collectionAccessor, ValueAccessPointByMethodReference<SRC> methodReference, EntityMappingConfiguration<? extends SRC, ?> sourceMappingConfiguration, EntityMappingConfiguration<? extends TRGT, TRGTID> targetMappingConfiguration, @Nullable Table targetTable) {
        this(collectionAccessor, methodReference, () -> sourceMappingConfiguration, () -> targetMappingConfiguration, targetTable);
    }

    public ManyToManyRelation(ReversibleAccessor<SRC, C1> collectionAccessor, ValueAccessPointByMethodReference<SRC> methodReference, EntityMappingConfigurationProvider<? extends SRC, ?> sourceMappingConfiguration, EntityMappingConfigurationProvider<? extends TRGT, TRGTID> targetMappingConfiguration, @Nullable Table targetTable) {
        this.collectionAccessor = collectionAccessor;
        this.methodReference = methodReference;
        this.sourceMappingConfiguration = sourceMappingConfiguration;
        this.targetMappingConfiguration = targetMappingConfiguration;
        this.targetTable = targetTable;
    }

    public ReversibleAccessor<SRC, C1> getCollectionAccessor() {
        return this.collectionAccessor;
    }

    public ValueAccessPointByMethodReference<SRC> getMethodReference() {
        return this.methodReference;
    }

    public EntityMappingConfiguration<SRC, ?> getSourceMappingConfiguration() {
        return this.sourceMappingConfiguration.getConfiguration();
    }

    public boolean isSourceTablePerClassPolymorphic() {
        return this.getSourceMappingConfiguration().getPolymorphismPolicy() instanceof PolymorphismPolicy.TablePerClassPolymorphism;
    }

    public EntityMappingConfiguration<TRGT, TRGTID> getTargetMappingConfiguration() {
        return this.targetMappingConfiguration.getConfiguration();
    }

    public boolean isTargetTablePerClassPolymorphic() {
        return this.getTargetMappingConfiguration().getPolymorphismPolicy() instanceof PolymorphismPolicy.TablePerClassPolymorphism;
    }

    @Nullable
    public Table getTargetTable() {
        return this.targetTable;
    }

    public CascadeOptions.RelationMode getRelationMode() {
        return this.relationMode;
    }

    public void setRelationMode(CascadeOptions.RelationMode relationMode) {
        this.relationMode = relationMode;
    }

    @Nullable
    public Supplier<C1> getCollectionFactory() {
        return this.collectionFactory;
    }

    public void setCollectionFactory(Supplier<C1> collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    public MappedByConfiguration<SRC, TRGT, C2> getMappedByConfiguration() {
        return this.mappedByConfiguration;
    }

    public void setIndexingColumnName(String columnName) {
        this.ordered();
        this.indexingColumnName = columnName;
    }

    @Nullable
    public String getIndexingColumnName() {
        return this.indexingColumnName;
    }

    public void ordered() {
        this.ordered = true;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isFetchSeparately() {
        return this.fetchSeparately;
    }

    public void setFetchSeparately(boolean fetchSeparately) {
        this.fetchSeparately = fetchSeparately;
    }

    public void fetchSeparately() {
        this.setFetchSeparately(true);
    }

    public static class MappedByConfiguration<SRC, TRGT, C2 extends Collection<SRC>> {
        @Nullable
        private SerializableBiConsumer<TRGT, SRC> reverseCombiner;
        @Nullable
        private SerializableFunction<TRGT, C2> reverseCollectionAccessor;
        @Nullable
        private SerializableBiConsumer<TRGT, C2> reverseCollectionMutator;
        @Nullable
        private Supplier<C2> reverseCollectionFactory;

        @Nullable
        public SerializableBiConsumer<TRGT, SRC> getReverseCombiner() {
            return this.reverseCombiner;
        }

        public void setReverseCombiner(@Nullable SerializableBiConsumer<TRGT, SRC> reverseCombiner) {
            this.reverseCombiner = reverseCombiner;
        }

        @Nullable
        public SerializableFunction<TRGT, C2> getReverseCollectionAccessor() {
            return this.reverseCollectionAccessor;
        }

        public void setReverseCollectionAccessor(@Nullable SerializableFunction<TRGT, C2> reverseCollectionAccessor) {
            this.reverseCollectionAccessor = reverseCollectionAccessor;
        }

        @Nullable
        public SerializableBiConsumer<TRGT, C2> getReverseCollectionMutator() {
            return this.reverseCollectionMutator;
        }

        public void setReverseCollectionMutator(@Nullable SerializableBiConsumer<TRGT, C2> reverseCollectionMutator) {
            this.reverseCollectionMutator = reverseCollectionMutator;
        }

        @Nullable
        public Supplier<C2> getReverseCollectionFactory() {
            return this.reverseCollectionFactory;
        }

        public void setReverseCollectionFactory(@Nullable Supplier<C2> reverseCollectionFactory) {
            this.reverseCollectionFactory = reverseCollectionFactory;
        }

        public boolean isEmpty() {
            return this.reverseCollectionAccessor == null && this.reverseCollectionMutator == null && this.reverseCollectionFactory == null && this.reverseCombiner == null;
        }
    }
}

