/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.DeleteExecutor;
import org.codefilarete.stalactite.engine.runtime.EntityConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.InsertExecutor;
import org.codefilarete.stalactite.engine.runtime.UpdateExecutor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.exception.NotImplementedException;
import org.codefilarete.tool.function.ThrowingRunnable;

public class BeanPersister<C, I, T extends Table<T>>
implements EntityConfiguredPersister<C, I> {
    private final EntityMapping<C, I, T> mappingStrategy;
    private final ConnectionConfiguration connectionConfiguration;
    private final DMLGenerator dmlGenerator;
    private final WriteOperationFactory writeOperationFactory;
    private final int inOperatorMaxSize;
    private PersisterListenerCollection<C, I> persisterListener = new PersisterListenerCollection();
    private final InsertExecutor<C, I, T> insertExecutor;
    private final UpdateExecutor<C, I, T> updateExecutor;
    private final DeleteExecutor<C, I, T> deleteExecutor;
    private final SelectExecutor<C, I> selectExecutor;

    public BeanPersister(EntityMapping<C, I, T> mappingStrategy, PersistenceContext persistenceContext) {
        this(mappingStrategy, persistenceContext.getDialect(), persistenceContext.getConnectionConfiguration());
    }

    public BeanPersister(EntityMapping<C, I, T> mappingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this.mappingStrategy = mappingStrategy;
        this.connectionConfiguration = connectionConfiguration;
        this.dmlGenerator = dialect.getDmlGenerator();
        this.writeOperationFactory = dialect.getWriteOperationFactory();
        this.inOperatorMaxSize = dialect.getInOperatorMaxSize();
        this.insertExecutor = this.newInsertExecutor(this.mappingStrategy, this.connectionConfiguration, this.dmlGenerator, this.writeOperationFactory, this.inOperatorMaxSize);
        this.updateExecutor = this.newUpdateExecutor(this.mappingStrategy, this.connectionConfiguration, this.dmlGenerator, this.writeOperationFactory, this.inOperatorMaxSize);
        this.deleteExecutor = this.newDeleteExecutor(this.mappingStrategy, this.connectionConfiguration, this.dmlGenerator, this.writeOperationFactory, this.inOperatorMaxSize);
        this.selectExecutor = this.newSelectExecutor(this.mappingStrategy, this.connectionConfiguration.getConnectionProvider(), dialect);
        this.getPersisterListener().addInsertListener(this.getMapping().getIdMapping().getIdentifierInsertionManager().getInsertListener());
        this.getPersisterListener().addSelectListener(this.getMapping().getIdMapping().getIdentifierInsertionManager().getSelectListener());
    }

    public BeanPersister(ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize, EntityMapping<C, I, T> mappingStrategy, InsertExecutor<C, I, T> insertExecutor, UpdateExecutor<C, I, T> updateExecutor, DeleteExecutor<C, I, T> deleteExecutor, SelectExecutor<C, I> selectExecutor) {
        this.mappingStrategy = mappingStrategy;
        this.connectionConfiguration = connectionConfiguration;
        this.dmlGenerator = dmlGenerator;
        this.writeOperationFactory = writeOperationFactory;
        this.inOperatorMaxSize = inOperatorMaxSize;
        this.insertExecutor = insertExecutor;
        this.updateExecutor = updateExecutor;
        this.deleteExecutor = deleteExecutor;
        this.selectExecutor = selectExecutor;
    }

    protected InsertExecutor<C, I, T> newInsertExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        return new InsertExecutor<C, I, T>(mappingStrategy, connectionConfiguration, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
    }

    protected UpdateExecutor<C, I, T> newUpdateExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionProvider, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        return new UpdateExecutor<C, I, T>(mappingStrategy, connectionProvider, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
    }

    protected DeleteExecutor<C, I, T> newDeleteExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        return new DeleteExecutor<C, I, T>(mappingStrategy, connectionConfiguration, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
    }

    protected SelectExecutor<C, I> newSelectExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionProvider connectionProvider, Dialect dialect) {
        return new org.codefilarete.stalactite.engine.runtime.SelectExecutor<C, I, T>(mappingStrategy, connectionProvider, dialect.getDmlGenerator(), dialect.getInOperatorMaxSize());
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionConfiguration.getConnectionProvider();
    }

    public DMLGenerator getDmlGenerator() {
        return this.dmlGenerator;
    }

    public int getInOperatorMaxSize() {
        return this.inOperatorMaxSize;
    }

    @Override
    public Class<C> getClassToPersist() {
        return this.getMapping().getClassToPersist();
    }

    @Override
    public EntityMapping<C, I, T> getMapping() {
        return this.mappingStrategy;
    }

    public T getMainTable() {
        return this.getMapping().getTargetTable();
    }

    @Override
    public Set<Table<?>> giveImpliedTables() {
        return Collections.singleton(this.getMainTable());
    }

    public void setPersisterListener(PersisterListenerCollection<C, I> persisterListener) {
        if (persisterListener != null) {
            this.persisterListener = persisterListener;
        }
    }

    @Override
    public PersisterListenerCollection<C, I> getPersisterListener() {
        return this.persisterListener;
    }

    public InsertExecutor<C, I, T> getInsertExecutor() {
        return this.insertExecutor;
    }

    public UpdateExecutor<C, I, T> getUpdateExecutor() {
        return this.updateExecutor;
    }

    public DeleteExecutor<C, I, T> getDeleteExecutor() {
        return this.deleteExecutor;
    }

    public SelectExecutor<C, I> getSelectExecutor() {
        return this.selectExecutor;
    }

    @Override
    public EntityPersister.ExecutableEntityQuery<C, ?> selectWhere() {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public EntityPersister.ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public Set<C> selectAll() {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public void addPersistListener(PersistListener<? extends C> persistListener) {
        this.getPersisterListener().addPersistListener(persistListener);
    }

    @Override
    public void addInsertListener(InsertListener<? extends C> insertListener) {
        this.getPersisterListener().addInsertListener(insertListener);
    }

    @Override
    public void addUpdateListener(UpdateListener<? extends C> updateListener) {
        this.getPersisterListener().addUpdateListener(updateListener);
    }

    @Override
    public void addUpdateByIdListener(UpdateByIdListener<? extends C> updateByIdListener) {
        this.getPersisterListener().addUpdateByIdListener(updateByIdListener);
    }

    @Override
    public void addSelectListener(SelectListener<? extends C, I> selectListener) {
        this.getPersisterListener().addSelectListener(selectListener);
    }

    @Override
    public void addDeleteListener(DeleteListener<? extends C> deleteListener) {
        this.getPersisterListener().addDeleteListener(deleteListener);
    }

    @Override
    public void addDeleteByIdListener(DeleteByIdListener<? extends C> deleteListener) {
        this.getPersisterListener().addDeleteByIdListener(deleteListener);
    }

    @Override
    public void persist(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.getPersisterListener().doWithPersistListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doPersist(entities)));
        }
    }

    protected void doPersist(Iterable<? extends C> entities) {
        PersistExecutor.persist(entities, this::isNew, this, this, this, this::getId);
    }

    @Override
    public void insert(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.getPersisterListener().doWithInsertListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doInsert(entities)));
        }
    }

    protected void doInsert(Iterable<? extends C> entities) {
        this.insertExecutor.insert(entities);
    }

    @Override
    public void updateById(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.getPersisterListener().doWithUpdateByIdListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doUpdateById(entities)));
        }
    }

    protected void doUpdateById(Iterable<? extends C> entities) {
        this.updateExecutor.updateById(entities);
    }

    @Override
    public void update(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        if (!Iterables.isEmpty(differencesIterable)) {
            this.getPersisterListener().doWithUpdateListener(differencesIterable, allColumnsStatement, this::doUpdate);
        }
    }

    protected void doUpdate(Iterable<? extends Duo<C, C>> entities, boolean allColumnsStatement) {
        this.updateExecutor.update(entities, allColumnsStatement);
    }

    @Override
    public void delete(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.getPersisterListener().doWithDeleteListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doDelete(entities)));
        }
    }

    protected void doDelete(Iterable<? extends C> entities) {
        this.deleteExecutor.delete(entities);
    }

    @Override
    public void deleteById(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.getPersisterListener().doWithDeleteByIdListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doDeleteById(entities)));
        }
    }

    protected void doDeleteById(Iterable<? extends C> entities) {
        this.deleteExecutor.deleteById(entities);
    }

    @Override
    public boolean isNew(C c) {
        return this.mappingStrategy.isNew(c);
    }

    @Override
    public Set<C> select(Iterable<I> ids) {
        if (Iterables.isEmpty(ids)) {
            return new HashSet();
        }
        return this.getPersisterListener().doWithSelectListener(ids, () -> this.doSelect(ids));
    }

    protected Set<C> doSelect(Iterable<I> ids) {
        return this.selectExecutor.select(ids);
    }
}

