/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.util.LinkedHashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.DialectResolver;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.trace.MutableLong;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ServiceLoaderDialectResolverTest {
    static DatabaseVendorSettings defaultDatabaseVendorSettings = new DatabaseVendorSettings(new ServiceLoaderDialectResolver.DatabaseSignet("my_vendor", 1, 0), (Set)Arrays.asSet((Object[])new String[]{"a_keyword"}), '\'', (JavaTypeToSqlTypeMapping)new DefaultTypeMapping(), new ParameterBinderRegistry(), (parameterBinders, dmlNameProviderFactory, sqlTypeRegistry) -> null, (GeneratedKeysReaderFactory)new GeneratedKeysReaderFactory.DefaultGeneratedKeysReaderFactory(new ParameterBinderRegistry()), (databaseSequence, connectionProvider) -> {
        MutableLong counter = new MutableLong();
        return () -> ((MutableLong)counter).increment();
    }, 100, false);

    ServiceLoaderDialectResolverTest() {
    }

    static Object[][] giveMatchingEntry() {
        DummyDialectEntry dialectA1 = new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("A", 1, 10), (Dialect)new DefaultDialect(), defaultDatabaseVendorSettings);
        DummyDialectEntry dialectB110 = new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("B", 1, 10), (Dialect)new DefaultDialect(), defaultDatabaseVendorSettings);
        DummyDialectEntry dialectB120 = new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("B", 1, 20), (Dialect)new DefaultDialect(), defaultDatabaseVendorSettings);
        DummyDialectEntry dialectB210 = new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("B", 2, 10), (Dialect)new DefaultDialect(), defaultDatabaseVendorSettings);
        DummyDialectEntry dialectB220 = new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("B", 2, 20), (Dialect)new DefaultDialect(), defaultDatabaseVendorSettings);
        DummyDialectEntry dialectB310 = new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("B", 3, 10), (Dialect)new DefaultDialect(), defaultDatabaseVendorSettings);
        DummyDialectEntry dialectC110 = new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("C", 1, 10), (Dialect)new DefaultDialect(), defaultDatabaseVendorSettings);
        LinkedHashSet availableDialects = Arrays.asSet((Object[])new DummyDialectEntry[]{dialectA1, dialectB110, dialectB120, dialectB210, dialectB220, dialectB310, dialectC110});
        return new Object[][]{{availableDialects, new ServiceLoaderDialectResolver.DatabaseSignet("X", 1, 10), null}, {availableDialects, new ServiceLoaderDialectResolver.DatabaseSignet("B", 0, 0), null}, {availableDialects, new ServiceLoaderDialectResolver.DatabaseSignet("B", 2, 15), dialectB210}, {availableDialects, new ServiceLoaderDialectResolver.DatabaseSignet("B", 4, 30), dialectB310}};
    }

    @ParameterizedTest
    @MethodSource
    void giveMatchingEntry(Set<DummyDialectEntry> dialectSet, ServiceLoaderDialectResolver.DatabaseSignet databaseSignet, DummyDialectEntry expectedDialect) {
        ServiceLoaderDialectResolver testInstance = new ServiceLoaderDialectResolver();
        DialectResolver.DialectResolverEntry dialect = testInstance.giveMatchingEntry(dialectSet, databaseSignet);
        Assertions.assertThat((Object)dialect).isEqualTo((Object)expectedDialect);
    }

    @Test
    void determineDialect_noCompatibleDialectFound_throwsException() {
        ServiceLoaderDialectResolver testInstance = new ServiceLoaderDialectResolver();
        Assertions.assertThatThrownBy(() -> testInstance.determineDialect((Iterable)Arrays.asSet((Object[])new DummyDialectEntry[]{new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("A", 0, 0), (Dialect)new DefaultDialect(), defaultDatabaseVendorSettings), new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("A", 0, 0), (Dialect)new DefaultDialect(), defaultDatabaseVendorSettings)}), new ServiceLoaderDialectResolver.DatabaseSignet("B", 2, 10))).hasMessageContaining("Unable to determine dialect").hasMessageContaining("B 2.10");
    }

    @Test
    void determineDialect_multipleDialectsWithSameCompatibilityGiven_throwsException() {
        ServiceLoaderDialectResolver testInstance = new ServiceLoaderDialectResolver();
        Assertions.assertThatThrownBy(() -> testInstance.giveMatchingEntry((Iterable)Arrays.asSet((Object[])new DummyDialectEntry[]{new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("B", 0, 0), null, defaultDatabaseVendorSettings), new DummyDialectEntry(new ServiceLoaderDialectResolver.DatabaseSignet("B", 0, 0), null, defaultDatabaseVendorSettings)}), new ServiceLoaderDialectResolver.DatabaseSignet("B", 2, 10))).hasMessageContaining("Multiple dialects with same database compatibility found : B 0.0");
    }

    static class DummyDialectEntry
    implements DialectResolver.DialectResolverEntry {
        private final ServiceLoaderDialectResolver.DatabaseSignet databaseSignet;
        private final Dialect dialect;
        private final DatabaseVendorSettings databaseVendorSettings;

        DummyDialectEntry(ServiceLoaderDialectResolver.DatabaseSignet databaseSignet, Dialect dialect, DatabaseVendorSettings databaseVendorSettings) {
            this.databaseSignet = databaseSignet;
            this.dialect = dialect;
            this.databaseVendorSettings = databaseVendorSettings;
        }

        public ServiceLoaderDialectResolver.DatabaseSignet getCompatibility() {
            return this.databaseSignet;
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public DatabaseVendorSettings getVendorSettings() {
            return this.databaseVendorSettings;
        }
    }
}

