/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.function.Hanger;

public class DialectOptions {
    private final OptionalSetting<Integer> inOperatorMaxSize = new OptionalSetting();
    private final OptionalSetting<Character> quoteCharacter = new OptionalSetting();
    private final OptionalSetting<Boolean> quoteSQLIdentifiers = new OptionalSetting();
    private final OptionalSetting<Set<JavaTypeToSQLType<?>>> javaTypeToSqlTypeMappings = new OptionalSetting();
    private final OptionalSetting<Set<JavaTypeBinder<?>>> javaTypeBinders = new OptionalSetting();

    public static DialectOptions noOptions() {
        return new DialectOptions();
    }

    public OptionalSetting<Integer> getInOperatorMaxSize() {
        return this.inOperatorMaxSize;
    }

    public DialectOptions setInOperatorMaxSize(int inOperatorMaxSize) {
        this.inOperatorMaxSize.set(inOperatorMaxSize);
        return this;
    }

    public OptionalSetting<Character> getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public DialectOptions setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter.set(Character.valueOf(quoteCharacter));
        return this;
    }

    public OptionalSetting<Boolean> getQuoteSQLIdentifiers() {
        return this.quoteSQLIdentifiers;
    }

    public DialectOptions setQuoteSQLIdentifiers(boolean quoteSQLIdentifiers) {
        this.quoteSQLIdentifiers.set(quoteSQLIdentifiers);
        return this;
    }

    public DialectOptions quoteSQLIdentifiers() {
        return this.setQuoteSQLIdentifiers(true);
    }

    public OptionalSetting<Set<JavaTypeBinder<?>>> getJavaTypeBinders() {
        return this.javaTypeBinders;
    }

    public OptionalSetting<Set<JavaTypeToSQLType<?>>> getJavaTypeToSqlTypeMappings() {
        return this.javaTypeToSqlTypeMappings;
    }

    public <T> DialectOptions addTypeBinding(Class<T> javaType, String sqlType, ParameterBinder<T> parameterBinder) {
        this.setJavaTypeToSQL(javaType, sqlType);
        this.setTypeBinding(javaType, parameterBinder);
        return this;
    }

    public DialectOptions setJavaTypeToSQL(Class<?> javaType, String sqlType) {
        if (this.javaTypeToSqlTypeMappings.get() == null) {
            this.javaTypeToSqlTypeMappings.set(new HashSet());
        }
        ((Set)this.javaTypeToSqlTypeMappings.get()).add(new JavaTypeToSQLType(javaType, sqlType));
        return this;
    }

    public <T> DialectOptions setTypeBinding(Class<T> javaType, ParameterBinder<T> parameterBinder) {
        if (this.javaTypeBinders.get() == null) {
            this.javaTypeBinders.set(new HashSet());
        }
        ((Set)this.javaTypeBinders.get()).add(new JavaTypeBinder(javaType, parameterBinder));
        return this;
    }

    public static class OptionalSetting<T>
    extends Hanger.Holder<T> {
        private boolean touched;

        private OptionalSetting() {
        }

        public void set(T value) {
            super.set(value);
            this.touched = true;
        }

        public boolean isTouched() {
            return this.touched;
        }

        public T getOrDefault(T defaultValue) {
            return (T)(this.isTouched() ? super.get() : defaultValue);
        }

        public void consumeIfTouched(Consumer<T> consumer) {
            if (this.isTouched()) {
                consumer.accept(this.get());
            }
        }
    }

    public static class JavaTypeBinder<T> {
        private final Class<T> javaType;
        private final ParameterBinder<T> parameterBinder;

        private JavaTypeBinder(Class<T> javaType, ParameterBinder<T> parameterBinder) {
            this.javaType = javaType;
            this.parameterBinder = parameterBinder;
        }

        public Class<T> getJavaType() {
            return this.javaType;
        }

        public ParameterBinder<T> getParameterBinder() {
            return this.parameterBinder;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaTypeBinder that = (JavaTypeBinder)o;
            return this.javaType.equals(that.javaType);
        }

        public int hashCode() {
            return this.javaType.hashCode();
        }
    }

    public static class JavaTypeToSQLType<T> {
        private final Class<T> javaType;
        private final String sqlType;

        private JavaTypeToSQLType(Class<T> javaType, String sqlType) {
            this.javaType = javaType;
            this.sqlType = sqlType;
        }

        public Class<T> getJavaType() {
            return this.javaType;
        }

        public String getSqlType() {
            return this.sqlType;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaTypeToSQLType that = (JavaTypeToSQLType)o;
            return this.javaType.equals(that.javaType);
        }

        public int hashCode() {
            return this.javaType.hashCode();
        }
    }
}

