/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DatabaseSequenceSelectorFactory;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;

public interface Dialect {
    public DDLTableGenerator getDdlTableGenerator();

    public DDLSequenceGenerator getDdlSequenceGenerator();

    public DMLGenerator getDmlGenerator();

    public WriteOperationFactory getWriteOperationFactory();

    public ReadOperationFactory getReadOperationFactory();

    public QuerySQLBuilderFactory getQuerySQLBuilderFactory();

    public SqlTypeRegistry getSqlTypeRegistry();

    public ColumnBinderRegistry getColumnBinderRegistry();

    public DMLNameProviderFactory getDmlNameProviderFactory();

    public int getInOperatorMaxSize();

    default public <I> GeneratedKeysReader<I> buildGeneratedKeysReader(String keyName, Class<I> columnType) {
        return this.getGeneratedKeysReaderFactory().build(keyName, columnType);
    }

    public GeneratedKeysReaderFactory getGeneratedKeysReaderFactory();

    public DatabaseSequenceSelectorFactory getDatabaseSequenceSelectorFactory();

    public ServiceLoaderDialectResolver.DatabaseSignet getCompatibility();

    public boolean supportsTupleCondition();

    public static class DialectSupport
    implements Dialect {
        private final DDLTableGenerator ddlTableGenerator;
        private final DDLSequenceGenerator ddlSequenceGenerator;
        private final DMLGenerator dmlGenerator;
        private final WriteOperationFactory writeOperationFactory;
        private final ReadOperationFactory readOperationFactory;
        private final QuerySQLBuilderFactory querySQLBuilderFactory;
        private final SqlTypeRegistry sqlTypeRegistry;
        private final ColumnBinderRegistry columnBinderRegistry;
        private final DMLNameProviderFactory dmlNameProviderFactory;
        private final int inOperatorMaxSize;
        private final GeneratedKeysReaderFactory generatedKeysReaderFactory;
        private final boolean supportsTupleCondition;
        private final DatabaseSequenceSelectorFactory databaseSequenceSelectorFactory;
        private final ServiceLoaderDialectResolver.DatabaseSignet compatibility;

        public DialectSupport(ServiceLoaderDialectResolver.DatabaseSignet compatibility, DDLTableGenerator ddlTableGenerator, DDLSequenceGenerator ddlSequenceGenerator, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, ReadOperationFactory readOperationFactory, QuerySQLBuilderFactory querySQLBuilderFactory, SqlTypeRegistry sqlTypeRegistry, ColumnBinderRegistry columnBinderRegistry, DMLNameProviderFactory dmlNameProviderFactory, int inOperatorMaxSize, GeneratedKeysReaderFactory generatedKeysReaderFactory, DatabaseSequenceSelectorFactory databaseSequenceSelectorFactory, boolean supportsTupleCondition) {
            this.ddlTableGenerator = ddlTableGenerator;
            this.ddlSequenceGenerator = ddlSequenceGenerator;
            this.dmlGenerator = dmlGenerator;
            this.writeOperationFactory = writeOperationFactory;
            this.readOperationFactory = readOperationFactory;
            this.querySQLBuilderFactory = querySQLBuilderFactory;
            this.sqlTypeRegistry = sqlTypeRegistry;
            this.columnBinderRegistry = columnBinderRegistry;
            this.dmlNameProviderFactory = dmlNameProviderFactory;
            this.inOperatorMaxSize = inOperatorMaxSize;
            this.generatedKeysReaderFactory = generatedKeysReaderFactory;
            this.databaseSequenceSelectorFactory = databaseSequenceSelectorFactory;
            this.supportsTupleCondition = supportsTupleCondition;
            this.compatibility = compatibility;
        }

        @Override
        public DDLTableGenerator getDdlTableGenerator() {
            return this.ddlTableGenerator;
        }

        @Override
        public DDLSequenceGenerator getDdlSequenceGenerator() {
            return this.ddlSequenceGenerator;
        }

        @Override
        public DMLGenerator getDmlGenerator() {
            return this.dmlGenerator;
        }

        @Override
        public WriteOperationFactory getWriteOperationFactory() {
            return this.writeOperationFactory;
        }

        @Override
        public ReadOperationFactory getReadOperationFactory() {
            return this.readOperationFactory;
        }

        @Override
        public QuerySQLBuilderFactory getQuerySQLBuilderFactory() {
            return this.querySQLBuilderFactory;
        }

        @Override
        public SqlTypeRegistry getSqlTypeRegistry() {
            return this.sqlTypeRegistry;
        }

        @Override
        public ColumnBinderRegistry getColumnBinderRegistry() {
            return this.columnBinderRegistry;
        }

        @Override
        public DMLNameProviderFactory getDmlNameProviderFactory() {
            return this.dmlNameProviderFactory;
        }

        @Override
        public int getInOperatorMaxSize() {
            return this.inOperatorMaxSize;
        }

        @Override
        public GeneratedKeysReaderFactory getGeneratedKeysReaderFactory() {
            return this.generatedKeysReaderFactory;
        }

        @Override
        public boolean supportsTupleCondition() {
            return this.supportsTupleCondition;
        }

        @Override
        public DatabaseSequenceSelectorFactory getDatabaseSequenceSelectorFactory() {
            return this.databaseSequenceSelectorFactory;
        }

        @Override
        public ServiceLoaderDialectResolver.DatabaseSignet getCompatibility() {
            return this.compatibility;
        }
    }
}

