/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.runtime.EntityMappingTreeSelectExecutor;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.ComposedIdMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.ComposedIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.SimpleIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.stalactite.test.PairSetList;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.exception.NotImplementedException;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EntityMappingTreeSelectExecutorTest {
    @BeforeEach
    void initEntityCandidates() {
        PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class)));
    }

    @AfterEach
    void removeEntityCandidates() {
        PersisterBuilderContext.CURRENT.remove();
    }

    static ClassMapping buildMappingStrategyMock(Table table) {
        ClassMapping mappingStrategyMock = (ClassMapping)Mockito.mock(ClassMapping.class);
        Mockito.when((Object)mappingStrategyMock.getTargetTable()).thenReturn((Object)table);
        Mockito.when((Object)mappingStrategyMock.getSelectableColumns()).thenAnswer(invocation -> table.getColumns());
        return mappingStrategyMock;
    }

    public static Object[][] selectData() {
        Table tableWith1ColumnedPK = new Table("Toto");
        Column id1PK = tableWith1ColumnedPK.addColumn("id1", Integer.TYPE).primaryKey();
        Table tableWith2ColumnedPK = new Table("Toto");
        Column id2PK1 = tableWith2ColumnedPK.addColumn("id1", Integer.TYPE).primaryKey();
        Column id2PK2 = tableWith2ColumnedPK.addColumn("id2", Integer.TYPE).primaryKey();
        Table tableWith3ColumnedPK = new Table("Toto");
        Column id3PK1 = tableWith3ColumnedPK.addColumn("id1", Integer.TYPE).primaryKey();
        Column id3PK2 = tableWith3ColumnedPK.addColumn("id2", Integer.TYPE).primaryKey();
        Column id3PK3 = tableWith3ColumnedPK.addColumn("id3", Integer.TYPE).primaryKey();
        return new Object[][]{{tableWith1ColumnedPK, Arrays.asList((Object[])new String[]{"select Toto.id1 as Toto_id1 from Toto where Toto.id1 in (?, ?, ?)", "select Toto.id1 as Toto_id1 from Toto where Toto.id1 in (?)"}), PairSetList.pairSetList((Object)1, (Object)11).add((Object)2, (Object)13).add((Object)3, (Object)17).newRow((Object)1, (Object)23)}, {tableWith2ColumnedPK, Arrays.asList((Object[])new String[]{"select Toto.id1 as Toto_id1, Toto.id2 as Toto_id2 from Toto where (Toto.id1, Toto.id2) in ((?, ?), (?, ?), (?, ?))", "select Toto.id1 as Toto_id1, Toto.id2 as Toto_id2 from Toto where (Toto.id1, Toto.id2) in ((?, ?))"}), PairSetList.pairSetList((Object)1, (Object)11).add((Object)2, (Object)11).add((Object)3, (Object)13).add((Object)4, (Object)13).add((Object)5, (Object)17).add((Object)6, (Object)17).newRow((Object)1, (Object)23).add((Object)2, (Object)23)}, {tableWith3ColumnedPK, Arrays.asList((Object[])new String[]{"select Toto.id1 as Toto_id1, Toto.id2 as Toto_id2, Toto.id3 as Toto_id3 from Toto where (Toto.id1, Toto.id2, Toto.id3) in ((?, ?, ?), (?, ?, ?), (?, ?, ?))", "select Toto.id1 as Toto_id1, Toto.id2 as Toto_id2, Toto.id3 as Toto_id3 from Toto where (Toto.id1, Toto.id2, Toto.id3) in ((?, ?, ?))"}), PairSetList.pairSetList((Object)1, (Object)11).add((Object)2, (Object)11).add((Object)3, (Object)11).add((Object)4, (Object)13).add((Object)5, (Object)13).add((Object)6, (Object)13).add((Object)7, (Object)17).add((Object)8, (Object)17).add((Object)9, (Object)17).newRow((Object)1, (Object)23).add((Object)2, (Object)23).add((Object)3, (Object)23)}};
    }

    @ParameterizedTest
    @MethodSource(value={"selectData"})
    public <T extends Table<T>> void select(T targetTable, List<String> expectedSql, PairSetList<Integer, Integer> expectedParameters) throws SQLException {
        ClassMapping classMappingStrategy = EntityMappingTreeSelectExecutorTest.buildMappingStrategyMock(targetTable);
        IdMapping idMappingMock = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)classMappingStrategy.getIdMapping()).thenReturn((Object)idMappingMock);
        final PrimaryKey primaryKey = targetTable.getPrimaryKey();
        Object t = !primaryKey.isComposed() ? new SimpleIdentifierAssembler((Column)Iterables.first((Iterable)primaryKey.getColumns())) : new ComposedIdentifierAssembler<Object, T>(primaryKey){

            @Nullable
            public Object assemble(Function<Column<?, ?>, Object> columnValueProvider) {
                throw new NotImplementedException("Method is not expected to be called");
            }

            public Map<Column<T, ?>, Object> getColumnValues(Object id) {
                return Iterables.map((Iterable)primaryKey.getColumns(), Function.identity(), c -> id);
            }
        };
        Mockito.when((Object)idMappingMock.getIdentifierAssembler()).thenReturn(t);
        DefaultDialect dialect = new DefaultDialect();
        dialect.setInOperatorMaxSize(3);
        JdbcArgCaptor jdbcArgCaptor = new JdbcArgCaptor();
        SimpleConnectionProvider connectionProvider = new SimpleConnectionProvider(jdbcArgCaptor.connection);
        EntityMappingTreeSelectExecutor testInstance = new EntityMappingTreeSelectExecutor((EntityMapping)classMappingStrategy, (Dialect)dialect, (ConnectionProvider)connectionProvider);
        testInstance.prepareQuery();
        List inputValues = Arrays.asList((Object[])new Integer[]{11, 13, 17, 23});
        testInstance.select((Iterable)inputValues);
        int expectedQueryCount = (int)Math.ceil((double)inputValues.size() / (double)dialect.getInOperatorMaxSize());
        ((PreparedStatement)Mockito.verify((Object)jdbcArgCaptor.preparedStatement, (VerificationMode)Mockito.times((int)expectedQueryCount))).executeQuery();
        int expectedParamCount = inputValues.size() * primaryKey.getColumns().size();
        ((PreparedStatement)Mockito.verify((Object)jdbcArgCaptor.preparedStatement, (VerificationMode)Mockito.times((int)expectedParamCount))).setInt((Integer)jdbcArgCaptor.indexCaptor.capture(), (Integer)jdbcArgCaptor.valueCaptor.capture());
        Assertions.assertThat((List)jdbcArgCaptor.statementArgCaptor.getAllValues()).isEqualTo(expectedSql);
        PairIterator capturedValues = new PairIterator((Iterable)jdbcArgCaptor.indexCaptor.getAllValues(), (Iterable)jdbcArgCaptor.valueCaptor.getAllValues());
        PairSetList capturedValuesAsPairSetList = new PairSetList();
        int paramCountPerQuery = primaryKey.getColumns().size() * dialect.getInOperatorMaxSize();
        Iterables.iterate((Iterator)capturedValues, (i, c) -> {
            if (i != 0 && i % paramCountPerQuery == 0) {
                capturedValuesAsPairSetList.newRow();
            }
            capturedValuesAsPairSetList.add(c.getLeft(), c.getRight());
        });
        Assertions.assertThat((Object)capturedValuesAsPairSetList).isEqualTo(expectedParameters);
    }

    @Test
    public <T extends Table<T>> void select_argumentWithOneBlock() throws SQLException {
        Table dummyTable = new Table("dummyTable");
        Column dummyPK = dummyTable.addColumn("dummyPK", Integer.class).primaryKey();
        ClassMapping classMappingStrategy = EntityMappingTreeSelectExecutorTest.buildMappingStrategyMock(dummyTable);
        IdMapping idMappingMock = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)classMappingStrategy.getIdMapping()).thenReturn((Object)idMappingMock);
        Mockito.when((Object)idMappingMock.getIdentifierAssembler()).thenReturn((Object)new SimpleIdentifierAssembler(dummyPK));
        DefaultDialect dialect = new DefaultDialect();
        dialect.setInOperatorMaxSize(3);
        JdbcArgCaptor jdbcArgCaptor = new JdbcArgCaptor();
        SimpleConnectionProvider connectionProvider = new SimpleConnectionProvider(jdbcArgCaptor.connection);
        EntityMappingTreeSelectExecutor testInstance = new EntityMappingTreeSelectExecutor((EntityMapping)classMappingStrategy, (Dialect)dialect, (ConnectionProvider)connectionProvider);
        testInstance.prepareQuery();
        testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{11, 13}));
        ((PreparedStatement)Mockito.verify((Object)jdbcArgCaptor.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
        ((PreparedStatement)Mockito.verify((Object)jdbcArgCaptor.preparedStatement, (VerificationMode)Mockito.times((int)2))).setInt((Integer)jdbcArgCaptor.indexCaptor.capture(), (Integer)jdbcArgCaptor.valueCaptor.capture());
        Assertions.assertThat((List)jdbcArgCaptor.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select dummyTable.dummyPK as dummyTable_dummyPK from dummyTable where dummyTable.dummyPK in (?, ?)"}));
        List expectedPairs = Arrays.asList((Object[])new Duo[]{new Duo((Object)1, (Object)11), new Duo((Object)2, (Object)13)});
        PairIterator capturedValues = new PairIterator((Iterable)jdbcArgCaptor.indexCaptor.getAllValues(), (Iterable)jdbcArgCaptor.valueCaptor.getAllValues());
        Assertions.assertThat((List)Iterables.copy((Iterator)capturedValues)).isEqualTo((Object)expectedPairs);
    }

    @Test
    public <T extends Table<T>> void select_emptyArgument() {
        Table dummyTable = new Table("dummyTable");
        dummyTable.addColumn("id", Long.TYPE).primaryKey();
        ClassMapping classMappingStrategy = EntityMappingTreeSelectExecutorTest.buildMappingStrategyMock(dummyTable);
        IdMapping idMappingMock = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)classMappingStrategy.getIdMapping()).thenReturn((Object)idMappingMock);
        final ArrayList capturedSQL = new ArrayList();
        DefaultDialect dialect = new DefaultDialect();
        dialect.setInOperatorMaxSize(3);
        final ConnectionProvider connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        EntityMappingTreeSelectExecutor testInstance = new EntityMappingTreeSelectExecutor<Object, Object, T>((EntityMapping)classMappingStrategy, (Dialect)dialect, connectionProvider){

            EntityMappingTreeSelectExecutor.InternalExecutor newInternalExecutor(EntityTreeQueryBuilder.EntityTreeQuery<Object> entityTreeQuery) {
                return new EntityMappingTreeSelectExecutor.InternalExecutor(entityTreeQuery, connectionProvider){

                    List<Object> execute(String sql, Collection<? extends List<Object>> idsParcels, Map<Column<T, ?>, int[]> inOperatorValueIndexes) {
                        capturedSQL.add(sql);
                        return Collections.emptyList();
                    }
                };
            }
        };
        testInstance.prepareQuery();
        testInstance.select((Iterable)Arrays.asList((Object[])new Object[0]));
        Assertions.assertThat((boolean)capturedSQL.isEmpty()).isTrue();
    }

    @Test
    public <T extends Table<T>> void execute_realLife_composedId() throws SQLException {
        HSQLDBInMemoryDataSource dataSource = new HSQLDBInMemoryDataSource();
        Table targetTable = new Table("Toto");
        final Column id1 = targetTable.addColumn("id1", Long.TYPE).primaryKey();
        final Column id2 = targetTable.addColumn("id2", Long.TYPE).primaryKey();
        Column name = targetTable.addColumn("name", String.class);
        CurrentThreadConnectionProvider connectionProvider = new CurrentThreadConnectionProvider((DataSource)dataSource);
        DDLDeployer ddlDeployer = new DDLDeployer(HSQLDBDialectBuilder.defaultHSQLDBDialect().getDdlTableGenerator(), HSQLDBDialectBuilder.defaultHSQLDBDialect().getDdlSequenceGenerator(), (ConnectionProvider)connectionProvider);
        ddlDeployer.getDdlGenerator().addTables(targetTable, new Table[0]);
        ddlDeployer.deployDDL();
        Toto entity1 = new Toto(100L, 1L, "entity1");
        Toto entity2 = new Toto(200L, 2L, "entity2");
        Connection currentConnection = connectionProvider.giveConnection();
        PreparedStatement insertStatement = currentConnection.prepareStatement("insert into Toto(id1, id2, name) values (?, ?, ?)");
        insertStatement.setLong(1, entity1.id1);
        insertStatement.setLong(2, entity1.id2);
        insertStatement.setString(3, entity1.name);
        insertStatement.addBatch();
        insertStatement.setLong(1, entity2.id1);
        insertStatement.setLong(2, entity2.id2);
        insertStatement.setString(3, entity2.name);
        insertStatement.addBatch();
        insertStatement.executeBatch();
        insertStatement.close();
        currentConnection.commit();
        AccessorWrapperIdAccessor idAccessor = new AccessorWrapperIdAccessor(Accessors.accessorByMethodReference((SerializableFunction)SerializableFunction.identity(), (SerializableBiConsumer & Serializable)(toto, toto2) -> {
            ((Toto)toto).id1 = ((Toto)toto2).id1;
            ((Toto)toto).id2 = ((Toto)toto2).id2;
        }));
        ClassMapping classMappingStrategy = new ClassMapping(Toto.class, targetTable, (Map)Maps.asMap((Object)Accessors.accessorByMethodReference(Toto::getId1, Toto::setId1), (Object)id1).add((Object)Accessors.accessorByMethodReference(Toto::getId2, Toto::setId2), (Object)id2).add((Object)Accessors.accessorByMethodReference(Toto::getName, Toto::setName), (Object)name), (IdMapping)new ComposedIdMapping((IdAccessor)idAccessor, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Toto.class, c -> {}, c -> false), new ComposedIdentifierAssembler<Toto, T>(targetTable){

            public Toto assemble(Function<Column<?, ?>, Object> columnValueProvider) {
                return new Toto((Long)columnValueProvider.apply(id1), (Long)columnValueProvider.apply(id2));
            }

            public Map<Column<T, ?>, Object> getColumnValues(Toto id) {
                return Maps.forHashMap((Class)null, Object.class).add((Object)id1, (Object)id.id1).add((Object)id2, (Object)id.id2);
            }
        }));
        EntityMappingTreeSelectExecutor testInstance = new EntityMappingTreeSelectExecutor((EntityMapping)classMappingStrategy, HSQLDBDialectBuilder.defaultHSQLDBDialect(), (ConnectionProvider)connectionProvider);
        testInstance.prepareQuery();
        Set select = testInstance.select((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(100L, 1L)}));
        Assertions.assertThat((String)select.toString()).isEqualTo(Arrays.asList((Object[])new Toto[]{entity1}).toString());
        select = testInstance.select((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(100L, 1L), new Toto(200L, 2L)}));
        Comparator<Toto> totoComparator = Comparator.comparing(toto -> Long.valueOf(31L * toto.getId1() + toto.getId2()));
        Assertions.assertThat((String)Arrays.asTreeSet(totoComparator, (Collection)select).toString()).isEqualTo(Arrays.asTreeSet(totoComparator, (Object[])new Toto[]{entity1, entity2}).toString());
    }

    protected static class JdbcArgCaptor {
        protected final Dialect dialect = new DefaultDialect(new JavaTypeToSqlTypeMapping().with(Integer.class, "int"));
        protected PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        protected ArgumentCaptor<Integer> valueCaptor;
        protected ArgumentCaptor<Integer> indexCaptor;
        protected ArgumentCaptor<String> statementArgCaptor;
        protected Connection connection;

        protected JdbcArgCaptor() throws SQLException {
            Mockito.when((Object)this.preparedStatement.executeLargeBatch()).thenReturn((Object)new long[]{1L});
            this.connection = (Connection)Mockito.mock(Connection.class);
            Mockito.when((Object)this.preparedStatement.getConnection()).thenReturn((Object)this.connection);
            this.statementArgCaptor = ArgumentCaptor.forClass(String.class);
            Mockito.when((Object)this.connection.prepareStatement((String)this.statementArgCaptor.capture())).thenReturn((Object)this.preparedStatement);
            Mockito.when((Object)this.connection.prepareStatement((String)this.statementArgCaptor.capture(), ArgumentMatchers.anyInt())).thenReturn((Object)this.preparedStatement);
            ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
            Mockito.when((Object)this.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
            this.valueCaptor = ArgumentCaptor.forClass(Integer.class);
            this.indexCaptor = ArgumentCaptor.forClass(Integer.class);
        }
    }

    private static class Toto {
        private long id1;
        private long id2;
        private String name;

        public Toto() {
        }

        public Toto(long id1, long id2) {
            this.id1 = id1;
            this.id2 = id2;
        }

        public Toto(long id1, long id2, String name) {
            this.id1 = id1;
            this.id2 = id2;
            this.name = name;
        }

        public long getId1() {
            return this.id1;
        }

        public void setId1(long id1) {
            this.id1 = id1;
        }

        public long getId2() {
            return this.id2;
        }

        public void setId2(long id2) {
            this.id2 = id2;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "Toto{id1=" + this.id1 + ", id2=" + this.id2 + ", name='" + this.name + '\'' + '}';
        }
    }
}

