/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.StaleStateObjectException;
import org.codefilarete.stalactite.engine.idprovider.LongProvider;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.TransactionAwareConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.Serie;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportVersioningTest {
    private static final Dialect DIALECT = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    @BeforeAll
    public static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
    }

    @BeforeEach
    public void initTest() {
        this.persistenceContext = new PersistenceContext(this.dataSource, DIALECT);
    }

    @Test
    public void build_versionedPropertyIsOfUnsupportedType_throwsException() {
        PersistenceContext persistenceContext = new PersistenceContext(this.dataSource, DIALECT);
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).versionedBy(Country::getName).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).build(persistenceContext));
    }

    @Test
    public void update_versionIsUpgraded_integerVersion() {
        TransactionAwareConnectionProvider connectionProvider = new TransactionAwareConnectionProvider((ConnectionProvider)new CurrentThreadConnectionProvider(this.dataSource));
        this.persistenceContext = new PersistenceContext((ConnectionProvider)connectionProvider, DIALECT);
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).versionedBy(Country::getVersion, (Serie)new Serie.IntegerSerie()).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider countryIdProvider = new LongProvider();
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        countryPersister.insert((Object)dummyCountry);
        Country dummyCountryClone1 = (Country)countryPersister.select(dummyCountry.getId());
        dummyCountryClone1.setName("Toto");
        countryPersister.update((Object)dummyCountryClone1, (Object)dummyCountry, true);
        Assertions.assertThat((int)dummyCountryClone1.getVersion()).isEqualTo(2);
        Assertions.assertThat((int)dummyCountry.getVersion()).isEqualTo(1);
        Country dummyCountryClone2 = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat((int)dummyCountryClone2.getVersion()).isEqualTo(2);
        dummyCountryClone2.setName("Tutu");
        countryPersister.update((Object)dummyCountryClone2, (Object)dummyCountryClone1, true);
        Assertions.assertThat((int)dummyCountryClone2.getVersion()).isEqualTo(3);
        Assertions.assertThat((int)dummyCountry.getVersion()).isEqualTo(1);
    }

    @Test
    public void update_versionIsUpgraded_dateVersion() {
        TransactionAwareConnectionProvider connectionProvider = new TransactionAwareConnectionProvider((ConnectionProvider)new CurrentThreadConnectionProvider(this.dataSource));
        this.persistenceContext = new PersistenceContext((ConnectionProvider)connectionProvider, DIALECT);
        final ArrayList nowHistory = new ArrayList();
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).versionedBy(Country::getModificationDate, (Serie)new Serie.NowSerie(){

            public LocalDateTime next(LocalDateTime input) {
                LocalDateTime now = super.next(input);
                nowHistory.add(now);
                return now;
            }
        }).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider countryIdProvider = new LongProvider();
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        countryPersister.insert((Object)dummyCountry);
        Country dummyCountryClone1 = (Country)countryPersister.select(dummyCountry.getId());
        dummyCountryClone1.setName("Toto");
        countryPersister.update((Object)dummyCountryClone1, (Object)dummyCountry, true);
        Assertions.assertThat((LocalDateTime)dummyCountryClone1.getModificationDate()).isEqualTo(nowHistory.get(1));
        Assertions.assertThat((LocalDateTime)dummyCountry.getModificationDate()).isEqualTo(nowHistory.get(0));
        Country dummyCountryClone2 = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat((LocalDateTime)dummyCountryClone2.getModificationDate()).isEqualTo(nowHistory.get(1));
        dummyCountryClone2.setName("Tutu");
        countryPersister.update((Object)dummyCountryClone2, (Object)dummyCountryClone1, true);
        Assertions.assertThat((LocalDateTime)dummyCountryClone2.getModificationDate()).isEqualTo(nowHistory.get(2));
        Assertions.assertThat((LocalDateTime)dummyCountry.getModificationDate()).isEqualTo(nowHistory.get(0));
    }

    @Test
    public void update_entityIsOutOfSync_databaseIsNotUpdated() throws SQLException {
        this.persistenceContext = new PersistenceContext(this.dataSource, DIALECT);
        ConnectionProvider connectionProvider = this.persistenceContext.getConnectionProvider();
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).versionedBy(Country::getVersion, (Serie)new Serie.IntegerSerie()).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider countryIdProvider = new LongProvider();
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        countryPersister.insert((Object)dummyCountry);
        Assertions.assertThat((int)dummyCountry.getVersion()).isEqualTo(1);
        Country dummyCountryClone = (Country)countryPersister.select(dummyCountry.getId());
        connectionProvider.giveConnection().createStatement().executeUpdate("update Country set version = version + 1 where id = " + dummyCountry.getId().getSurrogate());
        dummyCountryClone.setName("Tata");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> countryPersister.update((Object)dummyCountryClone, (Object)dummyCountry, true)).extracting(t -> (StaleStateObjectException)Exceptions.findExceptionInCauses((Throwable)t, StaleStateObjectException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("1 rows were expected to be hit but 0 were effectively");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> countryPersister.delete((Object)dummyCountry)).extracting(t -> (StaleStateObjectException)Exceptions.findExceptionInCauses((Throwable)t, StaleStateObjectException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("1 rows were expected to be hit but 0 were effectively");
        Assertions.assertThat((int)dummyCountryClone.getVersion()).isEqualTo(2);
        connectionProvider.giveConnection().rollback();
        Assertions.assertThat((int)dummyCountryClone.getVersion()).isEqualTo(1);
        connectionProvider.giveConnection().rollback();
        Assertions.assertThat((int)dummyCountryClone.getVersion()).isEqualTo(1);
    }
}

