/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.function.SerializableTriFunction;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class FluentEntityMappingConfigurationSupportOneToManyListTest {
    private static final Dialect DIALECT = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private final ConnectionProvider connectionProvider = new CurrentThreadConnectionProvider(this.dataSource);
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportOneToManyListTest() {
    }

    @BeforeAll
    static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
    }

    @Test
    void insert_cascadeIsTriggered() {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, DIALECT);
        Table choiceTable = new Table("Choice");
        Column id = choiceTable.addColumn("id", Identifier.class).primaryKey();
        Column idx = choiceTable.addColumn("idx", Integer.TYPE);
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions choiceMappingConfiguration = MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel);
        EntityPersister questionPersister = MappingEase.entityBuilder(Question.class, Identifier.LONG_TYPE).mapKey(Question::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Question::getChoices, (EntityMappingConfigurationProvider)choiceMappingConfiguration).mappedBy(Choice::getQuestion).indexedBy(idx).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Question newQuestion = new Question(1L);
        newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{new Choice(10L), new Choice(20L), new Choice(30L)}));
        questionPersister.insert((Object)newQuestion);
        PersistenceContext.ExecutableBeanPropertyQueryMapper resultExecutableQuery = this.persistenceContext.newQuery((QueryProvider)QueryEase.select((Selectable)id, (Selectable[])new Selectable[]{idx}).from((Fromable)choiceTable).orderBy(id, new Column[0]), Result.class).mapKey((SerializableFunction & Serializable)x$0 -> new Result((Identifier)x$0), id).map(idx, (SerializableBiConsumer & Serializable)(rec$, x$0) -> ((Result)rec$).setIdx(x$0));
        Set persistedChoices = (Set)resultExecutableQuery.execute(Accumulators.toKeepingOrderSet());
        Assertions.assertThat((Collection)persistedChoices).extracting(Result::getId).containsExactly((Object[])new Long[]{10L, 20L, 30L});
        Assertions.assertThat((Collection)persistedChoices).extracting(rec$ -> ((Result)rec$).getIdx()).containsExactly((Object[])new Integer[]{1, 2, 3});
    }

    @Test
    void insert_indexedByColumnName() {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, DIALECT);
        Table choiceTable = new Table("Choice");
        Column id = choiceTable.addColumn("id", Identifier.class).primaryKey();
        Column idx = choiceTable.addColumn("myIdx", Integer.TYPE);
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions choiceMappingConfiguration = MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel);
        EntityPersister questionPersister = MappingEase.entityBuilder(Question.class, Identifier.LONG_TYPE).mapKey(Question::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Question::getChoices, (EntityMappingConfigurationProvider)choiceMappingConfiguration).mappedBy(Choice::getQuestion).indexedBy(idx.getName()).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Question newQuestion = new Question(1L);
        newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{new Choice(10L), new Choice(20L), new Choice(30L)}));
        questionPersister.insert((Object)newQuestion);
        PersistenceContext.ExecutableBeanPropertyQueryMapper resultExecutableQuery = this.persistenceContext.newQuery((QueryProvider)QueryEase.select((Selectable)id, (Selectable[])new Selectable[]{idx}).from((Fromable)choiceTable).orderBy(id, new Column[0]), Result.class).mapKey((SerializableFunction & Serializable)x$0 -> new Result((Identifier)x$0), id).map(idx, (SerializableBiConsumer & Serializable)(rec$, x$0) -> ((Result)rec$).setIdx(x$0));
        Set persistedChoices = (Set)resultExecutableQuery.execute(Accumulators.toKeepingOrderSet());
        Assertions.assertThat((Collection)persistedChoices).extracting(Result::getId).containsExactly((Object[])new Long[]{10L, 20L, 30L});
        Assertions.assertThat((Collection)persistedChoices).extracting(rec$ -> ((Result)rec$).getIdx()).containsExactly((Object[])new Integer[]{1, 2, 3});
    }

    @Test
    void crud_mappedBy() {
        PersistenceContext persistenceContext = new PersistenceContext(this.connectionProvider, DIALECT);
        Table choiceTable = new Table("Choice");
        Column id = choiceTable.addColumn("id", Identifier.class).primaryKey();
        Column idx = choiceTable.addColumn("idx", Integer.class);
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions choiceMappingConfiguration = MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel);
        EntityPersister questionPersister = MappingEase.entityBuilder(Question.class, Identifier.LONG_TYPE).mapKey(Question::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Question::getChoices, (EntityMappingConfigurationProvider)choiceMappingConfiguration).mappedBy(Choice::getQuestion).indexedBy(idx).cascading(CascadeOptions.RelationMode.ALL).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Question question = new Question(new PersistableIdentifier<Long>(1L));
        Choice choice1 = new Choice(new PersistableIdentifier<Long>(13L));
        choice1.setLabel("Grenoble");
        question.addChoice(choice1);
        Choice choice2 = new Choice(new PersistableIdentifier<Long>(17L));
        choice2.setLabel("Lyon");
        question.addChoice(choice2);
        questionPersister.insert((Object)question);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = persistenceContext.newQuery((CharSequence)"select questionId from Choice", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "questionId", Long.class);
        Set choiceQuestionIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceQuestionIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)question.getId().getSurrogate()});
        Question loadedQuestion = (Question)questionPersister.select(question.getId());
        Assertions.assertThat(loadedQuestion.getChoices()).extracting(Choice::getLabel).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Lyon"});
        Assertions.assertThat((Object)((Choice)Iterables.first(loadedQuestion.getChoices())).getQuestion()).isEqualTo((Object)loadedQuestion);
        Question modifiedQuestion = new Question(question.getId());
        modifiedQuestion.addChoice((Choice)Iterables.first(question.getChoices()));
        questionPersister.update((Object)modifiedQuestion, (Object)question, false);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = persistenceContext.newQuery((CharSequence)"select questionId from Choice", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "questionId", Long.class);
        choiceQuestionIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceQuestionIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)question.getId().getSurrogate(), null});
        questionPersister.delete((Object)modifiedQuestion);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = persistenceContext.newQuery((CharSequence)"select questionId from Choice", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "questionId", Long.class);
        choiceQuestionIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
        ArrayList<Object> expectedResult = new ArrayList<Object>();
        expectedResult.add(null);
        Assertions.assertThat((Collection)choiceQuestionIds).containsExactlyElementsOf(expectedResult);
    }

    @Test
    void select() throws SQLException {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, DIALECT);
        Table choiceTable = new Table("Choice");
        Column id = choiceTable.addColumn("id", Identifier.class).primaryKey();
        Column idx = choiceTable.addColumn("idx", Integer.TYPE);
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions choiceMappingConfiguration = MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel);
        EntityPersister questionPersister = MappingEase.entityBuilder(Question.class, Identifier.LONG_TYPE).mapKey(Question::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Question::getChoices, (EntityMappingConfigurationProvider)choiceMappingConfiguration).mappedBy(Choice::getQuestion).indexedBy(idx).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Question newQuestion = new Question(1L);
        Choice choice1 = new Choice(10L);
        Choice choice2 = new Choice(20L);
        Choice choice3 = new Choice(30L);
        newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice3}));
        questionPersister.insert((Object)newQuestion);
        Question select = (Question)questionPersister.select(new PersistedIdentifier<Long>(1L));
        this.connectionProvider.giveConnection().commit();
        Assertions.assertThat(select.getChoices()).extracting(Functions.chain(Choice::getId, StatefulIdentifier::getSurrogate)).containsExactlyInAnyOrder((Object[])new Long[]{10L, 20L, 30L});
    }

    @Test
    void delete_reverseSideIsNotMapped_relationRecordsMustBeDeleted() {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, DIALECT);
        DuplicatesTestData duplicatesTestData = new DuplicatesTestData().build();
        EntityPersister<Question, Identifier<Long>> questionPersister = duplicatesTestData.getQuestionPersister();
        Question newQuestion = new Question(1L);
        Choice choice1 = new Choice(10L);
        Choice choice2 = new Choice(20L);
        Choice choice3 = new Choice(30L);
        newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice3}));
        questionPersister.insert((Object)newQuestion);
        Assertions.assertThat((boolean)choice1.getId().isPersisted()).isTrue();
        EntityPersister<Answer, Identifier<Long>> answerPersister = duplicatesTestData.getAnswerPersister();
        Answer answer = new Answer(1L);
        answer.takeChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice3}));
        answerPersister.persist((Object)answer);
        answerPersister.delete((Object)answer);
        long answerCount = (Long)this.persistenceContext.newQuery((CharSequence)"select count(id) as answerId from Answer", Long.TYPE).mapKey("answerId", Long.TYPE).execute(Accumulators.getFirst());
        Assertions.assertThat((long)answerCount).isEqualTo(0L);
        long relationCount = (Long)this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_Choices", Long.TYPE).mapKey("relationCount", Long.TYPE).execute(Accumulators.getFirst());
        Assertions.assertThat((long)relationCount).isEqualTo(0L);
        long choiceCount = (Long)this.persistenceContext.newQuery((CharSequence)"select count(id) as choiceCount from Choice", Long.TYPE).mapKey("choiceCount", Long.TYPE).execute(Accumulators.getFirst());
        Assertions.assertThat((long)choiceCount).isEqualTo(3L);
    }

    private class DuplicatesTestData {
        private EntityPersister<Question, Identifier<Long>> questionPersister;
        private EntityPersister<Answer, Identifier<Long>> answerPersister;
        private Table answerChoicesTable;
        private Column<Table, Identifier> answerChoicesTableId;
        private Column<Table, Integer> answerChoicesTableIdx;
        private Column<Table, Identifier> answerChoicesTableChoiceId;

        private DuplicatesTestData() {
        }

        public EntityPersister<Question, Identifier<Long>> getQuestionPersister() {
            return this.questionPersister;
        }

        public EntityPersister<Answer, Identifier<Long>> getAnswerPersister() {
            return this.answerPersister;
        }

        public Table getAnswerChoicesTable() {
            return this.answerChoicesTable;
        }

        public Column<Table, Identifier> getAnswerChoicesTableId() {
            return this.answerChoicesTableId;
        }

        public Column<Table, Integer> getAnswerChoicesTableIdx() {
            return this.answerChoicesTableIdx;
        }

        public Column<Table, Identifier> getAnswerChoicesTableChoiceId() {
            return this.answerChoicesTableChoiceId;
        }

        public DuplicatesTestData build() {
            Table choiceTable = new Table("Choice");
            Column id = choiceTable.addColumn("id", Identifier.class).primaryKey();
            Column idx = choiceTable.addColumn("idx", Integer.TYPE);
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions choiceMappingConfiguration = MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel);
            this.questionPersister = MappingEase.entityBuilder(Question.class, Identifier.LONG_TYPE).mapKey(Question::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Question::getChoices, (EntityMappingConfigurationProvider)choiceMappingConfiguration).mappedBy(Choice::getQuestion).indexedBy(idx).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext);
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions answerChoiceMappingConfiguration = MappingEase.entityBuilder(AnswerChoice.class, Identifier.LONG_TYPE).mapKey(AnswerChoice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(AnswerChoice::getLabel);
            this.answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)answerChoiceMappingConfiguration, choiceTable).cascading(CascadeOptions.RelationMode.ALL).indexed().build(FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext);
            this.answerChoicesTable = new Table("Answer_Choices");
            this.answerChoicesTableId = this.answerChoicesTable.addColumn("answer_Id", Identifier.class).primaryKey();
            this.answerChoicesTableIdx = this.answerChoicesTable.addColumn("idx", Integer.class).primaryKey();
            this.answerChoicesTableChoiceId = this.answerChoicesTable.addColumn("choices_Id", Identifier.class).primaryKey();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext);
            ddlDeployer.getDdlGenerator().addTables(this.answerChoicesTable, new Table[0]);
            ddlDeployer.deployDDL();
            return this;
        }
    }

    private class UpdateTestData {
        private Table choiceTable;
        private Column<Table, Identifier> id;
        private Column<Table, Integer> idx;
        private EntityPersister<Question, Identifier<Long>> questionPersister;
        private Question newQuestion;
        private Choice choice1;
        private Choice choice2;
        private Choice choice3;

        private UpdateTestData() {
        }

        public Table getChoiceTable() {
            return this.choiceTable;
        }

        public Column<Table, Identifier> getId() {
            return this.id;
        }

        public Column<Table, Integer> getIdx() {
            return this.idx;
        }

        public EntityPersister<Question, Identifier<Long>> getQuestionPersister() {
            return this.questionPersister;
        }

        public Question getNewQuestion() {
            return this.newQuestion;
        }

        public Choice getChoice1() {
            return this.choice1;
        }

        public Choice getChoice2() {
            return this.choice2;
        }

        public Choice getChoice3() {
            return this.choice3;
        }

        public UpdateTestData build() {
            FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportOneToManyListTest.this.connectionProvider, DIALECT);
            this.choiceTable = new Table("Choice");
            this.id = this.choiceTable.addColumn("id", Identifier.class).primaryKey();
            this.idx = this.choiceTable.addColumn("idx", Integer.TYPE);
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions choiceMappingConfiguration = MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel);
            this.questionPersister = MappingEase.entityBuilder(Question.class, Identifier.LONG_TYPE).mapKey(Question::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Question::getChoices, (EntityMappingConfigurationProvider)choiceMappingConfiguration).mappedBy(Choice::getQuestion).indexedBy(this.idx).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            this.newQuestion = new Question(1L);
            this.choice1 = new Choice(10L);
            this.choice2 = new Choice(20L);
            this.choice3 = new Choice(30L);
            this.newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{this.choice1, this.choice2, this.choice3}));
            this.questionPersister.insert((Object)this.newQuestion);
            PersistenceContext.ExecutableBeanPropertyQueryMapper resultExecutableQuery = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select(this.id, (Selectable[])new Selectable[]{this.idx}).from((Fromable)this.choiceTable).orderBy(this.id, new Column[0]), Result.class).mapKey((SerializableFunction & Serializable)x$0 -> new Result((Identifier)x$0), this.id).map(this.idx, (SerializableBiConsumer & Serializable)(rec$, x$0) -> ((Result)rec$).setIdx(x$0));
            Set persistedChoices = (Set)resultExecutableQuery.execute(Accumulators.toKeepingOrderSet());
            Assertions.assertThat((Collection)persistedChoices).extracting(Result::getId).containsExactly((Object[])new Long[]{10L, 20L, 30L});
            Assertions.assertThat((Collection)persistedChoices).extracting(rec$ -> ((Result)rec$).getIdx()).containsExactly((Object[])new Integer[]{1, 2, 3});
            return this;
        }
    }

    private static class Choice
    implements Identified<Long> {
        private Identifier<Long> id;
        private Question question;
        private Question questionWithNoGetter;
        private String label;

        public Choice() {
        }

        private Choice(long id) {
            this.id = new PersistableIdentifier<Long>(id);
        }

        public Choice(Identifier<Long> id) {
            this.id = id;
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public Question getQuestion() {
            return this.question;
        }

        public Choice setQuestion(Question question) {
            this.question = question;
            return this;
        }

        public void setQuestionWithNoGetter(Question question) {
            this.questionWithNoGetter = question;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Choice)) {
                return false;
            }
            Choice choice = (Choice)o;
            return Objects.equals(this.id, choice.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return "Choice{id=" + this.id.getSurrogate() + ", question=" + this.question + ", label='" + this.label + '\'' + '}';
        }
    }

    private static class RawAnswer {
        private Long answerId;
        private Integer choiceIdx;
        private Long choiceId;

        public RawAnswer() {
        }

        private RawAnswer(long answerId, int choiceIdx, long choiceId) {
            this.answerId = answerId;
            this.choiceIdx = choiceIdx;
            this.choiceId = choiceId;
        }

        private RawAnswer(Identifier<Long> answerId, int choiceIdx, Identifier<Long> choiceId) {
            this((Long)answerId.getSurrogate(), choiceIdx, (Long)choiceId.getSurrogate());
        }

        public Long getAnswerId() {
            return this.answerId;
        }

        public void setAnswerId(long answerId) {
            this.answerId = answerId;
        }

        public Integer getChoiceIdx() {
            return this.choiceIdx;
        }

        public void setChoiceIdx(int choiceIdx) {
            this.choiceIdx = choiceIdx;
        }

        public Long getChoiceId() {
            return this.choiceId;
        }

        public void setChoiceId(long choiceId) {
            this.choiceId = choiceId;
        }
    }

    public static class AnswerChoice
    implements Identified<Long> {
        private Identifier<Long> id;
        private String label;

        public AnswerChoice() {
        }

        private AnswerChoice(Choice choice) {
            this(choice.getId());
            this.setLabel(choice.getLabel());
        }

        private AnswerChoice(long id) {
            this.id = new PersistableIdentifier<Long>(id);
        }

        private AnswerChoice(Identifier<Long> id) {
            this.id = id;
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String toString() {
            return "AnswerChoice{id=" + this.id.getSurrogate() + ", label='" + this.label + '\'' + '}';
        }
    }

    public static class Answer
    implements Identified<Long> {
        private Identifier<Long> id;
        private List<AnswerChoice> choices = new ArrayList<AnswerChoice>();

        private Answer() {
        }

        private Answer(Long id) {
            this(new PersistableIdentifier<Long>(id));
        }

        private Answer(Identifier<Long> id) {
            this.id = id;
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public List<AnswerChoice> getChoices() {
            return this.choices;
        }

        public void takeChoices(List<Choice> choices) {
            this.choices = Iterables.collectToList(choices, x$0 -> new AnswerChoice((Choice)x$0));
        }

        public void setChoices(List<AnswerChoice> choices) {
            this.choices = choices;
        }
    }

    private static class Question
    implements Identified<Long> {
        private Identifier<Long> id;
        private String label;
        private List<Choice> choices = new ArrayList<Choice>();

        private Question() {
        }

        private Question(Long id) {
            this(new PersistableIdentifier<Long>(id));
        }

        private Question(Identifier<Long> id) {
            this.id = id;
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public List<Choice> getChoices() {
            return this.choices;
        }

        public void setChoices(List<Choice> choices) {
            this.choices = choices;
            choices.forEach(choice -> choice.setQuestion(this));
        }

        public void addChoice(Choice choice) {
            choice.setQuestion(this);
            this.choices.add(choice);
        }

        public void removeChoice(Choice choice) {
            this.choices.remove(choice);
            choice.setQuestion(null);
        }
    }

    private static class Result {
        private final long id;
        private int idx;

        private Result(Identifier<Long> id) {
            this.id = (Long)id.getSurrogate();
        }

        public long getId() {
            return this.id;
        }

        private int getIdx() {
            return this.idx;
        }

        private void setIdx(Integer idx) {
            this.idx = idx;
        }
    }

    @Nested
    class WithDuplicates {
        WithDuplicates() {
        }

        @Test
        void insert() {
            FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportOneToManyListTest.this.connectionProvider, DIALECT);
            DuplicatesTestData duplicatesTestData = new DuplicatesTestData().build();
            EntityPersister<Question, Identifier<Long>> questionPersister = duplicatesTestData.getQuestionPersister();
            EntityPersister<Answer, Identifier<Long>> answerPersister = duplicatesTestData.getAnswerPersister();
            Table answerChoicesTable = duplicatesTestData.getAnswerChoicesTable();
            Column<Table, Identifier> answerChoicesTableId = duplicatesTestData.getAnswerChoicesTableId();
            Column<Table, Integer> answerChoicesTableIdx = duplicatesTestData.getAnswerChoicesTableIdx();
            Column<Table, Identifier> answerChoicesTableChoiceId = duplicatesTestData.getAnswerChoicesTableChoiceId();
            Question newQuestion = new Question(1L);
            Choice choice1 = new Choice(10L);
            Choice choice2 = new Choice(20L);
            Choice choice3 = new Choice(30L);
            newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice3}));
            questionPersister.insert((Object)newQuestion);
            Answer answer = new Answer(1L);
            answer.takeChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice2, choice3}));
            answerPersister.insert((Object)answer);
            PersistenceContext.ExecutableBeanPropertyKeyQueryMapper query = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select(answerChoicesTableId, (Selectable[])new Selectable[]{answerChoicesTableIdx, answerChoicesTableChoiceId}).from((Fromable)answerChoicesTable).orderBy(answerChoicesTableIdx, new Column[0]), RawAnswer.class);
            PersistenceContext.ExecutableBeanPropertyQueryMapper rawAnswerExecutableQuery = query.mapKey((SerializableTriFunction & Serializable)(x$0, x$1, x$2) -> new RawAnswer((Identifier)x$0, (int)x$1, (Identifier)x$2), answerChoicesTableId, answerChoicesTableIdx, answerChoicesTableChoiceId);
            Set persistedChoices = (Set)rawAnswerExecutableQuery.execute(Accumulators.toKeepingOrderSet());
            Assertions.assertThat((Collection)persistedChoices).extracting(RawAnswer::getChoiceId).containsExactly((Object[])new Long[]{10L, 20L, 20L, 30L});
            Assertions.assertThat((Collection)persistedChoices).extracting(RawAnswer::getChoiceIdx).containsExactly((Object[])new Integer[]{1, 2, 3, 4});
        }

        @Test
        void select_default() {
            FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportOneToManyListTest.this.connectionProvider, DIALECT);
            DuplicatesTestData duplicatesTestData = new DuplicatesTestData().build();
            EntityPersister<Question, Identifier<Long>> questionPersister = duplicatesTestData.getQuestionPersister();
            EntityPersister<Answer, Identifier<Long>> answerPersister = duplicatesTestData.getAnswerPersister();
            Question newQuestion = new Question(1L);
            Choice choice1 = new Choice(10L);
            choice1.setLabel("toto");
            Choice choice2 = new Choice(20L);
            Choice choice3 = new Choice(30L);
            newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice3}));
            questionPersister.insert((Object)newQuestion);
            Answer answer = new Answer(1L);
            List choices = Arrays.asList((Object[])new Choice[]{choice1, choice2, choice2, choice3});
            Collections.shuffle(choices);
            answer.takeChoices(choices);
            answerPersister.insert((Object)answer);
            Answer selectedAnswer = (Answer)answerPersister.select(new PersistableIdentifier<Long>(1L));
            Assertions.assertThat((Long)((Long)selectedAnswer.getId().getSurrogate())).isEqualTo((Object)1L);
            Assertions.assertThat(selectedAnswer.getChoices()).extracting(new Function[]{AnswerChoice::getId, AnswerChoice::getLabel}).containsExactly((Object[])new Tuple[]{new Tuple(new Object[]{choice1.getId(), choice1.getLabel()}), new Tuple(new Object[]{choice2.getId(), choice2.getLabel()}), new Tuple(new Object[]{choice2.getId(), choice2.getLabel()}), new Tuple(new Object[]{choice3.getId(), choice3.getLabel()})});
        }

        @Test
        void select_targets() {
            FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportOneToManyListTest.this.connectionProvider, DIALECT);
            DuplicatesTestData duplicatesTestData = new DuplicatesTestData().build();
            EntityPersister<Question, Identifier<Long>> questionPersister = duplicatesTestData.getQuestionPersister();
            Question newQuestion = new Question(1L);
            Choice choice1 = new Choice(10L);
            Choice choice2 = new Choice(20L);
            Choice choice3 = new Choice(30L);
            List randomizedOrderChoices = Arrays.asList((Object[])new Choice[]{choice2, choice1, choice3});
            Collections.shuffle(randomizedOrderChoices);
            newQuestion.setChoices(randomizedOrderChoices);
            questionPersister.insert((Object)newQuestion);
            Long loadedId = (Long)FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((CharSequence)"select id from CHOICE where id = :id", Long.class).mapKey("id", Long.class).set("id", (Object)10L).execute(Accumulators.getFirstUnique());
            Assertions.assertThat((Long)loadedId).isEqualTo(choice1.getId().getSurrogate());
            Question loadedQuestion = (Question)duplicatesTestData.questionPersister.select(new PersistableIdentifier<Long>(1L));
            Assertions.assertThat(loadedQuestion.getChoices()).isEqualTo(newQuestion.getChoices());
        }

        @Test
        void delete() {
            FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportOneToManyListTest.this.connectionProvider, DIALECT);
            DuplicatesTestData duplicatesTestData = new DuplicatesTestData().build();
            EntityPersister<Question, Identifier<Long>> questionPersister = duplicatesTestData.getQuestionPersister();
            EntityPersister<Answer, Identifier<Long>> answerPersister = duplicatesTestData.getAnswerPersister();
            Question newQuestion = new Question(1L);
            Choice choice1 = new Choice(10L);
            Choice choice2 = new Choice(20L);
            Choice choice3 = new Choice(30L);
            newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice3}));
            questionPersister.insert((Object)newQuestion);
            Answer answer = new Answer(1L);
            answer.takeChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice2, choice3}));
            answerPersister.insert((Object)answer);
            Answer loadedAnswer = (Answer)answerPersister.select(answer.getId());
            answer.getChoices().remove(1);
            answerPersister.update((Object)answer, (Object)loadedAnswer, true);
            Answer loadedAnswer2 = (Answer)answerPersister.select(answer.getId());
            Assertions.assertThat(loadedAnswer2.getChoices()).usingRecursiveComparison().isEqualTo((Object)Arrays.asList((Object[])new AnswerChoice[]{new AnswerChoice(choice1), new AnswerChoice(choice2), new AnswerChoice(choice3)}));
            answerPersister.delete((Object)answer);
            Table answerChoicesTable = duplicatesTestData.getAnswerChoicesTable();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select((String)"count(*) as c", Long.TYPE).from((Fromable)answerChoicesTable), Long.class).mapKey("c", Long.TYPE);
            Set persistedChoices = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Long)((Long)Iterables.first((Iterable)persistedChoices))).isEqualTo((Object)0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice", Long.class).mapKey("id", Long.TYPE);
            Set remainingChoices = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat(new HashSet(remainingChoices)).isEqualTo((Object)Arrays.asSet((Object[])new Long[]{(Long)choice1.getId().getSurrogate(), (Long)choice2.getId().getSurrogate(), (Long)choice3.getId().getSurrogate()}));
        }

        @Test
        void deleteById() {
            FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportOneToManyListTest.this.connectionProvider, DIALECT);
            DuplicatesTestData duplicatesTestData = new DuplicatesTestData().build();
            EntityPersister<Question, Identifier<Long>> questionPersister = duplicatesTestData.getQuestionPersister();
            EntityPersister<Answer, Identifier<Long>> answerPersister = duplicatesTestData.getAnswerPersister();
            Question newQuestion = new Question(1L);
            Choice choice1 = new Choice(10L);
            Choice choice2 = new Choice(20L);
            Choice choice3 = new Choice(30L);
            newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice3}));
            questionPersister.insert((Object)newQuestion);
            Answer answer = new Answer(1L);
            answer.takeChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice2, choice3}));
            answerPersister.insert((Object)answer);
            answerPersister.deleteById((Object)answer);
            Table answerChoicesTable = duplicatesTestData.getAnswerChoicesTable();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((Query)QueryEase.select((String)"count(*) as c", Long.TYPE).from((Fromable)answerChoicesTable).getQuery(), Long.class).mapKey("c", Long.TYPE);
            Set persistedChoices = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Long)((Long)Iterables.first((Iterable)persistedChoices))).isEqualTo((Object)0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice", Long.class).mapKey("id", Long.TYPE);
            Set remainingChoices = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat(new HashSet(remainingChoices)).isEqualTo((Object)Arrays.asSet((Object[])new Long[]{(Long)choice1.getId().getSurrogate(), (Long)choice2.getId().getSurrogate(), (Long)choice3.getId().getSurrogate()}));
        }

        @Test
        void update() {
            FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportOneToManyListTest.this.connectionProvider, DIALECT);
            DuplicatesTestData duplicatesTestData = new DuplicatesTestData().build();
            EntityPersister<Question, Identifier<Long>> questionPersister = duplicatesTestData.getQuestionPersister();
            EntityPersister<Answer, Identifier<Long>> answerPersister = duplicatesTestData.getAnswerPersister();
            Table answerChoicesTable = duplicatesTestData.getAnswerChoicesTable();
            Column<Table, Identifier> answerChoicesTableId = duplicatesTestData.getAnswerChoicesTableId();
            Column<Table, Integer> answerChoicesTableIdx = duplicatesTestData.getAnswerChoicesTableIdx();
            Column<Table, Identifier> answerChoicesTableChoiceId = duplicatesTestData.getAnswerChoicesTableChoiceId();
            Question newQuestion = new Question(1L);
            Choice choice1 = new Choice(10L);
            Choice choice2 = new Choice(20L);
            Choice choice3 = new Choice(30L);
            Choice choice4 = new Choice(40L);
            newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice3, choice4}));
            questionPersister.insert((Object)newQuestion);
            Answer answer = new Answer(1L);
            List choices = Arrays.asList((Object[])new Choice[]{choice1, choice2, choice2, choice3});
            answer.takeChoices(choices);
            answerPersister.insert((Object)answer);
            Choice newChoice = new Choice(50L);
            newChoice.setQuestion(newQuestion);
            newQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice3, choice4, newChoice}));
            questionPersister.update((Object)newQuestion);
            Answer selectedAnswer = (Answer)answerPersister.select(new PersistableIdentifier<Long>(1L));
            selectedAnswer.takeChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, newChoice, choice2, choice3, choice1, choice4}));
            answerPersister.update((Object)selectedAnswer, (Object)answer, true);
            PersistenceContext.ExecutableBeanPropertyKeyQueryMapper query = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select(answerChoicesTableId, (Selectable[])new Selectable[]{answerChoicesTableIdx, answerChoicesTableChoiceId}).from((Fromable)answerChoicesTable).orderBy(answerChoicesTableIdx, new Column[0]), RawAnswer.class);
            PersistenceContext.ExecutableBeanPropertyQueryMapper rawAnswerExecutableQuery1 = query.mapKey((SerializableTriFunction & Serializable)(x$0, x$1, x$2) -> new RawAnswer((Identifier)x$0, (int)x$1, (Identifier)x$2), answerChoicesTableId, answerChoicesTableIdx, answerChoicesTableChoiceId);
            Set persistedChoices = (Set)rawAnswerExecutableQuery1.execute(Accumulators.toKeepingOrderSet());
            Assertions.assertThat((Collection)persistedChoices).extracting(RawAnswer::getChoiceId).containsExactly((Object[])new Long[]{10L, 20L, 50L, 20L, 30L, 10L, 40L});
            Assertions.assertThat((Collection)persistedChoices).extracting(RawAnswer::getChoiceIdx).containsExactly((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});
            Answer selectedAnswer1 = (Answer)answerPersister.select(new PersistableIdentifier<Long>(1L));
            selectedAnswer1.takeChoices(Arrays.asList((Object[])new Choice[]{choice1, choice2, choice1}));
            answerPersister.update((Object)selectedAnswer1, (Object)selectedAnswer, true);
            query = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select(answerChoicesTableId, (Selectable[])new Selectable[]{answerChoicesTableIdx, answerChoicesTableChoiceId}).from((Fromable)answerChoicesTable).orderBy(answerChoicesTableIdx, new Column[0]), RawAnswer.class);
            PersistenceContext.ExecutableBeanPropertyQueryMapper rawAnswerExecutableQuery = query.mapKey((SerializableTriFunction & Serializable)(x$0, x$1, x$2) -> new RawAnswer((Identifier)x$0, (int)x$1, (Identifier)x$2), answerChoicesTableId, answerChoicesTableIdx, answerChoicesTableChoiceId);
            persistedChoices = (Set)rawAnswerExecutableQuery.execute(Accumulators.toKeepingOrderSet());
            Assertions.assertThat((Collection)persistedChoices).extracting(RawAnswer::getChoiceId).containsExactly((Object[])new Long[]{10L, 20L, 10L});
            Assertions.assertThat((Collection)persistedChoices).extracting(RawAnswer::getChoiceIdx).containsExactly((Object[])new Integer[]{1, 2, 3});
        }
    }

    @Nested
    class Update {
        Update() {
        }

        @Test
        void update_entitySwapping() {
            UpdateTestData updateTestData = new UpdateTestData().build();
            Table choiceTable = updateTestData.getChoiceTable();
            Column<Table, Identifier> id = updateTestData.getId();
            Column<Table, Integer> idx = updateTestData.getIdx();
            EntityPersister<Question, Identifier<Long>> questionPersister = updateTestData.getQuestionPersister();
            Question newQuestion = updateTestData.getNewQuestion();
            Choice choice1Clone = new Choice(updateTestData.getChoice1().getId());
            Choice choice2Clone = new Choice(updateTestData.getChoice2().getId());
            Choice choice3Clone = new Choice(updateTestData.getChoice3().getId());
            Question modifiedQuestion = new Question((Long)newQuestion.getId().getSurrogate());
            modifiedQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice2Clone, choice1Clone, choice3Clone}));
            questionPersister.update((Object)modifiedQuestion, (Object)newQuestion, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper resultExecutableQuery = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select(id, (Selectable[])new Selectable[]{idx}).from((Fromable)choiceTable).orderBy(id, new Column[0]), Result.class).mapKey((SerializableFunction & Serializable)x$0 -> new Result((Identifier)x$0), id).map(idx, (SerializableBiConsumer & Serializable)(rec$, x$0) -> ((Result)rec$).setIdx(x$0));
            Set persistedChoices = (Set)resultExecutableQuery.execute(Accumulators.toKeepingOrderSet());
            Assertions.assertThat((Collection)persistedChoices).extracting(Result::getId).containsExactly((Object[])new Long[]{10L, 20L, 30L});
            Assertions.assertThat((Collection)persistedChoices).extracting(rec$ -> ((Result)rec$).getIdx()).containsExactly((Object[])new Integer[]{2, 1, 3});
        }

        @Test
        void update_noChange() {
            UpdateTestData updateTestData = new UpdateTestData().build();
            Table choiceTable = updateTestData.getChoiceTable();
            Column<Table, Identifier> id = updateTestData.getId();
            Column<Table, Integer> idx = updateTestData.getIdx();
            EntityPersister<Question, Identifier<Long>> questionPersister = updateTestData.getQuestionPersister();
            Question newQuestion = updateTestData.getNewQuestion();
            Question modifiedQuestion = new Question((Long)newQuestion.getId().getSurrogate());
            modifiedQuestion.setChoices(newQuestion.getChoices());
            questionPersister.update((Object)modifiedQuestion, (Object)newQuestion, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper resultExecutableQuery = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select(id, (Selectable[])new Selectable[]{idx}).from((Fromable)choiceTable).orderBy(id, new Column[0]), Result.class).mapKey((SerializableFunction & Serializable)x$0 -> new Result((Identifier)x$0), id).map(idx, (SerializableBiConsumer & Serializable)(rec$, x$0) -> ((Result)rec$).setIdx(x$0));
            Set persistedChoices = (Set)resultExecutableQuery.execute(Accumulators.toKeepingOrderSet());
            Assertions.assertThat((Collection)persistedChoices).extracting(Result::getId).containsExactly((Object[])new Long[]{10L, 20L, 30L});
            Assertions.assertThat((Collection)persistedChoices).extracting(rec$ -> ((Result)rec$).getIdx()).containsExactly((Object[])new Integer[]{1, 2, 3});
        }

        @Test
        void update_entityAddition() {
            UpdateTestData updateTestData = new UpdateTestData().build();
            Table choiceTable = updateTestData.getChoiceTable();
            Column<Table, Identifier> id = updateTestData.getId();
            Column<Table, Integer> idx = updateTestData.getIdx();
            EntityPersister<Question, Identifier<Long>> questionPersister = updateTestData.getQuestionPersister();
            Question newQuestion = updateTestData.getNewQuestion();
            Choice choice1Clone = new Choice(updateTestData.getChoice1().getId());
            Choice choice2Clone = new Choice(updateTestData.getChoice2().getId());
            Choice choice3Clone = new Choice(updateTestData.getChoice3().getId());
            Choice choice4 = new Choice(40L);
            Question modifiedQuestion = new Question((Long)newQuestion.getId().getSurrogate());
            modifiedQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice3Clone, choice4, choice2Clone, choice1Clone}));
            questionPersister.update((Object)modifiedQuestion, (Object)newQuestion, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper resultExecutableQuery = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select(id, (Selectable[])new Selectable[]{idx}).from((Fromable)choiceTable).orderBy(id, new Column[0]), Result.class).mapKey((SerializableFunction & Serializable)x$0 -> new Result((Identifier)x$0), id).map(idx, (SerializableBiConsumer & Serializable)(rec$, x$0) -> ((Result)rec$).setIdx(x$0));
            Set persistedChoices = (Set)resultExecutableQuery.execute(Accumulators.toKeepingOrderSet());
            Assertions.assertThat((Collection)persistedChoices).extracting(Result::getId).containsExactly((Object[])new Long[]{10L, 20L, 30L, 40L});
            Assertions.assertThat((Collection)persistedChoices).extracting(rec$ -> ((Result)rec$).getIdx()).containsExactly((Object[])new Integer[]{4, 3, 1, 2});
        }

        @Test
        void update_entityRemoval() {
            UpdateTestData updateTestData = new UpdateTestData().build();
            Table choiceTable = updateTestData.getChoiceTable();
            Column<Table, Identifier> id = updateTestData.getId();
            Column<Table, Integer> idx = updateTestData.getIdx();
            EntityPersister<Question, Identifier<Long>> questionPersister = updateTestData.getQuestionPersister();
            Question newQuestion = updateTestData.getNewQuestion();
            Choice choice1 = updateTestData.getChoice1();
            Choice choice3 = updateTestData.getChoice3();
            Question modifiedQuestion = new Question((Long)newQuestion.getId().getSurrogate());
            Choice choice3Copy = new Choice(new PersistedIdentifier<Long>((Long)choice3.getId().getSurrogate()));
            Choice choice1Copy = new Choice(new PersistedIdentifier<Long>((Long)choice1.getId().getSurrogate()));
            modifiedQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice3Copy, choice1Copy}));
            questionPersister.update((Object)modifiedQuestion, (Object)newQuestion, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper resultExecutableQuery = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select(id, (Selectable[])new Selectable[]{idx}).from((Fromable)choiceTable).orderBy(id, new Column[0]), Result.class).mapKey((SerializableFunction & Serializable)x$0 -> new Result((Identifier)x$0), id).map(idx, (SerializableBiConsumer & Serializable)(rec$, x$0) -> ((Result)rec$).setIdx(x$0));
            Set persistedChoices = (Set)resultExecutableQuery.execute(Accumulators.toKeepingOrderSet());
            Assertions.assertThat((Collection)persistedChoices).extracting(Result::getId).containsExactly((Object[])new Long[]{10L, 30L});
            Assertions.assertThat((Collection)persistedChoices).extracting(rec$ -> ((Result)rec$).getIdx()).containsExactly((Object[])new Integer[]{2, 1});
        }

        @Test
        void update_entityRemoval_entitiesAreSameObjectReference() {
            UpdateTestData updateTestData = new UpdateTestData().build();
            Table choiceTable = updateTestData.getChoiceTable();
            Column<Table, Identifier> id = updateTestData.getId();
            Column<Table, Integer> idx = updateTestData.getIdx();
            EntityPersister<Question, Identifier<Long>> questionPersister = updateTestData.getQuestionPersister();
            Question newQuestion = updateTestData.getNewQuestion();
            Choice choice1Clone = new Choice(updateTestData.getChoice1().getId());
            Choice choice3Clone = new Choice(updateTestData.getChoice3().getId());
            Question modifiedQuestion = new Question((Long)newQuestion.getId().getSurrogate());
            modifiedQuestion.setChoices(Arrays.asList((Object[])new Choice[]{choice3Clone, choice1Clone}));
            questionPersister.update((Object)modifiedQuestion, (Object)newQuestion, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper resultExecutableQuery = FluentEntityMappingConfigurationSupportOneToManyListTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select(id, (Selectable[])new Selectable[]{idx}).from((Fromable)choiceTable).orderBy(id, new Column[0]), Result.class).mapKey((SerializableFunction & Serializable)x$0 -> new Result((Identifier)x$0), id).map(idx, (SerializableBiConsumer & Serializable)(rec$, x$0) -> ((Result)rec$).setIdx(x$0));
            Set persistedChoices = (Set)resultExecutableQuery.execute(Accumulators.toKeepingOrderSet());
            Assertions.assertThat((Collection)persistedChoices).extracting(Result::getId).containsExactly((Object[])new Long[]{10L, 30L});
            Assertions.assertThat((Collection)persistedChoices).extracting(rec$ -> ((Result)rec$).getIdx()).containsExactly((Object[])new Integer[]{2, 1});
        }

        @Test
        void update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities_list() throws SQLException {
            PersistenceContext persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportOneToManyListTest.this.connectionProvider, DIALECT);
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions choiceMappingConfiguration = MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel);
            EntityPersister questionPersister = MappingEase.entityBuilder(Question.class, Identifier.LONG_TYPE).mapKey(Question::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Question::getLabel).mapOneToMany(Question::getChoices, (EntityMappingConfigurationProvider)choiceMappingConfiguration).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
            ddlDeployer.deployDDL();
            persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200)");
            Question question = new Question(new PersistableIdentifier<Long>(42L));
            Choice choice1 = new Choice(new PersistableIdentifier<Long>(100L));
            Choice choice2 = new Choice(new PersistableIdentifier<Long>(200L));
            question.addChoice(choice1);
            question.addChoice(choice2);
            questionPersister.insert((Object)question);
            question.setLabel("What's your name ?");
            choice1.setLabel("John");
            questionPersister.update((Object)question, questionPersister.select(question.getId()), true);
            ResultSet resultSet = persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select label from Question where id = 42");
            RowIterator questionIterator = new RowIterator(resultSet, (Map)Maps.asMap((Object)"label", (Object)DefaultParameterBinders.STRING_BINDER));
            Assertions.assertThat((List)Iterables.collectToList(() -> Update.lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities_list$5((ResultSetIterator)questionIterator), row -> row.get("label"))).isEqualTo((Object)Arrays.asList((Object[])new String[]{"What's your name ?"}));
            resultSet = persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select label from Choice where id = 100");
            RowIterator choiceIterator = new RowIterator(resultSet, (Map)Maps.asMap((Object)"label", (Object)DefaultParameterBinders.STRING_BINDER));
            Assertions.assertThat((List)Iterables.collectToList(() -> Update.lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities_list$7((ResultSetIterator)choiceIterator), row -> row.get("label"))).isEqualTo((Object)Arrays.asList((Object[])new Object[]{null}));
            Assertions.assertThat((int)question.getChoices().size()).isEqualTo(2);
            question.getChoices().remove(choice1);
            Assertions.assertThat((int)question.getChoices().size()).isEqualTo(1);
            questionPersister.update((Object)question, questionPersister.select(question.getId()), true);
            resultSet = persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select label from Choice where id = 100");
            RowIterator choiceIterator2 = new RowIterator(resultSet, (Map)Maps.asMap((Object)"label", (Object)DefaultParameterBinders.STRING_BINDER));
            Assertions.assertThat((List)Iterables.collectToList(() -> Update.lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities_list$9((ResultSetIterator)choiceIterator2), row -> row.get("label"))).isEqualTo((Object)Arrays.asList((Object[])new Object[]{null}));
        }

        private static /* synthetic */ Iterator lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities_list$9(ResultSetIterator choiceIterator2) {
            return choiceIterator2;
        }

        private static /* synthetic */ Iterator lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities_list$7(ResultSetIterator choiceIterator) {
            return choiceIterator;
        }

        private static /* synthetic */ Iterator lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities_list$5(ResultSetIterator questionIterator) {
            return questionIterator;
        }
    }
}

