/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.bean;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.query.bean.BeanQueryMethod;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.collection.Arrays;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;

public class BeanRepositoryQuery<C>
implements RepositoryQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private final BeanQueryMethod queryMethod;
    private final EntityPersister.ExecutableEntityQuery<C, ?> sql;
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final Accumulator<C, ?, ?> accumulator;
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;

    public BeanRepositoryQuery(BeanQueryMethod queryMethod, EntityPersister.ExecutableEntityQuery<C, ?> sql, AdvancedEntityPersister<C, ?> entityPersister, Accumulator<C, ?, ?> accumulator, Dialect dialect, ConnectionProvider connectionProvider) {
        this.queryMethod = queryMethod;
        this.sql = sql;
        this.entityPersister = entityPersister;
        this.accumulator = accumulator;
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
        if (queryMethod.isSliceQuery()) {
            throw new UnsupportedOperationException("Slice queries are not supported using string-based queries. Offending method: " + (Object)((Object)queryMethod));
        }
        if (queryMethod.isPageQuery()) {
            throw new UnsupportedOperationException("Page queries are not supported using string-based queries. Offending method: " + (Object)((Object)queryMethod));
        }
    }

    public BeanQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)this.queryMethod.getParameters(), parameters);
        this.getValues(accessor).forEach((arg_0, arg_1) -> this.sql.set(arg_0, arg_1));
        return this.sql.execute(this.accumulator);
    }

    private Map<String, Object> getValues(ParametersParameterAccessor accessor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (RelationalParameters.RelationalParameter bindableParameter : (RelationalParameters)this.queryMethod.getParameters().getBindableParameters()) {
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            Object value = accessor.getBindableValue(bindableParameter.getIndex());
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                value = values.length == 1 ? values[0] : Arrays.asList((Object[])values);
            }
            result.put(parameterName, value);
        }
        return result;
    }
}

